/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.marketplace;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmountRange;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.utils.StringHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="ad_interests")
public class AdInterest
extends NamedEntity
implements HasCurrency,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @ReadOnlyFromDTO(onInsert=false)
    @JoinColumn(name="owner_id", nullable=false)
    private User owner;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="category_id")
    private AdCategory category;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private User user;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="min", column=@Column(name="min_price")), @AttributeOverride(name="max", column=@Column(name="max_price"))})
    private CurrencyAmountRange priceRange;
    @Basic
    @Column(name="keyword0")
    private String keyword0;
    @Basic
    @Column(name="keyword1")
    private String keyword1;
    @Basic
    @Column(name="keyword2")
    private String keyword2;
    @Basic
    @Column(name="keyword3")
    private String keyword3;
    @Basic
    @Column(name="keyword4")
    private String keyword4;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="ad_type")
    private AdType adType;
    static final long serialVersionUID = -1186285618243551698L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_owner_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_category_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    public AdType getAdType() {
        return this._persistence_get_adType();
    }

    public AdCategory getCategory() {
        return this._persistence_get_category();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_priceRange() == null ? null : this._persistence_get_priceRange().getCurrency();
    }

    public Set<String> getKeywords() {
        HashSet<String> hashSet = new HashSet<String>();
        if (StringHelper.isNotBlank((Object)this._persistence_get_keyword0())) {
            hashSet.add(this._persistence_get_keyword0());
        }
        if (StringHelper.isNotBlank((Object)this._persistence_get_keyword1())) {
            hashSet.add(this._persistence_get_keyword1());
        }
        if (StringHelper.isNotBlank((Object)this._persistence_get_keyword2())) {
            hashSet.add(this._persistence_get_keyword2());
        }
        if (StringHelper.isNotBlank((Object)this._persistence_get_keyword3())) {
            hashSet.add(this._persistence_get_keyword3());
        }
        if (StringHelper.isNotBlank((Object)this._persistence_get_keyword4())) {
            hashSet.add(this._persistence_get_keyword4());
        }
        return hashSet;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_owner().getNetwork();
    }

    public User getOwner() {
        return this._persistence_get_owner();
    }

    public CurrencyAmountRange getPriceRange() {
        return this._persistence_get_priceRange();
    }

    public User getUser() {
        return this._persistence_get_user();
    }

    public void setAdType(AdType adType) {
        this._persistence_set_adType(adType);
    }

    public void setCategory(AdCategory adCategory) {
        this._persistence_set_category(adCategory);
    }

    public void setKeywords(Set<String> set) {
        int n = 0;
        for (String string : set) {
            if ((string = StringHelper.trimToNull((Object)string)) != null) {
                this.setKeyword(n++, string);
            }
            if (n != 5) continue;
            break;
        }
        for (int i = n; i < 5; ++i) {
            this.setKeyword(i, null);
        }
    }

    public void setOwner(User user) {
        this._persistence_set_owner(user);
    }

    public void setPriceRange(CurrencyAmountRange currencyAmountRange) {
        this._persistence_set_priceRange(currencyAmountRange);
    }

    public void setUser(User user) {
        this._persistence_set_user(user);
    }

    private void setKeyword(int n, String string) {
        switch (n) {
            case 0: {
                this._persistence_set_keyword0(string);
                break;
            }
            case 1: {
                this._persistence_set_keyword1(string);
                break;
            }
            case 2: {
                this._persistence_set_keyword2(string);
                break;
            }
            case 3: {
                this._persistence_set_keyword3(string);
                break;
            }
            case 4: {
                this._persistence_set_keyword4(string);
            }
        }
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_owner_vh != null) {
            this._persistence_owner_vh = (WeavedAttributeValueHolderInterface)this._persistence_owner_vh.clone();
        }
        if (this._persistence_category_vh != null) {
            this._persistence_category_vh = (WeavedAttributeValueHolderInterface)this._persistence_category_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AdInterest();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "owner") {
            return this.owner;
        }
        if (string == "keyword3") {
            return this.keyword3;
        }
        if (string == "keyword4") {
            return this.keyword4;
        }
        if (string == "keyword1") {
            return this.keyword1;
        }
        if (string == "keyword2") {
            return this.keyword2;
        }
        if (string == "keyword0") {
            return this.keyword0;
        }
        if (string == "adType") {
            return this.adType;
        }
        if (string == "category") {
            return this.category;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "priceRange") {
            return this.priceRange;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "owner") {
            this.owner = (User)object;
            return;
        }
        if (string == "keyword3") {
            this.keyword3 = (String)object;
            return;
        }
        if (string == "keyword4") {
            this.keyword4 = (String)object;
            return;
        }
        if (string == "keyword1") {
            this.keyword1 = (String)object;
            return;
        }
        if (string == "keyword2") {
            this.keyword2 = (String)object;
            return;
        }
        if (string == "keyword0") {
            this.keyword0 = (String)object;
            return;
        }
        if (string == "adType") {
            this.adType = (AdType)object;
            return;
        }
        if (string == "category") {
            this.category = (AdCategory)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "priceRange") {
            this.priceRange = (CurrencyAmountRange)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_owner_vh() {
        if (this._persistence_owner_vh == null) {
            this._persistence_owner_vh = new ValueHolder((Object)this.owner);
            this._persistence_owner_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_owner_vh() {
        User user;
        this._persistence_initialize_owner_vh();
        if ((this._persistence_owner_vh.isCoordinatedWithProperty() || this._persistence_owner_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_owner()) != this._persistence_owner_vh.getValue()) {
            this._persistence_set_owner(user);
        }
        return this._persistence_owner_vh;
    }

    public void _persistence_set_owner_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_owner_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_owner();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_owner((User)object);
            }
        } else {
            this.owner = null;
        }
    }

    public User _persistence_get_owner() {
        this._persistence_checkFetched("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        return this.owner;
    }

    public void _persistence_set_owner(User user) {
        this._persistence_checkFetchedForSet("owner");
        this._persistence_initialize_owner_vh();
        this.owner = (User)this._persistence_owner_vh.getValue();
        this._persistence_propertyChange("owner", this.owner, user);
        this.owner = user;
        this._persistence_owner_vh.setValue((Object)user);
    }

    public String _persistence_get_keyword3() {
        this._persistence_checkFetched("keyword3");
        return this.keyword3;
    }

    public void _persistence_set_keyword3(String string) {
        this._persistence_checkFetchedForSet("keyword3");
        this._persistence_propertyChange("keyword3", this.keyword3, string);
        this.keyword3 = string;
    }

    public String _persistence_get_keyword4() {
        this._persistence_checkFetched("keyword4");
        return this.keyword4;
    }

    public void _persistence_set_keyword4(String string) {
        this._persistence_checkFetchedForSet("keyword4");
        this._persistence_propertyChange("keyword4", this.keyword4, string);
        this.keyword4 = string;
    }

    public String _persistence_get_keyword1() {
        this._persistence_checkFetched("keyword1");
        return this.keyword1;
    }

    public void _persistence_set_keyword1(String string) {
        this._persistence_checkFetchedForSet("keyword1");
        this._persistence_propertyChange("keyword1", this.keyword1, string);
        this.keyword1 = string;
    }

    public String _persistence_get_keyword2() {
        this._persistence_checkFetched("keyword2");
        return this.keyword2;
    }

    public void _persistence_set_keyword2(String string) {
        this._persistence_checkFetchedForSet("keyword2");
        this._persistence_propertyChange("keyword2", this.keyword2, string);
        this.keyword2 = string;
    }

    public String _persistence_get_keyword0() {
        this._persistence_checkFetched("keyword0");
        return this.keyword0;
    }

    public void _persistence_set_keyword0(String string) {
        this._persistence_checkFetchedForSet("keyword0");
        this._persistence_propertyChange("keyword0", this.keyword0, string);
        this.keyword0 = string;
    }

    public AdType _persistence_get_adType() {
        this._persistence_checkFetched("adType");
        return this.adType;
    }

    public void _persistence_set_adType(AdType adType) {
        this._persistence_checkFetchedForSet("adType");
        this._persistence_propertyChange("adType", this.adType, adType);
        this.adType = adType;
    }

    protected void _persistence_initialize_category_vh() {
        if (this._persistence_category_vh == null) {
            this._persistence_category_vh = new ValueHolder((Object)this.category);
            this._persistence_category_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_category_vh() {
        AdCategory adCategory;
        this._persistence_initialize_category_vh();
        if ((this._persistence_category_vh.isCoordinatedWithProperty() || this._persistence_category_vh.isNewlyWeavedValueHolder()) && (adCategory = this._persistence_get_category()) != this._persistence_category_vh.getValue()) {
            this._persistence_set_category(adCategory);
        }
        return this._persistence_category_vh;
    }

    public void _persistence_set_category_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_category_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AdCategory adCategory = this._persistence_get_category();
            if (adCategory != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_category((AdCategory)object);
            }
        } else {
            this.category = null;
        }
    }

    public AdCategory _persistence_get_category() {
        this._persistence_checkFetched("category");
        this._persistence_initialize_category_vh();
        this.category = (AdCategory)this._persistence_category_vh.getValue();
        return this.category;
    }

    public void _persistence_set_category(AdCategory adCategory) {
        this._persistence_checkFetchedForSet("category");
        this._persistence_initialize_category_vh();
        this.category = (AdCategory)this._persistence_category_vh.getValue();
        this._persistence_propertyChange("category", this.category, adCategory);
        this.category = adCategory;
        this._persistence_category_vh.setValue((Object)adCategory);
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    public CurrencyAmountRange _persistence_get_priceRange() {
        this._persistence_checkFetched("priceRange");
        return this.priceRange;
    }

    public void _persistence_set_priceRange(CurrencyAmountRange currencyAmountRange) {
        this._persistence_checkFetchedForSet("priceRange");
        this._persistence_propertyChange("priceRange", this.priceRange, currencyAmountRange);
        this.priceRange = currencyAmountRange;
    }
}

