/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.ScheduledPaymentAmountReservation;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.model.banking.transactions.HasShowToReceiver;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.ScheduledPaymentStatus;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.utils.Location;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@DiscriminatorValue(value="SCHEDULED_PAYMENT")
public class ScheduledPayment
extends BasePayment
implements HasTransactionStatus<ScheduledPaymentStatus>,
HasShowToReceiver,
TransactionWithInstallments<ScheduledPaymentInstallment>,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @OneToMany(mappedBy="transaction")
    private Set<ScheduledPaymentAmountReservation> amountReservations;
    static final long serialVersionUID = 7229750836490620046L;

    public ScheduledPaymentAmountReservation getAmountReservation() {
        return (ScheduledPaymentAmountReservation)CollectionHelper.first((Iterable)this._persistence_get_amountReservations());
    }

    public ScheduledPaymentInstallment getFirstInstallment() {
        return (ScheduledPaymentInstallment)CollectionHelper.first(this.getInstallments());
    }

    @Override
    public ScheduledPaymentInstallment getFirstScheduledInstallment() {
        for (ScheduledPaymentInstallment scheduledPaymentInstallment : CollectionHelper.orEmpty(this.getInstallments())) {
            InstallmentStatus installmentStatus = scheduledPaymentInstallment.getStatus();
            if (installmentStatus != null && installmentStatus.isTerminal()) continue;
            return scheduledPaymentInstallment;
        }
        return null;
    }

    public int getInstallmentCount() {
        return CollectionHelper.size((Collection)this._persistence_get_installments());
    }

    @Override
    public List<ScheduledPaymentInstallment> getInstallments() {
        return this._persistence_get_installments();
    }

    @Override
    public Location getLocation() {
        return Location.SCHEDULED_PAYMENT;
    }

    @Override
    public TransactionNature getNature() {
        return TransactionNature.SCHEDULED_PAYMENT;
    }

    public ScheduledPaymentStatus getStatus() {
        return this._persistence_get_status() == null ? null : ScheduledPaymentStatus.valueOf((String)this._persistence_get_status());
    }

    public boolean isShowToReceiver() {
        return Boolean.TRUE.equals(this._persistence_get_showToReceiver());
    }

    public boolean isVisibleToReceiver() {
        return Boolean.TRUE.equals(this._persistence_get_showToReceiver());
    }

    public void setAmountReservation(ScheduledPaymentAmountReservation scheduledPaymentAmountReservation) {
        this._persistence_set_amountReservations(CollectionHelper.asSet((Object[])new ScheduledPaymentAmountReservation[]{scheduledPaymentAmountReservation}));
    }

    public void setInstallments(List<ScheduledPaymentInstallment> list) {
        this._persistence_set_installments(list);
    }

    public void setShowToReceiver(boolean bl) {
        this._persistence_set_showToReceiver(bl);
    }

    public void setStatus(ScheduledPaymentStatus scheduledPaymentStatus) {
        this._persistence_set_status(scheduledPaymentStatus.name());
    }

    public void setVisibleToReceiver(boolean bl) {
        this._persistence_set_showToReceiver(bl);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ScheduledPayment();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "amountReservations") {
            return this.amountReservations;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "amountReservations") {
            this.amountReservations = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_amountReservations() {
        this._persistence_checkFetched("amountReservations");
        return this.amountReservations;
    }

    public void _persistence_set_amountReservations(Set set) {
        this._persistence_checkFetchedForSet("amountReservations");
        this._persistence_propertyChange("amountReservations", this.amountReservations, set);
        this.amountReservations = set;
    }
}

