/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.InstallmentTransfer;
import org.cyclos.entities.banking.InternalTransaction;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransactionWithInstallments;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.utils.CollectionHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@DiscriminatorColumn(name="subclass")
@Table(name="installments", indexes={@Index(name="ix_installments_number", unique=true, columnList="transaction_id, number"), @Index(name="ix_installments_due_date", columnList="due_date")})
public abstract class Installment
extends NetworkedEntity
implements Trans,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="by_id")
    private BasicUser by;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="transaction_id", nullable=false)
    protected InternalTransaction transaction;
    @Basic
    @Column(name="number", nullable=false)
    private Integer number;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private InstallmentStatus status;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="due_date", nullable=false)
    protected Date dueDate;
    @Basic
    @Column(name="amount", nullable=false)
    @CurrencyScale
    private BigDecimal amount;
    @OneToMany(mappedBy="installment")
    private Set<InstallmentTransfer> transfers;
    static final long serialVersionUID = -7377805314156006809L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_by_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_transaction_vh;

    @Override
    public AccessClient getAccessClient() {
        return this._persistence_get_transaction().getAccessClient();
    }

    @Override
    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    public BasicUser getBy() {
        return this._persistence_get_by();
    }

    @Override
    public Channel getChannel() {
        return this._persistence_get_transaction().getChannel();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_transaction().getCurrency();
    }

    @Override
    public CurrencyAmount getCurrencyAmount() {
        return Trans.super.getCurrencyAmount();
    }

    @Override
    public Set<TransactionCustomFieldValue> getCustomValues() {
        return this._persistence_get_transaction().getCustomValues();
    }

    @Override
    public Date getDate() {
        return this._persistence_get_transaction().getDate();
    }

    public Date getDueDate() {
        return this._persistence_get_dueDate();
    }

    @Override
    public Account getFrom() {
        return this._persistence_get_transaction().getFrom();
    }

    @Override
    public String getFromName() {
        return this._persistence_get_transaction() == null ? null : this._persistence_get_transaction().getFromName();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_transaction().getNetwork();
    }

    public int getNumber() {
        return this._persistence_get_number() == null ? 0 : this._persistence_get_number();
    }

    public InstallmentStatus getStatus() {
        return this._persistence_get_status();
    }

    @Override
    public Account getTo() {
        return this._persistence_get_transaction().getTo();
    }

    @Override
    public String getToName() {
        return this._persistence_get_transaction() == null ? null : this._persistence_get_transaction().getToName();
    }

    public Integer getTotalInstallments() {
        if (this._persistence_get_transaction() instanceof TransactionWithInstallments) {
            return ((TransactionWithInstallments)((Object)this._persistence_get_transaction())).getInstallmentsCount();
        }
        return null;
    }

    public InternalTransaction getTransaction() {
        return this._persistence_get_transaction();
    }

    public String getTransactionNumber() {
        return this._persistence_get_transaction().getTransactionNumber();
    }

    public InstallmentTransfer getTransfer() {
        return (InstallmentTransfer)CollectionHelper.first((Iterable)this._persistence_get_transfers());
    }

    public Date getTransferDate() {
        InstallmentTransfer installmentTransfer = this.getTransfer();
        return installmentTransfer == null ? null : installmentTransfer.getDate();
    }

    public Long getTransferId() {
        InstallmentTransfer installmentTransfer = this.getTransfer();
        return installmentTransfer == null ? null : installmentTransfer.getId();
    }

    public String getTransferTransactionNumber() {
        InstallmentTransfer installmentTransfer = this.getTransfer();
        return installmentTransfer == null ? null : installmentTransfer.getTransactionNumber();
    }

    @Override
    public TransferType getType() {
        return this._persistence_get_transaction().getType();
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setBy(BasicUser basicUser) {
        this._persistence_set_by(basicUser);
    }

    public void setDueDate(Date date) {
        this._persistence_set_dueDate(date);
    }

    public void setNumber(int n) {
        this._persistence_set_number(n);
    }

    public void setStatus(InstallmentStatus installmentStatus) {
        this._persistence_set_status(installmentStatus);
    }

    public void setTransaction(InternalTransaction internalTransaction) {
        this._persistence_set_transaction(internalTransaction);
    }

    public void setTransfer(InstallmentTransfer installmentTransfer) {
        this._persistence_set_transfers(CollectionHelper.asSet((Object[])new InstallmentTransfer[]{installmentTransfer}));
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_by_vh != null) {
            this._persistence_by_vh = (WeavedAttributeValueHolderInterface)this._persistence_by_vh.clone();
        }
        if (this._persistence_transaction_vh != null) {
            this._persistence_transaction_vh = (WeavedAttributeValueHolderInterface)this._persistence_transaction_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Installment();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "number") {
            return this.number;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "transfers") {
            return this.transfers;
        }
        if (string == "dueDate") {
            return this.dueDate;
        }
        if (string == "by") {
            return this.by;
        }
        if (string == "transaction") {
            return this.transaction;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "number") {
            this.number = (Integer)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "transfers") {
            this.transfers = (Set)object;
            return;
        }
        if (string == "dueDate") {
            this.dueDate = (Date)object;
            return;
        }
        if (string == "by") {
            this.by = (BasicUser)object;
            return;
        }
        if (string == "transaction") {
            this.transaction = (InternalTransaction)object;
            return;
        }
        if (string == "status") {
            this.status = (InstallmentStatus)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Integer _persistence_get_number() {
        this._persistence_checkFetched("number");
        return this.number;
    }

    public void _persistence_set_number(Integer n) {
        this._persistence_checkFetchedForSet("number");
        this._persistence_propertyChange("number", this.number, n);
        this.number = n;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public Set _persistence_get_transfers() {
        this._persistence_checkFetched("transfers");
        return this.transfers;
    }

    public void _persistence_set_transfers(Set set) {
        this._persistence_checkFetchedForSet("transfers");
        this._persistence_propertyChange("transfers", this.transfers, set);
        this.transfers = set;
    }

    public Date _persistence_get_dueDate() {
        this._persistence_checkFetched("dueDate");
        return this.dueDate;
    }

    public void _persistence_set_dueDate(Date date) {
        this._persistence_checkFetchedForSet("dueDate");
        this._persistence_propertyChange("dueDate", this.dueDate, date);
        this.dueDate = date;
    }

    protected void _persistence_initialize_by_vh() {
        if (this._persistence_by_vh == null) {
            this._persistence_by_vh = new ValueHolder((Object)this.by);
            this._persistence_by_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_by_vh() {
        BasicUser basicUser;
        this._persistence_initialize_by_vh();
        if ((this._persistence_by_vh.isCoordinatedWithProperty() || this._persistence_by_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_by()) != this._persistence_by_vh.getValue()) {
            this._persistence_set_by(basicUser);
        }
        return this._persistence_by_vh;
    }

    public void _persistence_set_by_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_by_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_by();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_by((BasicUser)object);
            }
        } else {
            this.by = null;
        }
    }

    public BasicUser _persistence_get_by() {
        this._persistence_checkFetched("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        return this.by;
    }

    public void _persistence_set_by(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("by");
        this._persistence_initialize_by_vh();
        this.by = (BasicUser)this._persistence_by_vh.getValue();
        this._persistence_propertyChange("by", this.by, basicUser);
        this.by = basicUser;
        this._persistence_by_vh.setValue((Object)basicUser);
    }

    protected void _persistence_initialize_transaction_vh() {
        if (this._persistence_transaction_vh == null) {
            this._persistence_transaction_vh = new ValueHolder((Object)this.transaction);
            this._persistence_transaction_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_transaction_vh() {
        InternalTransaction internalTransaction;
        this._persistence_initialize_transaction_vh();
        if ((this._persistence_transaction_vh.isCoordinatedWithProperty() || this._persistence_transaction_vh.isNewlyWeavedValueHolder()) && (internalTransaction = this._persistence_get_transaction()) != this._persistence_transaction_vh.getValue()) {
            this._persistence_set_transaction(internalTransaction);
        }
        return this._persistence_transaction_vh;
    }

    public void _persistence_set_transaction_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_transaction_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            InternalTransaction internalTransaction = this._persistence_get_transaction();
            if (internalTransaction != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_transaction((InternalTransaction)object);
            }
        } else {
            this.transaction = null;
        }
    }

    public InternalTransaction _persistence_get_transaction() {
        this._persistence_checkFetched("transaction");
        this._persistence_initialize_transaction_vh();
        this.transaction = (InternalTransaction)this._persistence_transaction_vh.getValue();
        return this.transaction;
    }

    public void _persistence_set_transaction(InternalTransaction internalTransaction) {
        this._persistence_checkFetchedForSet("transaction");
        this._persistence_initialize_transaction_vh();
        this.transaction = (InternalTransaction)this._persistence_transaction_vh.getValue();
        this._persistence_propertyChange("transaction", this.transaction, internalTransaction);
        this.transaction = internalTransaction;
        this._persistence_transaction_vh.setValue((Object)internalTransaction);
    }

    public InstallmentStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(InstallmentStatus installmentStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, installmentStatus);
        this.status = installmentStatus;
    }
}

