/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.banking;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.CurrencyScale;
import org.cyclos.entities.MaxScale;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountFeeLogEvent;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrencyAmount;
import org.cyclos.entities.banking.UserAccountFeeLog;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.model.banking.accountfees.AccountFeeLogStatus;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="account_fee_logs", indexes={@Index(name="uk_aflog_fee_date", unique=true, columnList="account_fee_id, date")})
public class AccountFeeLog
extends NetworkedEntity
implements HasCurrencyAmount,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_fee_id", nullable=false)
    private AccountFee accountFee;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="date", nullable=false)
    private Date date;
    @Embedded
    private DatePeriod period;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    private AccountFeeLogStatus status;
    @Basic
    @Column(name="archived")
    private Boolean archived;
    @Basic
    @Column(name="amount")
    @MaxScale
    private BigDecimal amount;
    @Basic
    @Column(name="free_base")
    @CurrencyScale
    private BigDecimal freeBase;
    @Basic
    @Column(name="total_charged_amount")
    @CurrencyScale
    private BigDecimal totalChargedAmount;
    @Basic
    @Column(name="recharge_attempt", nullable=false)
    private int rechargeAttempt;
    @OneToMany(mappedBy="accountFeeLog")
    @OrderBy(value="date desc")
    private List<AccountFeeLogEvent> events;
    @OneToMany(mappedBy="accountFeeLog")
    private Set<UserAccountFeeLog> accounts;
    static final long serialVersionUID = -2478077894123044627L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accountFee_vh;

    public AccountFee getAccountFee() {
        return this._persistence_get_accountFee();
    }

    public BigDecimal getAmount() {
        return this._persistence_get_amount();
    }

    @Override
    public Currency getCurrency() {
        return this._persistence_get_accountFee().getCurrency();
    }

    public Date getDate() {
        return this._persistence_get_date();
    }

    public List<AccountFeeLogEvent> getEvents() {
        return this._persistence_get_events();
    }

    public BigDecimal getFreeBase() {
        return this._persistence_get_freeBase();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_accountFee().getNetwork();
    }

    public DatePeriod getPeriod() {
        return this._persistence_get_period();
    }

    public int getRechargeAttempt() {
        return this._persistence_get_rechargeAttempt();
    }

    public AccountFeeLogStatus getStatus() {
        return this._persistence_get_status();
    }

    public BigDecimal getTotalChargedAmount() {
        return this._persistence_get_totalChargedAmount();
    }

    public boolean isArchived() {
        return Boolean.TRUE.equals(this._persistence_get_archived());
    }

    public void setAccountFee(AccountFee accountFee) {
        this._persistence_set_accountFee(accountFee);
    }

    public void setAmount(BigDecimal bigDecimal) {
        this._persistence_set_amount(bigDecimal);
    }

    public void setArchived(boolean bl) {
        this._persistence_set_archived(bl);
    }

    public void setDate(Date date) {
        this._persistence_set_date(date);
    }

    public void setEvents(List<AccountFeeLogEvent> list) {
        this._persistence_set_events(list);
    }

    public void setFreeBase(BigDecimal bigDecimal) {
        this._persistence_set_freeBase(bigDecimal);
    }

    public void setPeriod(DatePeriod datePeriod) {
        this._persistence_set_period(datePeriod);
    }

    public void setRechargeAttempt(int n) {
        this._persistence_set_rechargeAttempt(n);
    }

    public void setStatus(AccountFeeLogStatus accountFeeLogStatus) {
        this._persistence_set_status(accountFeeLogStatus);
    }

    public void setTotalChargedAmount(BigDecimal bigDecimal) {
        this._persistence_set_totalChargedAmount(bigDecimal);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_accountFee_vh != null) {
            this._persistence_accountFee_vh = (WeavedAttributeValueHolderInterface)this._persistence_accountFee_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AccountFeeLog();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "date") {
            return this.date;
        }
        if (string == "archived") {
            return this.archived;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "period") {
            return this.period;
        }
        if (string == "accountFee") {
            return this.accountFee;
        }
        if (string == "rechargeAttempt") {
            return this.rechargeAttempt;
        }
        if (string == "totalChargedAmount") {
            return this.totalChargedAmount;
        }
        if (string == "freeBase") {
            return this.freeBase;
        }
        if (string == "accounts") {
            return this.accounts;
        }
        if (string == "events") {
            return this.events;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "date") {
            this.date = (Date)object;
            return;
        }
        if (string == "archived") {
            this.archived = (Boolean)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "period") {
            this.period = (DatePeriod)object;
            return;
        }
        if (string == "accountFee") {
            this.accountFee = (AccountFee)object;
            return;
        }
        if (string == "rechargeAttempt") {
            this.rechargeAttempt = (Integer)object;
            return;
        }
        if (string == "totalChargedAmount") {
            this.totalChargedAmount = (BigDecimal)object;
            return;
        }
        if (string == "freeBase") {
            this.freeBase = (BigDecimal)object;
            return;
        }
        if (string == "accounts") {
            this.accounts = (Set)object;
            return;
        }
        if (string == "events") {
            this.events = (List)object;
            return;
        }
        if (string == "status") {
            this.status = (AccountFeeLogStatus)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Date _persistence_get_date() {
        this._persistence_checkFetched("date");
        return this.date;
    }

    public void _persistence_set_date(Date date) {
        this._persistence_checkFetchedForSet("date");
        this._persistence_propertyChange("date", this.date, date);
        this.date = date;
    }

    public Boolean _persistence_get_archived() {
        this._persistence_checkFetched("archived");
        return this.archived;
    }

    public void _persistence_set_archived(Boolean bl) {
        this._persistence_checkFetchedForSet("archived");
        this._persistence_propertyChange("archived", this.archived, bl);
        this.archived = bl;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", this.amount, bigDecimal);
        this.amount = bigDecimal;
    }

    public DatePeriod _persistence_get_period() {
        this._persistence_checkFetched("period");
        return this.period;
    }

    public void _persistence_set_period(DatePeriod datePeriod) {
        this._persistence_checkFetchedForSet("period");
        this._persistence_propertyChange("period", this.period, datePeriod);
        this.period = datePeriod;
    }

    protected void _persistence_initialize_accountFee_vh() {
        if (this._persistence_accountFee_vh == null) {
            this._persistence_accountFee_vh = new ValueHolder((Object)this.accountFee);
            this._persistence_accountFee_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accountFee_vh() {
        AccountFee accountFee;
        this._persistence_initialize_accountFee_vh();
        if ((this._persistence_accountFee_vh.isCoordinatedWithProperty() || this._persistence_accountFee_vh.isNewlyWeavedValueHolder()) && (accountFee = this._persistence_get_accountFee()) != this._persistence_accountFee_vh.getValue()) {
            this._persistence_set_accountFee(accountFee);
        }
        return this._persistence_accountFee_vh;
    }

    public void _persistence_set_accountFee_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accountFee_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccountFee accountFee = this._persistence_get_accountFee();
            if (accountFee != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accountFee((AccountFee)object);
            }
        } else {
            this.accountFee = null;
        }
    }

    public AccountFee _persistence_get_accountFee() {
        this._persistence_checkFetched("accountFee");
        this._persistence_initialize_accountFee_vh();
        this.accountFee = (AccountFee)this._persistence_accountFee_vh.getValue();
        return this.accountFee;
    }

    public void _persistence_set_accountFee(AccountFee accountFee) {
        this._persistence_checkFetchedForSet("accountFee");
        this._persistence_initialize_accountFee_vh();
        this.accountFee = (AccountFee)this._persistence_accountFee_vh.getValue();
        this._persistence_propertyChange("accountFee", this.accountFee, accountFee);
        this.accountFee = accountFee;
        this._persistence_accountFee_vh.setValue((Object)accountFee);
    }

    public int _persistence_get_rechargeAttempt() {
        this._persistence_checkFetched("rechargeAttempt");
        return this.rechargeAttempt;
    }

    public void _persistence_set_rechargeAttempt(int n) {
        this._persistence_checkFetchedForSet("rechargeAttempt");
        this._persistence_propertyChange("rechargeAttempt", new Integer(this.rechargeAttempt), new Integer(n));
        this.rechargeAttempt = n;
    }

    public BigDecimal _persistence_get_totalChargedAmount() {
        this._persistence_checkFetched("totalChargedAmount");
        return this.totalChargedAmount;
    }

    public void _persistence_set_totalChargedAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("totalChargedAmount");
        this._persistence_propertyChange("totalChargedAmount", this.totalChargedAmount, bigDecimal);
        this.totalChargedAmount = bigDecimal;
    }

    public BigDecimal _persistence_get_freeBase() {
        this._persistence_checkFetched("freeBase");
        return this.freeBase;
    }

    public void _persistence_set_freeBase(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("freeBase");
        this._persistence_propertyChange("freeBase", this.freeBase, bigDecimal);
        this.freeBase = bigDecimal;
    }

    public Set _persistence_get_accounts() {
        this._persistence_checkFetched("accounts");
        return this.accounts;
    }

    public void _persistence_set_accounts(Set set) {
        this._persistence_checkFetchedForSet("accounts");
        this._persistence_propertyChange("accounts", this.accounts, set);
        this.accounts = set;
    }

    public List _persistence_get_events() {
        this._persistence_checkFetched("events");
        return this.events;
    }

    public void _persistence_set_events(List list) {
        this._persistence_checkFetchedForSet("events");
        this._persistence_propertyChange("events", this.events, list);
        this.events = list;
    }

    public AccountFeeLogStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(AccountFeeLogStatus accountFeeLogStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, accountFeeLogStatus);
        this.status = accountFeeLogStatus;
    }
}

