/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.OwnerEntity;
import org.cyclos.entities.ReadOnlyFromDTO;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.access.UserIdentityProvider;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ExternalRedirectExecution;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.model.access.tokens.TokenStatus;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MaskHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="tokens", uniqueConstraints={@UniqueConstraint(columnNames={"type_id", "value"})})
@DiscriminatorColumn(name="subclass")
@DiscriminatorValue(value="OTHER")
public class Token
extends BaseEntity
implements UserPrincipal,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="subclass", insertable=false, updatable=false)
    private String subclass;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="type_id", nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private TokenPrincipalType type;
    @OwnerEntity
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id")
    private BasicUser user;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=false)
    @ReadOnlyFromDTO
    private TokenStatus status = TokenStatus.UNASSIGNED;
    @OneToMany(mappedBy="token", cascade={CascadeType.REMOVE})
    private Set<Session> sessions;
    @OneToMany(mappedBy="token", cascade={CascadeType.REMOVE})
    private Set<OidcAuthorization> oidcAuthorization;
    @OneToMany(mappedBy="token", cascade={CascadeType.REMOVE})
    private Set<UserIdentityProvider> userIdentityProviders;
    @OneToMany(mappedBy="token", cascade={CascadeType.REMOVE})
    private Set<Pin> pins;
    @OneToMany(mappedBy="token", cascade={CascadeType.REMOVE})
    private Set<ExternalRedirectExecution> externalRedirectExecutions;
    @Basic
    @Column(name="value", nullable=false)
    @ReadOnlyFromDTO(onInsert=false)
    private String value;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date", nullable=false)
    @ReadOnlyFromDTO
    private Date creationDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="activation_date")
    @ReadOnlyFromDTO
    private Date activationDate;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="activation_deadline")
    private Date activationDeadline;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiry_date")
    private Date expiryDate;
    @Transient
    private boolean activateNow;
    static final long serialVersionUID = -6404639590285081603L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_type_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;

    @Override
    public AccessClient getAccessClient() {
        return null;
    }

    @Override
    public UserAccountType getAccountType() {
        return null;
    }

    public Date getActivationDate() {
        return this._persistence_get_activationDate();
    }

    public Date getActivationDeadline() {
        return this._persistence_get_status() == TokenStatus.PENDING_ACTIVATION ? this._persistence_get_activationDeadline() : null;
    }

    @Override
    public BasicUser getBasicUser() {
        return this.getUser();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    @Override
    public UserCustomFieldValue getCustomFieldValue() {
        return null;
    }

    public Date getExpiryDate() {
        return this._persistence_get_expiryDate();
    }

    public String getMaskedValue() {
        String string = this._persistence_get_type().getTokenMask();
        return MaskHelper.applyMask((String)string, (String)this._persistence_get_value());
    }

    @Override
    public MobilePhone getMobilePhone() {
        return null;
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_type().getNetwork();
    }

    @Override
    public String getPrincipal() {
        if (this._persistence_get_type().isAllowManualInputOfValue()) {
            return this.getMaskedValue();
        }
        return null;
    }

    @Override
    public PrincipalType getPrincipalType() {
        return this._persistence_get_type();
    }

    public TokenStatus getStatus() {
        if (this.getExpiryDate() != null && this._persistence_get_status() == TokenStatus.ACTIVE && this.getExpiryDate().before(DateHelper.now())) {
            return TokenStatus.EXPIRED;
        }
        if (this.getActivationDeadline() != null && this._persistence_get_status() == TokenStatus.PENDING_ACTIVATION && this.getActivationDeadline().before(DateHelper.now())) {
            return TokenStatus.ACTIVATION_EXPIRED;
        }
        return this._persistence_get_status();
    }

    @Override
    public Token getToken() {
        return this;
    }

    @Override
    public TrustedDevice getTrustedDevice() {
        return null;
    }

    public TokenPrincipalType getType() {
        return this._persistence_get_type();
    }

    public BasicUser getUser() {
        return this._persistence_get_user();
    }

    public String getValue() {
        return this._persistence_get_value();
    }

    public boolean isActivateNow() {
        return this.activateNow;
    }

    public boolean isInUse() {
        TokenStatus tokenStatus = this.getStatus();
        return EnumSet.of(TokenStatus.BLOCKED, TokenStatus.ACTIVE, TokenStatus.PENDING_ACTIVATION).contains(tokenStatus);
    }

    public void setActivateNow(boolean bl) {
        this.activateNow = bl;
    }

    public void setActivationDate(Date date) {
        this._persistence_set_activationDate(date);
    }

    public void setActivationDeadline(Date date) {
        this._persistence_set_activationDeadline(date);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    public void setExpiryDate(Date date) {
        this._persistence_set_expiryDate(date);
    }

    public void setStatus(TokenStatus tokenStatus) {
        this._persistence_set_status(tokenStatus);
    }

    public void setType(TokenPrincipalType tokenPrincipalType) {
        this._persistence_set_type(tokenPrincipalType);
    }

    public void setUser(BasicUser basicUser) {
        this._persistence_set_user(basicUser);
    }

    public void setValue(String string) {
        this._persistence_set_value(string);
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_type_vh != null) {
            this._persistence_type_vh = (WeavedAttributeValueHolderInterface)this._persistence_type_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Token();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "sessions") {
            return this.sessions;
        }
        if (string == "pins") {
            return this.pins;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "type") {
            return this.type;
        }
        if (string == "userIdentityProviders") {
            return this.userIdentityProviders;
        }
        if (string == "expiryDate") {
            return this.expiryDate;
        }
        if (string == "activationDeadline") {
            return this.activationDeadline;
        }
        if (string == "subclass") {
            return this.subclass;
        }
        if (string == "activationDate") {
            return this.activationDate;
        }
        if (string == "value") {
            return this.value;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "oidcAuthorization") {
            return this.oidcAuthorization;
        }
        if (string == "status") {
            return this.status;
        }
        if (string == "externalRedirectExecutions") {
            return this.externalRedirectExecutions;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "sessions") {
            this.sessions = (Set)object;
            return;
        }
        if (string == "pins") {
            this.pins = (Set)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "type") {
            this.type = (TokenPrincipalType)object;
            return;
        }
        if (string == "userIdentityProviders") {
            this.userIdentityProviders = (Set)object;
            return;
        }
        if (string == "expiryDate") {
            this.expiryDate = (Date)object;
            return;
        }
        if (string == "activationDeadline") {
            this.activationDeadline = (Date)object;
            return;
        }
        if (string == "subclass") {
            this.subclass = (String)object;
            return;
        }
        if (string == "activationDate") {
            this.activationDate = (Date)object;
            return;
        }
        if (string == "value") {
            this.value = (String)object;
            return;
        }
        if (string == "user") {
            this.user = (BasicUser)object;
            return;
        }
        if (string == "oidcAuthorization") {
            this.oidcAuthorization = (Set)object;
            return;
        }
        if (string == "status") {
            this.status = (TokenStatus)object;
            return;
        }
        if (string == "externalRedirectExecutions") {
            this.externalRedirectExecutions = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_sessions() {
        this._persistence_checkFetched("sessions");
        return this.sessions;
    }

    public void _persistence_set_sessions(Set set) {
        this._persistence_checkFetchedForSet("sessions");
        this._persistence_propertyChange("sessions", this.sessions, set);
        this.sessions = set;
    }

    public Set _persistence_get_pins() {
        this._persistence_checkFetched("pins");
        return this.pins;
    }

    public void _persistence_set_pins(Set set) {
        this._persistence_checkFetchedForSet("pins");
        this._persistence_propertyChange("pins", this.pins, set);
        this.pins = set;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    protected void _persistence_initialize_type_vh() {
        if (this._persistence_type_vh == null) {
            this._persistence_type_vh = new ValueHolder((Object)this.type);
            this._persistence_type_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_type_vh() {
        TokenPrincipalType tokenPrincipalType;
        this._persistence_initialize_type_vh();
        if ((this._persistence_type_vh.isCoordinatedWithProperty() || this._persistence_type_vh.isNewlyWeavedValueHolder()) && (tokenPrincipalType = this._persistence_get_type()) != this._persistence_type_vh.getValue()) {
            this._persistence_set_type(tokenPrincipalType);
        }
        return this._persistence_type_vh;
    }

    public void _persistence_set_type_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_type_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TokenPrincipalType tokenPrincipalType = this._persistence_get_type();
            if (tokenPrincipalType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_type((TokenPrincipalType)object);
            }
        } else {
            this.type = null;
        }
    }

    public TokenPrincipalType _persistence_get_type() {
        this._persistence_checkFetched("type");
        this._persistence_initialize_type_vh();
        this.type = (TokenPrincipalType)this._persistence_type_vh.getValue();
        return this.type;
    }

    public void _persistence_set_type(TokenPrincipalType tokenPrincipalType) {
        this._persistence_checkFetchedForSet("type");
        this._persistence_initialize_type_vh();
        this.type = (TokenPrincipalType)this._persistence_type_vh.getValue();
        this._persistence_propertyChange("type", this.type, tokenPrincipalType);
        this.type = tokenPrincipalType;
        this._persistence_type_vh.setValue((Object)tokenPrincipalType);
    }

    public Set _persistence_get_userIdentityProviders() {
        this._persistence_checkFetched("userIdentityProviders");
        return this.userIdentityProviders;
    }

    public void _persistence_set_userIdentityProviders(Set set) {
        this._persistence_checkFetchedForSet("userIdentityProviders");
        this._persistence_propertyChange("userIdentityProviders", this.userIdentityProviders, set);
        this.userIdentityProviders = set;
    }

    public Date _persistence_get_expiryDate() {
        this._persistence_checkFetched("expiryDate");
        return this.expiryDate;
    }

    public void _persistence_set_expiryDate(Date date) {
        this._persistence_checkFetchedForSet("expiryDate");
        this._persistence_propertyChange("expiryDate", this.expiryDate, date);
        this.expiryDate = date;
    }

    public Date _persistence_get_activationDeadline() {
        this._persistence_checkFetched("activationDeadline");
        return this.activationDeadline;
    }

    public void _persistence_set_activationDeadline(Date date) {
        this._persistence_checkFetchedForSet("activationDeadline");
        this._persistence_propertyChange("activationDeadline", this.activationDeadline, date);
        this.activationDeadline = date;
    }

    public String _persistence_get_subclass() {
        this._persistence_checkFetched("subclass");
        return this.subclass;
    }

    public void _persistence_set_subclass(String string) {
        this._persistence_checkFetchedForSet("subclass");
        this._persistence_propertyChange("subclass", this.subclass, string);
        this.subclass = string;
    }

    public Date _persistence_get_activationDate() {
        this._persistence_checkFetched("activationDate");
        return this.activationDate;
    }

    public void _persistence_set_activationDate(Date date) {
        this._persistence_checkFetchedForSet("activationDate");
        this._persistence_propertyChange("activationDate", this.activationDate, date);
        this.activationDate = date;
    }

    public String _persistence_get_value() {
        this._persistence_checkFetched("value");
        return this.value;
    }

    public void _persistence_set_value(String string) {
        this._persistence_checkFetchedForSet("value");
        this._persistence_propertyChange("value", this.value, string);
        this.value = string;
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        BasicUser basicUser;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(basicUser);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_user();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((BasicUser)object);
            }
        } else {
            this.user = null;
        }
    }

    public BasicUser _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (BasicUser)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (BasicUser)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, basicUser);
        this.user = basicUser;
        this._persistence_user_vh.setValue((Object)basicUser);
    }

    public Set _persistence_get_oidcAuthorization() {
        this._persistence_checkFetched("oidcAuthorization");
        return this.oidcAuthorization;
    }

    public void _persistence_set_oidcAuthorization(Set set) {
        this._persistence_checkFetchedForSet("oidcAuthorization");
        this._persistence_propertyChange("oidcAuthorization", this.oidcAuthorization, set);
        this.oidcAuthorization = set;
    }

    public TokenStatus _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(TokenStatus tokenStatus) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", this.status, tokenStatus);
        this.status = tokenStatus;
    }

    public Set _persistence_get_externalRedirectExecutions() {
        this._persistence_checkFetched("externalRedirectExecutions");
        return this.externalRedirectExecutions;
    }

    public void _persistence_set_externalRedirectExecutions(Set set) {
        this._persistence_checkFetchedForSet("externalRedirectExecutions");
        this._persistence_propertyChange("externalRedirectExecutions", this.externalRedirectExecutions, set);
        this.externalRedirectExecutions = set;
    }
}

