/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.entities.access;

import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.SessionProperties;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.DelegatingMutableUserPrincipal;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.server.model.access.login.SessionSource;
import org.cyclos.utils.ObjectHelper;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="sessions")
public class Session
extends NetworkedEntity
implements DelegatingMutableUserPrincipal,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @Basic
    @Column(name="session_token", length=32, unique=true, nullable=false)
    private String sessionToken;
    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creation_date", nullable=false)
    private Date creationDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="channel_id", nullable=false)
    private Channel channel;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="principal_type_id", nullable=false)
    private PrincipalType principalType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="basic_user_id", nullable=false)
    private BasicUser basicUser;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private User user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="token_id")
    private Token token;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="access_client_id")
    private AccessClient accessClient;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="account_type_id")
    private UserAccountType accountType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="phone_id")
    private MobilePhone mobilePhone;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="custom_field_value_id")
    private UserCustomFieldValue customFieldValue;
    @Basic
    @Column(name="remote_address", nullable=false)
    private String remoteAddress;
    @Basic
    @Column(name="confirmation_validated")
    private Boolean confirmationValidated;
    @Basic
    @Column(name="pending_login_confirmation")
    private Boolean pendingLoginConfirmation;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="session_timeout_amount")), @AttributeOverride(name="field", column=@Column(name="session_timeout_field"))})
    private TimeInterval sessionTimeout;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="identity_provider_id")
    private IdentityProvider identityProvider;
    @Basic
    @Enumerated(value=EnumType.STRING)
    @Column(name="source", nullable=false)
    private SessionSource source;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pin_id")
    private Pin pin;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="trusted_device_id")
    private TrustedDevice trustedDevice;
    static final long serialVersionUID = -4713963206614743780L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_basicUser_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accountType_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_channel_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_customFieldValue_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_identityProvider_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_token_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_mobilePhone_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_pin_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_trustedDevice_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_user_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_accessClient_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_principalType_vh;

    @Override
    public AccessClient getAccessClient() {
        return this._persistence_get_accessClient();
    }

    @Override
    public UserAccountType getAccountType() {
        return this._persistence_get_accountType();
    }

    @Override
    public BasicUser getBasicUser() {
        return this.getUser();
    }

    public Channel getChannel() {
        return this._persistence_get_channel();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    @Override
    public UserCustomFieldValue getCustomFieldValue() {
        return this._persistence_get_customFieldValue();
    }

    public IdentityProvider getIdentityProvider() {
        return this._persistence_get_identityProvider();
    }

    @Override
    public MobilePhone getMobilePhone() {
        return this._persistence_get_mobilePhone();
    }

    @Override
    public Network getNetwork() {
        return this._persistence_get_user().getNetwork();
    }

    public Pin getPin() {
        return (Pin)ObjectHelper.defaultValue((Object)this._persistence_get_pin(), this._persistence_get_trustedDevice() == null ? null : this._persistence_get_trustedDevice().getPin());
    }

    @Override
    public String getPrincipal() {
        return DelegatingMutableUserPrincipal.super.getPrincipal();
    }

    @Override
    public PrincipalType getPrincipalType() {
        return this._persistence_get_principalType();
    }

    public SessionProperties getProperties() {
        return new SessionProperties(this);
    }

    public String getRemoteAddress() {
        return this._persistence_get_remoteAddress();
    }

    public Long getSessionId() {
        return this.getId();
    }

    public TimeInterval getSessionTimeout() {
        return this._persistence_get_sessionTimeout();
    }

    public String getSessionToken() {
        return this._persistence_get_sessionToken();
    }

    public SessionSource getSource() {
        return this._persistence_get_source();
    }

    @Override
    public Token getToken() {
        return this._persistence_get_token();
    }

    @Override
    public TrustedDevice getTrustedDevice() {
        return this._persistence_get_trustedDevice();
    }

    public BasicUser getUser() {
        return this._persistence_get_basicUser();
    }

    public boolean isConfirmationValidated() {
        return Boolean.TRUE.equals(this._persistence_get_confirmationValidated());
    }

    public boolean isPendingLoginConfirmation() {
        return Boolean.TRUE.equals(this._persistence_get_pendingLoginConfirmation());
    }

    @Override
    public void setAccessClient(AccessClient accessClient) {
        this._persistence_set_accessClient(accessClient);
    }

    @Override
    public void setAccountType(UserAccountType userAccountType) {
        this._persistence_set_accountType(userAccountType);
    }

    @Override
    public void setBasicUser(BasicUser basicUser) {
        this.setUser(basicUser);
    }

    public void setChannel(Channel channel) {
        this._persistence_set_channel(channel);
    }

    public void setConfirmationValidated(boolean bl) {
        this._persistence_set_confirmationValidated(bl);
    }

    public void setCreationDate(Date date) {
        this._persistence_set_creationDate(date);
    }

    @Override
    public void setCustomFieldValue(UserCustomFieldValue userCustomFieldValue) {
        this._persistence_set_customFieldValue(userCustomFieldValue);
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this._persistence_set_identityProvider(identityProvider);
    }

    @Override
    public void setMobilePhone(MobilePhone mobilePhone) {
        this._persistence_set_mobilePhone(mobilePhone);
    }

    public void setPendingLoginConfirmation(boolean bl) {
        this._persistence_set_pendingLoginConfirmation(bl);
    }

    public void setPin(Pin pin) {
        this._persistence_set_pin(pin);
    }

    @Override
    public void setPrincipalType(PrincipalType principalType) {
        this._persistence_set_principalType(principalType);
    }

    public void setProperties(SessionProperties sessionProperties) {
        if (sessionProperties != null) {
            this.setSource(sessionProperties.getSource());
            this.setTrustedDevice(sessionProperties.getTrustedDevice());
            this.setPin(sessionProperties.getPin());
            sessionProperties.bindTo(this);
        }
    }

    public void setRemoteAddress(String string) {
        this._persistence_set_remoteAddress(string);
    }

    public void setSessionTimeout(TimeInterval timeInterval) {
        this._persistence_set_sessionTimeout(timeInterval);
    }

    public void setSessionToken(String string) {
        this._persistence_set_sessionToken(string);
    }

    public void setSource(SessionSource sessionSource) {
        this._persistence_set_source(sessionSource);
    }

    @Override
    public void setToken(Token token) {
        this._persistence_set_token(token);
    }

    @Override
    public void setTrustedDevice(TrustedDevice trustedDevice) {
        this._persistence_set_trustedDevice(trustedDevice);
    }

    public void setUser(BasicUser basicUser) {
        this._persistence_set_basicUser(basicUser);
        this._persistence_set_user(basicUser == null ? null : basicUser.getUser());
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_basicUser_vh != null) {
            this._persistence_basicUser_vh = (WeavedAttributeValueHolderInterface)this._persistence_basicUser_vh.clone();
        }
        if (this._persistence_accountType_vh != null) {
            this._persistence_accountType_vh = (WeavedAttributeValueHolderInterface)this._persistence_accountType_vh.clone();
        }
        if (this._persistence_channel_vh != null) {
            this._persistence_channel_vh = (WeavedAttributeValueHolderInterface)this._persistence_channel_vh.clone();
        }
        if (this._persistence_customFieldValue_vh != null) {
            this._persistence_customFieldValue_vh = (WeavedAttributeValueHolderInterface)this._persistence_customFieldValue_vh.clone();
        }
        if (this._persistence_identityProvider_vh != null) {
            this._persistence_identityProvider_vh = (WeavedAttributeValueHolderInterface)this._persistence_identityProvider_vh.clone();
        }
        if (this._persistence_token_vh != null) {
            this._persistence_token_vh = (WeavedAttributeValueHolderInterface)this._persistence_token_vh.clone();
        }
        if (this._persistence_mobilePhone_vh != null) {
            this._persistence_mobilePhone_vh = (WeavedAttributeValueHolderInterface)this._persistence_mobilePhone_vh.clone();
        }
        if (this._persistence_pin_vh != null) {
            this._persistence_pin_vh = (WeavedAttributeValueHolderInterface)this._persistence_pin_vh.clone();
        }
        if (this._persistence_trustedDevice_vh != null) {
            this._persistence_trustedDevice_vh = (WeavedAttributeValueHolderInterface)this._persistence_trustedDevice_vh.clone();
        }
        if (this._persistence_user_vh != null) {
            this._persistence_user_vh = (WeavedAttributeValueHolderInterface)this._persistence_user_vh.clone();
        }
        if (this._persistence_accessClient_vh != null) {
            this._persistence_accessClient_vh = (WeavedAttributeValueHolderInterface)this._persistence_accessClient_vh.clone();
        }
        if (this._persistence_principalType_vh != null) {
            this._persistence_principalType_vh = (WeavedAttributeValueHolderInterface)this._persistence_principalType_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Session();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "basicUser") {
            return this.basicUser;
        }
        if (string == "pendingLoginConfirmation") {
            return this.pendingLoginConfirmation;
        }
        if (string == "confirmationValidated") {
            return this.confirmationValidated;
        }
        if (string == "accountType") {
            return this.accountType;
        }
        if (string == "channel") {
            return this.channel;
        }
        if (string == "source") {
            return this.source;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "customFieldValue") {
            return this.customFieldValue;
        }
        if (string == "identityProvider") {
            return this.identityProvider;
        }
        if (string == "token") {
            return this.token;
        }
        if (string == "mobilePhone") {
            return this.mobilePhone;
        }
        if (string == "pin") {
            return this.pin;
        }
        if (string == "sessionToken") {
            return this.sessionToken;
        }
        if (string == "sessionTimeout") {
            return this.sessionTimeout;
        }
        if (string == "trustedDevice") {
            return this.trustedDevice;
        }
        if (string == "user") {
            return this.user;
        }
        if (string == "accessClient") {
            return this.accessClient;
        }
        if (string == "remoteAddress") {
            return this.remoteAddress;
        }
        if (string == "principalType") {
            return this.principalType;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "basicUser") {
            this.basicUser = (BasicUser)object;
            return;
        }
        if (string == "pendingLoginConfirmation") {
            this.pendingLoginConfirmation = (Boolean)object;
            return;
        }
        if (string == "confirmationValidated") {
            this.confirmationValidated = (Boolean)object;
            return;
        }
        if (string == "accountType") {
            this.accountType = (UserAccountType)object;
            return;
        }
        if (string == "channel") {
            this.channel = (Channel)object;
            return;
        }
        if (string == "source") {
            this.source = (SessionSource)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "customFieldValue") {
            this.customFieldValue = (UserCustomFieldValue)object;
            return;
        }
        if (string == "identityProvider") {
            this.identityProvider = (IdentityProvider)object;
            return;
        }
        if (string == "token") {
            this.token = (Token)object;
            return;
        }
        if (string == "mobilePhone") {
            this.mobilePhone = (MobilePhone)object;
            return;
        }
        if (string == "pin") {
            this.pin = (Pin)object;
            return;
        }
        if (string == "sessionToken") {
            this.sessionToken = (String)object;
            return;
        }
        if (string == "sessionTimeout") {
            this.sessionTimeout = (TimeInterval)object;
            return;
        }
        if (string == "trustedDevice") {
            this.trustedDevice = (TrustedDevice)object;
            return;
        }
        if (string == "user") {
            this.user = (User)object;
            return;
        }
        if (string == "accessClient") {
            this.accessClient = (AccessClient)object;
            return;
        }
        if (string == "remoteAddress") {
            this.remoteAddress = (String)object;
            return;
        }
        if (string == "principalType") {
            this.principalType = (PrincipalType)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_basicUser_vh() {
        if (this._persistence_basicUser_vh == null) {
            this._persistence_basicUser_vh = new ValueHolder((Object)this.basicUser);
            this._persistence_basicUser_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_basicUser_vh() {
        BasicUser basicUser;
        this._persistence_initialize_basicUser_vh();
        if ((this._persistence_basicUser_vh.isCoordinatedWithProperty() || this._persistence_basicUser_vh.isNewlyWeavedValueHolder()) && (basicUser = this._persistence_get_basicUser()) != this._persistence_basicUser_vh.getValue()) {
            this._persistence_set_basicUser(basicUser);
        }
        return this._persistence_basicUser_vh;
    }

    public void _persistence_set_basicUser_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_basicUser_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            BasicUser basicUser = this._persistence_get_basicUser();
            if (basicUser != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_basicUser((BasicUser)object);
            }
        } else {
            this.basicUser = null;
        }
    }

    public BasicUser _persistence_get_basicUser() {
        this._persistence_checkFetched("basicUser");
        this._persistence_initialize_basicUser_vh();
        this.basicUser = (BasicUser)this._persistence_basicUser_vh.getValue();
        return this.basicUser;
    }

    public void _persistence_set_basicUser(BasicUser basicUser) {
        this._persistence_checkFetchedForSet("basicUser");
        this._persistence_initialize_basicUser_vh();
        this.basicUser = (BasicUser)this._persistence_basicUser_vh.getValue();
        this._persistence_propertyChange("basicUser", this.basicUser, basicUser);
        this.basicUser = basicUser;
        this._persistence_basicUser_vh.setValue((Object)basicUser);
    }

    public Boolean _persistence_get_pendingLoginConfirmation() {
        this._persistence_checkFetched("pendingLoginConfirmation");
        return this.pendingLoginConfirmation;
    }

    public void _persistence_set_pendingLoginConfirmation(Boolean bl) {
        this._persistence_checkFetchedForSet("pendingLoginConfirmation");
        this._persistence_propertyChange("pendingLoginConfirmation", this.pendingLoginConfirmation, bl);
        this.pendingLoginConfirmation = bl;
    }

    public Boolean _persistence_get_confirmationValidated() {
        this._persistence_checkFetched("confirmationValidated");
        return this.confirmationValidated;
    }

    public void _persistence_set_confirmationValidated(Boolean bl) {
        this._persistence_checkFetchedForSet("confirmationValidated");
        this._persistence_propertyChange("confirmationValidated", this.confirmationValidated, bl);
        this.confirmationValidated = bl;
    }

    protected void _persistence_initialize_accountType_vh() {
        if (this._persistence_accountType_vh == null) {
            this._persistence_accountType_vh = new ValueHolder((Object)this.accountType);
            this._persistence_accountType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accountType_vh() {
        UserAccountType userAccountType;
        this._persistence_initialize_accountType_vh();
        if ((this._persistence_accountType_vh.isCoordinatedWithProperty() || this._persistence_accountType_vh.isNewlyWeavedValueHolder()) && (userAccountType = this._persistence_get_accountType()) != this._persistence_accountType_vh.getValue()) {
            this._persistence_set_accountType(userAccountType);
        }
        return this._persistence_accountType_vh;
    }

    public void _persistence_set_accountType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accountType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserAccountType userAccountType = this._persistence_get_accountType();
            if (userAccountType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accountType((UserAccountType)object);
            }
        } else {
            this.accountType = null;
        }
    }

    public UserAccountType _persistence_get_accountType() {
        this._persistence_checkFetched("accountType");
        this._persistence_initialize_accountType_vh();
        this.accountType = (UserAccountType)this._persistence_accountType_vh.getValue();
        return this.accountType;
    }

    public void _persistence_set_accountType(UserAccountType userAccountType) {
        this._persistence_checkFetchedForSet("accountType");
        this._persistence_initialize_accountType_vh();
        this.accountType = (UserAccountType)this._persistence_accountType_vh.getValue();
        this._persistence_propertyChange("accountType", this.accountType, userAccountType);
        this.accountType = userAccountType;
        this._persistence_accountType_vh.setValue((Object)userAccountType);
    }

    protected void _persistence_initialize_channel_vh() {
        if (this._persistence_channel_vh == null) {
            this._persistence_channel_vh = new ValueHolder((Object)this.channel);
            this._persistence_channel_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_channel_vh() {
        Channel channel;
        this._persistence_initialize_channel_vh();
        if ((this._persistence_channel_vh.isCoordinatedWithProperty() || this._persistence_channel_vh.isNewlyWeavedValueHolder()) && (channel = this._persistence_get_channel()) != this._persistence_channel_vh.getValue()) {
            this._persistence_set_channel(channel);
        }
        return this._persistence_channel_vh;
    }

    public void _persistence_set_channel_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_channel_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Channel channel = this._persistence_get_channel();
            if (channel != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_channel((Channel)object);
            }
        } else {
            this.channel = null;
        }
    }

    public Channel _persistence_get_channel() {
        this._persistence_checkFetched("channel");
        this._persistence_initialize_channel_vh();
        this.channel = (Channel)this._persistence_channel_vh.getValue();
        return this.channel;
    }

    public void _persistence_set_channel(Channel channel) {
        this._persistence_checkFetchedForSet("channel");
        this._persistence_initialize_channel_vh();
        this.channel = (Channel)this._persistence_channel_vh.getValue();
        this._persistence_propertyChange("channel", this.channel, channel);
        this.channel = channel;
        this._persistence_channel_vh.setValue((Object)channel);
    }

    public SessionSource _persistence_get_source() {
        this._persistence_checkFetched("source");
        return this.source;
    }

    public void _persistence_set_source(SessionSource sessionSource) {
        this._persistence_checkFetchedForSet("source");
        this._persistence_propertyChange("source", this.source, sessionSource);
        this.source = sessionSource;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    protected void _persistence_initialize_customFieldValue_vh() {
        if (this._persistence_customFieldValue_vh == null) {
            this._persistence_customFieldValue_vh = new ValueHolder((Object)this.customFieldValue);
            this._persistence_customFieldValue_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_customFieldValue_vh() {
        UserCustomFieldValue userCustomFieldValue;
        this._persistence_initialize_customFieldValue_vh();
        if ((this._persistence_customFieldValue_vh.isCoordinatedWithProperty() || this._persistence_customFieldValue_vh.isNewlyWeavedValueHolder()) && (userCustomFieldValue = this._persistence_get_customFieldValue()) != this._persistence_customFieldValue_vh.getValue()) {
            this._persistence_set_customFieldValue(userCustomFieldValue);
        }
        return this._persistence_customFieldValue_vh;
    }

    public void _persistence_set_customFieldValue_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_customFieldValue_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            UserCustomFieldValue userCustomFieldValue = this._persistence_get_customFieldValue();
            if (userCustomFieldValue != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_customFieldValue((UserCustomFieldValue)object);
            }
        } else {
            this.customFieldValue = null;
        }
    }

    public UserCustomFieldValue _persistence_get_customFieldValue() {
        this._persistence_checkFetched("customFieldValue");
        this._persistence_initialize_customFieldValue_vh();
        this.customFieldValue = (UserCustomFieldValue)this._persistence_customFieldValue_vh.getValue();
        return this.customFieldValue;
    }

    public void _persistence_set_customFieldValue(UserCustomFieldValue userCustomFieldValue) {
        this._persistence_checkFetchedForSet("customFieldValue");
        this._persistence_initialize_customFieldValue_vh();
        this.customFieldValue = (UserCustomFieldValue)this._persistence_customFieldValue_vh.getValue();
        this._persistence_propertyChange("customFieldValue", this.customFieldValue, userCustomFieldValue);
        this.customFieldValue = userCustomFieldValue;
        this._persistence_customFieldValue_vh.setValue((Object)userCustomFieldValue);
    }

    protected void _persistence_initialize_identityProvider_vh() {
        if (this._persistence_identityProvider_vh == null) {
            this._persistence_identityProvider_vh = new ValueHolder((Object)this.identityProvider);
            this._persistence_identityProvider_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_identityProvider_vh() {
        IdentityProvider identityProvider;
        this._persistence_initialize_identityProvider_vh();
        if ((this._persistence_identityProvider_vh.isCoordinatedWithProperty() || this._persistence_identityProvider_vh.isNewlyWeavedValueHolder()) && (identityProvider = this._persistence_get_identityProvider()) != this._persistence_identityProvider_vh.getValue()) {
            this._persistence_set_identityProvider(identityProvider);
        }
        return this._persistence_identityProvider_vh;
    }

    public void _persistence_set_identityProvider_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_identityProvider_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            IdentityProvider identityProvider = this._persistence_get_identityProvider();
            if (identityProvider != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_identityProvider((IdentityProvider)object);
            }
        } else {
            this.identityProvider = null;
        }
    }

    public IdentityProvider _persistence_get_identityProvider() {
        this._persistence_checkFetched("identityProvider");
        this._persistence_initialize_identityProvider_vh();
        this.identityProvider = (IdentityProvider)this._persistence_identityProvider_vh.getValue();
        return this.identityProvider;
    }

    public void _persistence_set_identityProvider(IdentityProvider identityProvider) {
        this._persistence_checkFetchedForSet("identityProvider");
        this._persistence_initialize_identityProvider_vh();
        this.identityProvider = (IdentityProvider)this._persistence_identityProvider_vh.getValue();
        this._persistence_propertyChange("identityProvider", this.identityProvider, identityProvider);
        this.identityProvider = identityProvider;
        this._persistence_identityProvider_vh.setValue((Object)identityProvider);
    }

    protected void _persistence_initialize_token_vh() {
        if (this._persistence_token_vh == null) {
            this._persistence_token_vh = new ValueHolder((Object)this.token);
            this._persistence_token_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_token_vh() {
        Token token;
        this._persistence_initialize_token_vh();
        if ((this._persistence_token_vh.isCoordinatedWithProperty() || this._persistence_token_vh.isNewlyWeavedValueHolder()) && (token = this._persistence_get_token()) != this._persistence_token_vh.getValue()) {
            this._persistence_set_token(token);
        }
        return this._persistence_token_vh;
    }

    public void _persistence_set_token_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_token_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Token token = this._persistence_get_token();
            if (token != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_token((Token)object);
            }
        } else {
            this.token = null;
        }
    }

    public Token _persistence_get_token() {
        this._persistence_checkFetched("token");
        this._persistence_initialize_token_vh();
        this.token = (Token)this._persistence_token_vh.getValue();
        return this.token;
    }

    public void _persistence_set_token(Token token) {
        this._persistence_checkFetchedForSet("token");
        this._persistence_initialize_token_vh();
        this.token = (Token)this._persistence_token_vh.getValue();
        this._persistence_propertyChange("token", this.token, token);
        this.token = token;
        this._persistence_token_vh.setValue((Object)token);
    }

    protected void _persistence_initialize_mobilePhone_vh() {
        if (this._persistence_mobilePhone_vh == null) {
            this._persistence_mobilePhone_vh = new ValueHolder((Object)this.mobilePhone);
            this._persistence_mobilePhone_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_mobilePhone_vh() {
        MobilePhone mobilePhone;
        this._persistence_initialize_mobilePhone_vh();
        if ((this._persistence_mobilePhone_vh.isCoordinatedWithProperty() || this._persistence_mobilePhone_vh.isNewlyWeavedValueHolder()) && (mobilePhone = this._persistence_get_mobilePhone()) != this._persistence_mobilePhone_vh.getValue()) {
            this._persistence_set_mobilePhone(mobilePhone);
        }
        return this._persistence_mobilePhone_vh;
    }

    public void _persistence_set_mobilePhone_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_mobilePhone_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            MobilePhone mobilePhone = this._persistence_get_mobilePhone();
            if (mobilePhone != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_mobilePhone((MobilePhone)object);
            }
        } else {
            this.mobilePhone = null;
        }
    }

    public MobilePhone _persistence_get_mobilePhone() {
        this._persistence_checkFetched("mobilePhone");
        this._persistence_initialize_mobilePhone_vh();
        this.mobilePhone = (MobilePhone)this._persistence_mobilePhone_vh.getValue();
        return this.mobilePhone;
    }

    public void _persistence_set_mobilePhone(MobilePhone mobilePhone) {
        this._persistence_checkFetchedForSet("mobilePhone");
        this._persistence_initialize_mobilePhone_vh();
        this.mobilePhone = (MobilePhone)this._persistence_mobilePhone_vh.getValue();
        this._persistence_propertyChange("mobilePhone", this.mobilePhone, mobilePhone);
        this.mobilePhone = mobilePhone;
        this._persistence_mobilePhone_vh.setValue((Object)mobilePhone);
    }

    protected void _persistence_initialize_pin_vh() {
        if (this._persistence_pin_vh == null) {
            this._persistence_pin_vh = new ValueHolder((Object)this.pin);
            this._persistence_pin_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_pin_vh() {
        Pin pin;
        this._persistence_initialize_pin_vh();
        if ((this._persistence_pin_vh.isCoordinatedWithProperty() || this._persistence_pin_vh.isNewlyWeavedValueHolder()) && (pin = this._persistence_get_pin()) != this._persistence_pin_vh.getValue()) {
            this._persistence_set_pin(pin);
        }
        return this._persistence_pin_vh;
    }

    public void _persistence_set_pin_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_pin_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Pin pin = this._persistence_get_pin();
            if (pin != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_pin((Pin)object);
            }
        } else {
            this.pin = null;
        }
    }

    public Pin _persistence_get_pin() {
        this._persistence_checkFetched("pin");
        this._persistence_initialize_pin_vh();
        this.pin = (Pin)this._persistence_pin_vh.getValue();
        return this.pin;
    }

    public void _persistence_set_pin(Pin pin) {
        this._persistence_checkFetchedForSet("pin");
        this._persistence_initialize_pin_vh();
        this.pin = (Pin)this._persistence_pin_vh.getValue();
        this._persistence_propertyChange("pin", this.pin, pin);
        this.pin = pin;
        this._persistence_pin_vh.setValue((Object)pin);
    }

    public String _persistence_get_sessionToken() {
        this._persistence_checkFetched("sessionToken");
        return this.sessionToken;
    }

    public void _persistence_set_sessionToken(String string) {
        this._persistence_checkFetchedForSet("sessionToken");
        this._persistence_propertyChange("sessionToken", this.sessionToken, string);
        this.sessionToken = string;
    }

    public TimeInterval _persistence_get_sessionTimeout() {
        this._persistence_checkFetched("sessionTimeout");
        return this.sessionTimeout;
    }

    public void _persistence_set_sessionTimeout(TimeInterval timeInterval) {
        this._persistence_checkFetchedForSet("sessionTimeout");
        this._persistence_propertyChange("sessionTimeout", this.sessionTimeout, timeInterval);
        this.sessionTimeout = timeInterval;
    }

    protected void _persistence_initialize_trustedDevice_vh() {
        if (this._persistence_trustedDevice_vh == null) {
            this._persistence_trustedDevice_vh = new ValueHolder((Object)this.trustedDevice);
            this._persistence_trustedDevice_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_trustedDevice_vh() {
        TrustedDevice trustedDevice;
        this._persistence_initialize_trustedDevice_vh();
        if ((this._persistence_trustedDevice_vh.isCoordinatedWithProperty() || this._persistence_trustedDevice_vh.isNewlyWeavedValueHolder()) && (trustedDevice = this._persistence_get_trustedDevice()) != this._persistence_trustedDevice_vh.getValue()) {
            this._persistence_set_trustedDevice(trustedDevice);
        }
        return this._persistence_trustedDevice_vh;
    }

    public void _persistence_set_trustedDevice_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_trustedDevice_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            TrustedDevice trustedDevice = this._persistence_get_trustedDevice();
            if (trustedDevice != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_trustedDevice((TrustedDevice)object);
            }
        } else {
            this.trustedDevice = null;
        }
    }

    public TrustedDevice _persistence_get_trustedDevice() {
        this._persistence_checkFetched("trustedDevice");
        this._persistence_initialize_trustedDevice_vh();
        this.trustedDevice = (TrustedDevice)this._persistence_trustedDevice_vh.getValue();
        return this.trustedDevice;
    }

    public void _persistence_set_trustedDevice(TrustedDevice trustedDevice) {
        this._persistence_checkFetchedForSet("trustedDevice");
        this._persistence_initialize_trustedDevice_vh();
        this.trustedDevice = (TrustedDevice)this._persistence_trustedDevice_vh.getValue();
        this._persistence_propertyChange("trustedDevice", this.trustedDevice, trustedDevice);
        this.trustedDevice = trustedDevice;
        this._persistence_trustedDevice_vh.setValue((Object)trustedDevice);
    }

    protected void _persistence_initialize_user_vh() {
        if (this._persistence_user_vh == null) {
            this._persistence_user_vh = new ValueHolder((Object)this.user);
            this._persistence_user_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_user_vh() {
        User user;
        this._persistence_initialize_user_vh();
        if ((this._persistence_user_vh.isCoordinatedWithProperty() || this._persistence_user_vh.isNewlyWeavedValueHolder()) && (user = this._persistence_get_user()) != this._persistence_user_vh.getValue()) {
            this._persistence_set_user(user);
        }
        return this._persistence_user_vh;
    }

    public void _persistence_set_user_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_user_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            User user = this._persistence_get_user();
            if (user != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_user((User)object);
            }
        } else {
            this.user = null;
        }
    }

    public User _persistence_get_user() {
        this._persistence_checkFetched("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        return this.user;
    }

    public void _persistence_set_user(User user) {
        this._persistence_checkFetchedForSet("user");
        this._persistence_initialize_user_vh();
        this.user = (User)this._persistence_user_vh.getValue();
        this._persistence_propertyChange("user", this.user, user);
        this.user = user;
        this._persistence_user_vh.setValue((Object)user);
    }

    protected void _persistence_initialize_accessClient_vh() {
        if (this._persistence_accessClient_vh == null) {
            this._persistence_accessClient_vh = new ValueHolder((Object)this.accessClient);
            this._persistence_accessClient_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_accessClient_vh() {
        AccessClient accessClient;
        this._persistence_initialize_accessClient_vh();
        if ((this._persistence_accessClient_vh.isCoordinatedWithProperty() || this._persistence_accessClient_vh.isNewlyWeavedValueHolder()) && (accessClient = this._persistence_get_accessClient()) != this._persistence_accessClient_vh.getValue()) {
            this._persistence_set_accessClient(accessClient);
        }
        return this._persistence_accessClient_vh;
    }

    public void _persistence_set_accessClient_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_accessClient_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            AccessClient accessClient = this._persistence_get_accessClient();
            if (accessClient != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_accessClient((AccessClient)object);
            }
        } else {
            this.accessClient = null;
        }
    }

    public AccessClient _persistence_get_accessClient() {
        this._persistence_checkFetched("accessClient");
        this._persistence_initialize_accessClient_vh();
        this.accessClient = (AccessClient)this._persistence_accessClient_vh.getValue();
        return this.accessClient;
    }

    public void _persistence_set_accessClient(AccessClient accessClient) {
        this._persistence_checkFetchedForSet("accessClient");
        this._persistence_initialize_accessClient_vh();
        this.accessClient = (AccessClient)this._persistence_accessClient_vh.getValue();
        this._persistence_propertyChange("accessClient", this.accessClient, accessClient);
        this.accessClient = accessClient;
        this._persistence_accessClient_vh.setValue((Object)accessClient);
    }

    public String _persistence_get_remoteAddress() {
        this._persistence_checkFetched("remoteAddress");
        return this.remoteAddress;
    }

    public void _persistence_set_remoteAddress(String string) {
        this._persistence_checkFetchedForSet("remoteAddress");
        this._persistence_propertyChange("remoteAddress", this.remoteAddress, string);
        this.remoteAddress = string;
    }

    protected void _persistence_initialize_principalType_vh() {
        if (this._persistence_principalType_vh == null) {
            this._persistence_principalType_vh = new ValueHolder((Object)this.principalType);
            this._persistence_principalType_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_principalType_vh() {
        PrincipalType principalType;
        this._persistence_initialize_principalType_vh();
        if ((this._persistence_principalType_vh.isCoordinatedWithProperty() || this._persistence_principalType_vh.isNewlyWeavedValueHolder()) && (principalType = this._persistence_get_principalType()) != this._persistence_principalType_vh.getValue()) {
            this._persistence_set_principalType(principalType);
        }
        return this._persistence_principalType_vh;
    }

    public void _persistence_set_principalType_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_principalType_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PrincipalType principalType = this._persistence_get_principalType();
            if (principalType != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_principalType((PrincipalType)object);
            }
        } else {
            this.principalType = null;
        }
    }

    public PrincipalType _persistence_get_principalType() {
        this._persistence_checkFetched("principalType");
        this._persistence_initialize_principalType_vh();
        this.principalType = (PrincipalType)this._persistence_principalType_vh.getValue();
        return this.principalType;
    }

    public void _persistence_set_principalType(PrincipalType principalType) {
        this._persistence_checkFetchedForSet("principalType");
        this._persistence_initialize_principalType_vh();
        this.principalType = (PrincipalType)this._persistence_principalType_vh.getValue();
        this._persistence_propertyChange("principalType", this.principalType, principalType);
        this.principalType = principalType;
        this._persistence_principalType_vh.setValue((Object)principalType);
    }
}

