/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.utils.PushNotificationEvent;
import org.cyclos.model.utils.PushNotificationEventFilter;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.services.access.InvocationData;
import org.cyclos.services.access.ServiceFacade;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.web.utils.ServletHelper;
import org.cyclos.web.utils.SseEmitterHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class SseEmitterHandlerImpl
implements SseEmitterHandler {
    public static final Logger LOG = LogManager.getLogger(SseEmitterHandlerImpl.class);
    private static final Runnable NO_OP = () -> {};
    @Autowired
    private ServiceFacade serviceFacade;

    @Override
    public SseEmitter subscribe(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, PushNotificationEventFilter pushNotificationEventFilter, Function<PushNotificationEvent<?>, Object> function) throws IOException {
        Object object;
        InvocationData invocationData = ServletHelper.resolveInvocationData(httpServletRequest);
        RequestData requestData = ServletHelper.getRequestData();
        if (pushNotificationEventFilter == null || CollectionHelper.isEmpty((Iterable)pushNotificationEventFilter.getTypes())) {
            throw new ValidationException("No valid event types specified");
        }
        httpServletResponse.addHeader("X-Accel-Buffering", "no");
        SseEmitter sseEmitter = new SseEmitter(Long.valueOf(40000L));
        MutableObject mutableObject = new MutableObject(null);
        try {
            object = pushNotificationEvent -> this.handle(sseEmitter, httpServletRequest, httpServletResponse, requestData, (PushNotificationEvent<?>)pushNotificationEvent, function);
            mutableObject.set((Object)this.serviceFacade.subscribe(invocationData, string, pushNotificationEventFilter, object));
        }
        catch (InvalidSessionDataException invalidSessionDataException) {
            if (pushNotificationEventFilter.getTypes().contains(PushNotificationEventType.LOGGED_OUT)) {
                httpServletResponse.setContentType("text/event-stream");
                httpServletResponse.setCharacterEncoding("UTF-8");
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.write("event: " + PushNotificationEventType.LOGGED_OUT.getName() + "\n");
                printWriter.write("data: \n\n");
                printWriter.close();
                return null;
            }
            throw invalidSessionDataException;
        }
        object = (String)mutableObject.get();
        sseEmitter.send(SseEmitter.event().comment("Initialized"));
        sseEmitter.onCompletion(() -> this.lambda$subscribe$2(httpServletRequest, (String)object, sseEmitter));
        sseEmitter.onTimeout(() -> this.lambda$subscribe$3(httpServletRequest, (String)object));
        return sseEmitter;
    }

    private void discardSse(SseEmitter sseEmitter) {
        sseEmitter.onCompletion(NO_OP);
        sseEmitter.onTimeout(NO_OP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(SseEmitter sseEmitter, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RequestData requestData, PushNotificationEvent<?> pushNotificationEvent, Function<PushNotificationEvent<?>, Object> function) {
        try {
            ServletHelper.CURRENT_REQUEST.set(httpServletRequest);
            ServletHelper.CURRENT_RESPONSE.set(httpServletResponse);
            ServletHelper.CURRENT_REQUEST_DATA.set(requestData);
            Object object = ObjectHelper.defaultValue((Object)function.apply(pushNotificationEvent), (Object)Collections.EMPTY_MAP);
            sseEmitter.send(SseEmitter.event().id(pushNotificationEvent.getId()).name(pushNotificationEvent.getType().getName()).data(object, MediaType.APPLICATION_JSON));
        }
        catch (IOException | IllegalStateException exception) {
            LOG.debug("Error sending a push notification", (Throwable)exception);
        }
        finally {
            ServletHelper.CURRENT_REQUEST.remove();
            ServletHelper.CURRENT_RESPONSE.remove();
            ServletHelper.CURRENT_REQUEST_DATA.remove();
        }
    }

    private /* synthetic */ void lambda$subscribe$3(HttpServletRequest httpServletRequest, String string) {
        httpServletRequest.setAttribute("ignoreError", (Object)true);
        httpServletRequest.setAttribute("timeout", (Object)System.currentTimeMillis());
        this.serviceFacade.timeoutSubscription(string);
    }

    private /* synthetic */ void lambda$subscribe$2(HttpServletRequest httpServletRequest, String string, SseEmitter sseEmitter) {
        Long l = (Long)httpServletRequest.getAttribute("timeout");
        if (l == null || l < System.currentTimeMillis() - 1000L) {
            this.serviceFacade.closeSubscription(string);
            this.discardSse(sseEmitter);
        }
    }
}

