/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.utils;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.model.access.InvalidChannelUsageException;
import org.cyclos.model.access.LoggedOutException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.utils.AuthorizationData;
import org.cyclos.model.utils.Cookie;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.NotificationLevel;
import org.cyclos.model.utils.RequestInfo;
import org.cyclos.model.utils.ResponseInfo;
import org.cyclos.model.utils.StoredFileVO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.Service;
import org.cyclos.services.access.AccessClientInvocationData;
import org.cyclos.services.access.GuestInvocationData;
import org.cyclos.services.access.InvocationData;
import org.cyclos.services.access.OidcInvocationData;
import org.cyclos.services.access.StatefulUserInvocationData;
import org.cyclos.services.access.StatelessUserInvocationData;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.ParameterStorage;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rpc.WebRpcContentHandlerImpl;
import org.cyclos.web.rpc.WebRpcRequestHandler;
import org.cyclos.web.utils.AuthenticationMode;
import org.cyclos.web.utils.HttpRequestCookiesParameterStorage;
import org.cyclos.web.utils.HttpRequestHeadersParameterStorage;
import org.cyclos.web.utils.HttpRequestParametersParameterStorage;
import org.cyclos.web.utils.RequestHelper;
import org.springframework.http.ResponseCookie;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

public class ServletHelper {
    public static ThreadLocal<HttpServletRequest> CURRENT_REQUEST = new ThreadLocal();
    public static ThreadLocal<HttpServletResponse> CURRENT_RESPONSE = new ThreadLocal();
    public static ThreadLocal<RequestData> CURRENT_REQUEST_DATA = new ThreadLocal();
    public static final int GZIP_BUFFER_SIZE = 8192;
    public static final String REQUEST_DATA = "requestData";
    public static final String FORCE_GUEST = "forceGuest";
    public static final String DENY_GUEST = "denyGuest";
    public static final String REMOTE_INVOCATION = "remoteInvocation";
    public static final String INVOCATION_DATA = "invocationData";

    public static void denyGuest(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute(DENY_GUEST, (Object)true);
    }

    public static void forceGuest(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute(FORCE_GUEST, (Object)true);
        InvocationData invocationData = (InvocationData)httpServletRequest.getAttribute(INVOCATION_DATA);
        if (invocationData != null && !(invocationData instanceof GuestInvocationData)) {
            httpServletRequest.removeAttribute(INVOCATION_DATA);
        }
    }

    public static String getChannelName(HttpServletRequest httpServletRequest) {
        return (String)ObjectHelper.coalesce((Object[])new String[]{StringHelper.trimToNull((Object)httpServletRequest.getHeader("Channel")), StringHelper.trimToNull((Object)httpServletRequest.getParameter(StringHelper.camelize((String)"Channel"))), BuiltInChannel.WEB_SERVICES.getInternalName()});
    }

    public static BuiltInChannel getContentChannel(HttpServletRequest httpServletRequest) {
        return (BuiltInChannel)ObjectHelper.defaultValue((Object)((BuiltInChannel)httpServletRequest.getAttribute("contentChannel")), (Object)BuiltInChannel.MAIN);
    }

    public static String getInternalUri(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getContextPath();
        if (StringHelper.isNotBlank((Object)string2)) {
            string = string.substring(string2.length());
        }
        return StringHelper.replace((String)string, (String)"//", (String)"/");
    }

    public static String getPreferredLocale(HttpServletRequest httpServletRequest) {
        String string = StringHelper.trimToNull((Object)httpServletRequest.getHeader("Preferred-Locale"));
        if (string != null) {
            return string;
        }
        string = StringHelper.trimToNull((Object)httpServletRequest.getParameter(StringHelper.camelize((String)"Preferred-Locale")));
        return string;
    }

    public static RemoteInvocation getRemoteInvocation(HttpServletRequest httpServletRequest) {
        return (RemoteInvocation)httpServletRequest.getAttribute(REMOTE_INVOCATION);
    }

    public static HttpServletRequest getRequest() {
        return CURRENT_REQUEST.get();
    }

    public static RequestData getRequestData() {
        HttpServletRequest httpServletRequest;
        RequestData requestData = CURRENT_REQUEST_DATA.get();
        if (requestData == null && (httpServletRequest = ServletHelper.getRequest()) != null) {
            requestData = (RequestData)httpServletRequest.getAttribute(REQUEST_DATA);
        }
        if (requestData == null) {
            throw new IllegalStateException("No RequestData in the current request");
        }
        return requestData;
    }

    public static RequestData getRequestData(HttpServletRequest httpServletRequest) {
        RequestData requestData = (RequestData)httpServletRequest.getAttribute(REQUEST_DATA);
        if (requestData == null) {
            requestData = CURRENT_REQUEST_DATA.get();
        }
        if (requestData == null) {
            throw new IllegalStateException("No RequestData in the current request");
        }
        return requestData;
    }

    public static HttpServletResponse getResponse() {
        return CURRENT_RESPONSE.get();
    }

    public static String getSessionToken(HttpServletRequest httpServletRequest) {
        if (Boolean.TRUE.equals(httpServletRequest.getAttribute(FORCE_GUEST))) {
            return null;
        }
        String string = StringHelper.trimToNull((Object)httpServletRequest.getAttribute("Session-Token"));
        if (string != null) {
            return string;
        }
        String string2 = StringHelper.trimToNull((Object)httpServletRequest.getParameter("Session-Token"));
        if (string2 != null) {
            return string2;
        }
        string2 = StringHelper.trimToNull((Object)httpServletRequest.getParameter(StringHelper.camelize((String)"Session-Token")));
        if (string2 != null) {
            return string2;
        }
        String string3 = StringHelper.trimToNull((Object)httpServletRequest.getHeader("Session-Token"));
        if (string3 != null) {
            return string3;
        }
        String string4 = RequestHelper.getCookieValue(httpServletRequest, Cookie.SESSION_TOKEN);
        if (string4 != null) {
            String string5 = StringHelper.trimToNull((Object)httpServletRequest.getHeader("Session-Prefix"));
            if (string5 == null) {
                string5 = StringHelper.trimToNull((Object)httpServletRequest.getParameter("Session-Prefix"));
            }
            if (string5 != null) {
                return string5 + string4;
            }
        }
        return null;
    }

    public static boolean isProxied(HttpServletRequest httpServletRequest) {
        return Boolean.TRUE.equals(httpServletRequest.getAttribute("proxied"));
    }

    public static AuthenticationMode resolveAuthenticationMode(HttpServletRequest httpServletRequest) {
        InvocationData invocationData = ServletHelper.resolveInvocationData(httpServletRequest);
        if (invocationData == null || invocationData instanceof GuestInvocationData) {
            return AuthenticationMode.GUEST;
        }
        if (invocationData instanceof StatelessUserInvocationData) {
            return AuthenticationMode.BASIC;
        }
        if (invocationData instanceof StatefulUserInvocationData) {
            return AuthenticationMode.SESSION;
        }
        if (invocationData instanceof AccessClientInvocationData) {
            return AuthenticationMode.ACCESS_CLIENT;
        }
        if (invocationData instanceof OidcInvocationData) {
            return AuthenticationMode.OIDC;
        }
        throw new IllegalStateException("Unhandled invocation data: " + String.valueOf(invocationData));
    }

    public static InvocationData resolveInvocationData(HttpServletRequest httpServletRequest) {
        Object object = (InvocationData)httpServletRequest.getAttribute(INVOCATION_DATA);
        if (object != null) {
            return object;
        }
        RequestData requestData = ServletHelper.getRequestData(httpServletRequest);
        String string = null;
        boolean bl = Boolean.TRUE.equals(httpServletRequest.getAttribute(FORCE_GUEST));
        if (ServletHelper.isWebRpc(requestData)) {
            AuthorizationData authorizationData;
            string = ServletHelper.getChannelName(httpServletRequest);
            AuthorizationData authorizationData2 = authorizationData = bl ? null : RequestHelper.getAuthorization(httpServletRequest);
            if (authorizationData != null) {
                if (authorizationData.isValid()) {
                    if (authorizationData.isBasic()) {
                        String string2 = httpServletRequest.getHeader("Principal-Type");
                        object = new StatelessUserInvocationData(string2, authorizationData.getPrincipal(), authorizationData.getPassword());
                    } else if (authorizationData.isBearer()) {
                        String string3 = StringHelper.trim((Object)authorizationData.getValue());
                        object = string3.contains(".") ? new OidcInvocationData(string3) : new AccessClientInvocationData(string3);
                    }
                }
                if (object == null) {
                    object = new GuestInvocationData(string);
                }
            } else {
                String string4 = ServletHelper.getSessionToken(httpServletRequest);
                if (string4 == null) {
                    String string5 = ServletHelper.getAccessClientToken(httpServletRequest);
                    object = string5 == null ? new GuestInvocationData(string) : new AccessClientInvocationData(string5);
                } else {
                    String string6 = StringHelper.trimToNull((Object)httpServletRequest.getHeader("Remote-Address"));
                    object = new StatefulUserInvocationData(string4, string6);
                }
            }
        } else {
            string = ServletHelper.getContentChannel(httpServletRequest).getInternalName();
            String string7 = ServletHelper.getSessionToken(httpServletRequest);
            object = StringHelper.isBlank((Object)string7) ? new GuestInvocationData(string) : new StatefulUserInvocationData(string7);
        }
        ServletHelper.setInvocationData(httpServletRequest, object, string);
        return object;
    }

    public static InvocationData resolveServiceInvocationData(HttpServletRequest httpServletRequest, Class<? extends Service> clazz, Method method, Object[] objectArray) {
        InvocationData invocationData = ServletHelper.resolveInvocationData(httpServletRequest);
        invocationData.setServiceInterface(clazz);
        invocationData.setMethodName(method.getName());
        invocationData.setParameterTypes((Class[])method.getParameterTypes());
        invocationData.setParameters(objectArray);
        return invocationData;
    }

    public static <T> T runAsLocal(Callable<T> callable) {
        RequestData requestData = ServletHelper.getRequestData();
        String string = requestData.getRemoteAddress();
        try {
            requestData.setRemoteAddress("127.0.0.1");
            T t = callable.call();
            return t;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            requestData.setRemoteAddress(string);
        }
    }

    public static void sendCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl, boolean bl2, Cookie cookie, String string2) {
        if (string == null) {
            string = ServletHelper.isProxied(httpServletRequest) ? "/" : StringHelper.removeEnd((String)httpServletRequest.getContextPath(), (String)"/") + "/";
        }
        RequestData requestData = ServletHelper.getRequestData();
        ResponseCookie.ResponseCookieBuilder responseCookieBuilder = ResponseCookie.from((String)cookie.cookieName(), (String)(string2 == null ? "" : string2)).maxAge(string2 == null ? 0L : -1L).path(string).httpOnly(bl).secure(requestData.isSecure());
        if (bl2) {
            responseCookieBuilder.sameSite("Strict");
        } else {
            responseCookieBuilder.sameSite("Lax");
        }
        httpServletResponse.addHeader("Set-Cookie", responseCookieBuilder.build().toString());
    }

    public static ModelAndView sendNotification(NotificationLevel notificationLevel, String string, String string2, boolean bl) {
        RequestData requestData;
        try {
            requestData = ServletHelper.getRequestData();
        }
        catch (Exception exception) {
            requestData = null;
        }
        return new ModelAndView("store-message").addObject("notificationLevel", (Object)notificationLevel).addObject("notificationMessage", (Object)string).addObject("notificationOnly", (Object)bl).addObject("rootUrl", (Object)(requestData == null ? null : requestData.getBaseUrl())).addObject("browserNotSupported", (Object)string2);
    }

    public static void setContentChannel(HttpServletRequest httpServletRequest, BuiltInChannel builtInChannel) {
        httpServletRequest.setAttribute("contentChannel", (Object)builtInChannel);
    }

    public static void setContentType(HttpServletResponse httpServletResponse, ContentType contentType) throws IOException {
        httpServletResponse.setHeader("Content-Type", (String)(contentType.isBinary() ? contentType.getMimeType() : contentType.getMimeType() + ";charset=UTF-8"));
    }

    public static void setFileName(HttpServletResponse httpServletResponse, String string, boolean bl) {
        httpServletResponse.setHeader("Content-Disposition", (bl ? "attachment" : "inline") + "; filename=\"" + string + "\"");
    }

    public static void setHeaders(HttpServletResponse httpServletResponse, StoredFileVO storedFileVO, boolean bl) {
        httpServletResponse.setContentType(storedFileVO.getContentType());
        Integer n = storedFileVO.getLength();
        if (n != null) {
            httpServletResponse.setContentLength(n.intValue());
        }
        ServletHelper.setFileName(httpServletResponse, storedFileVO.getName(), bl);
    }

    public static void setInvocationData(HttpServletRequest httpServletRequest, InvocationData invocationData, String string) {
        if (invocationData == null) {
            throw new LoggedOutException();
        }
        BuiltInChannel builtInChannel = BuiltInChannel.getByInternalName((String)string);
        if (builtInChannel != null && builtInChannel.isSpecificEntryPoint()) {
            throw new InvalidChannelUsageException();
        }
        invocationData.setChannel(string);
        invocationData.setRequestData(ServletHelper.getRequestData(httpServletRequest));
        httpServletRequest.setAttribute(INVOCATION_DATA, (Object)invocationData);
        if (invocationData instanceof GuestInvocationData && Boolean.TRUE.equals(httpServletRequest.getAttribute(DENY_GUEST))) {
            throw new PermissionDeniedException();
        }
    }

    public static void setLongCache(HttpServletResponse httpServletResponse) {
        int n = 34560000;
        Date date = DateHelper.add((Date)new Date(), (TimeField)TimeField.SECONDS, (int)n);
        httpServletResponse.setHeader("Cache-control", "max-age=" + n + ", public");
        httpServletResponse.setDateHeader("Expires", date.getTime());
    }

    public static void setNoCache(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-control", "max-age=0, no-cache");
    }

    public static void setProxied(HttpServletRequest httpServletRequest, boolean bl) {
        httpServletRequest.setAttribute("proxied", (Object)bl);
    }

    public static void setRemoteInvocation(HttpServletRequest httpServletRequest, RemoteInvocation remoteInvocation) {
        httpServletRequest.setAttribute(REMOTE_INVOCATION, (Object)remoteInvocation);
    }

    public static void setSessionToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        string = StringHelper.trimToNull((Object)string);
        ServletHelper.sendCookie(httpServletRequest, httpServletResponse, null, true, true, Cookie.SESSION_TOKEN, string);
        ServletHelper.setSessionToken(httpServletRequest, string);
    }

    public static void setSessionToken(HttpServletRequest httpServletRequest, String string) {
        httpServletRequest.setAttribute("Session-Token", (Object)string);
        httpServletRequest.setAttribute(FORCE_GUEST, (Object)(string == null ? 1 : 0));
        RequestHelper.setIgnoreAuthorization(httpServletRequest, true);
        httpServletRequest.removeAttribute(INVOCATION_DATA);
    }

    public static void setUseCache(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-control", "public");
        httpServletResponse.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
    }

    public static ModelAndView showError(String string) {
        return new ModelAndView("show-error").addObject("message", (Object)string);
    }

    public static Pair<String, String> splitSessionToken(String string) {
        int n = string.length() / 2;
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        return Pair.create((Object)string2, (Object)string3);
    }

    public static FileInfo toFileInfo(MultipartFile multipartFile) throws IOException {
        if (multipartFile == null) {
            return null;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setContentType(multipartFile.getContentType());
        fileInfo.setContent(new SerializableInputStream(multipartFile.getInputStream()));
        fileInfo.setLength(Integer.valueOf((int)multipartFile.getSize()));
        fileInfo.setName(multipartFile.getOriginalFilename());
        return fileInfo;
    }

    public static RequestInfo toRequestInfo(HttpServletRequest httpServletRequest) throws IOException {
        return RequestInfo.builder().method(httpServletRequest.getMethod()).parameters((ParameterStorage)new HttpRequestParametersParameterStorage(httpServletRequest)).cookies((ParameterStorage)new HttpRequestCookiesParameterStorage(httpServletRequest)).headers((ParameterStorage)new HttpRequestHeadersParameterStorage(httpServletRequest)).body(new SerializableInputStream((InputStream)httpServletRequest.getInputStream())).build();
    }

    public static void writeContents(HttpServletResponse httpServletResponse, InputStream inputStream) throws IOException {
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)httpServletResponse.getOutputStream());
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    public static void writeCSVContents(HttpServletResponse httpServletResponse, String string, InputStream inputStream) throws IOException {
        ServletHelper.setContentType(httpServletResponse, ContentType.CSV);
        ServletHelper.setFileName(httpServletResponse, string, true);
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)httpServletResponse.getOutputStream());
        }
        finally {
            IOHelper.close((Closeable)inputStream);
            httpServletResponse.flushBuffer();
        }
    }

    public static void writeFileContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileInfo fileInfo) throws IOException {
        String string;
        if (fileInfo == null) {
            httpServletResponse.flushBuffer();
            return;
        }
        httpServletResponse.setContentType(fileInfo.getContentType());
        if (fileInfo.getEncoding() != null) {
            httpServletResponse.setCharacterEncoding(fileInfo.getEncoding());
        }
        if (StringHelper.isNotBlank((Object)(string = fileInfo.getName()))) {
            ServletHelper.setFileName(httpServletResponse, string, true);
        } else {
            httpServletResponse.setHeader("Content-Disposition", "attachment");
        }
        if (fileInfo.getLength() != null) {
            httpServletResponse.setIntHeader("Content-Length", fileInfo.getLength().intValue());
        }
        if (fileInfo.getLastModified() != null) {
            httpServletResponse.setDateHeader("Last-Modified", fileInfo.getLastModified().longValue());
        }
        httpServletResponse.setDateHeader("Date", System.currentTimeMillis());
        if (fileInfo.isPartialData()) {
            httpServletResponse.setHeader("X-Partial-Data", "true");
        }
        if (fileInfo.getEncoding() != null) {
            IOHelper.copyAndClose((Reader)new InputStreamReader((InputStream)fileInfo.getContent(), fileInfo.getEncoding()), (Writer)httpServletResponse.getWriter());
        } else {
            IOHelper.copyAndClose((InputStream)fileInfo.getContent(), (OutputStream)httpServletResponse.getOutputStream());
        }
        httpServletResponse.flushBuffer();
    }

    public static void writeFileContents(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ContentType contentType, File file, File file2, String string) throws IOException {
        ServletHelper.setContentType(httpServletResponse, contentType);
        if (!contentType.isBinary()) {
            httpServletResponse.setCharacterEncoding("UTF-8");
        }
        if (StringHelper.isNotBlank((Object)string)) {
            ServletHelper.setFileName(httpServletResponse, string, true);
        }
        boolean bl = contentType.isBinary();
        File file3 = file;
        if (file2 != null && file2.length() >= 9L && RequestHelper.acceptsGzip(httpServletRequest)) {
            httpServletResponse.addHeader("Content-Encoding", "gzip");
            bl = true;
            file3 = file2;
        }
        httpServletResponse.setIntHeader("Content-Length", (int)file3.length());
        httpServletResponse.setDateHeader("Last-Modified", file3.lastModified());
        httpServletResponse.setDateHeader("Date", System.currentTimeMillis());
        try (FileInputStream fileInputStream = new FileInputStream(file3);){
            if (bl) {
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)httpServletResponse.getOutputStream());
            } else {
                IOUtils.copy((Reader)new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8), (Writer)httpServletResponse.getWriter());
            }
            httpServletResponse.flushBuffer();
        }
    }

    public static void writeJsonErrorToResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable throwable) throws IOException {
        JsonConverter jsonConverter = ServletHelper.getBean(httpServletRequest, JsonConverter.class);
        Map<String, Object> map = WebRpcContentHandlerImpl.wrapError(throwable, jsonConverter.getObjectMapper());
        httpServletResponse.setStatus(WebRpcRequestHandler.resolveStatusCode(throwable));
        ServletHelper.writeJsonToResponse(httpServletResponse, map, jsonConverter);
    }

    public static void writeJsonToResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException, JsonGenerationException, JsonMappingException {
        httpServletResponse.setContentType(ContentType.JSON.getMimeType());
        JsonConverter jsonConverter = ServletHelper.getBean(httpServletRequest, JsonConverter.class);
        ServletHelper.writeJsonToResponse(httpServletResponse, object, jsonConverter);
    }

    public static void writePDFContents(HttpServletResponse httpServletResponse, String string, InputStream inputStream) throws IOException {
        ServletHelper.setContentType(httpServletResponse, ContentType.PDF);
        ServletHelper.setFileName(httpServletResponse, string, true);
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)httpServletResponse.getOutputStream());
        }
        finally {
            IOHelper.close((Closeable)inputStream);
            httpServletResponse.flushBuffer();
        }
    }

    public static void writeResponse(HttpServletResponse httpServletResponse, ResponseInfo responseInfo) throws IOException, ServletException {
        List list;
        SerializableInputStream serializableInputStream;
        httpServletResponse.setStatus(responseInfo.getStatus());
        ParameterStorage parameterStorage = responseInfo.getHeaders();
        if (responseInfo.getStringBody() != null) {
            serializableInputStream = (String)ObjectHelper.defaultValue((Object)parameterStorage.getString("Content-Encoding"), (Object)StandardCharsets.UTF_8.name());
            httpServletResponse.setCharacterEncoding((String)serializableInputStream);
            String string = (String)ObjectHelper.defaultValue((Object)parameterStorage.getString("Content-Type"), (Object)ContentType.TEXT.getMimeType());
            httpServletResponse.setContentType(string);
        } else if (responseInfo.getBinaryBody() != null) {
            serializableInputStream = (String)ObjectHelper.defaultValue((Object)parameterStorage.getString("Content-Type"), (Object)ContentType.BIN.getMimeType());
            httpServletResponse.setContentType((String)serializableInputStream);
        }
        for (String string : CollectionHelper.iterable((Iterator)parameterStorage.getNames())) {
            list = parameterStorage.getStringList(string);
            if (CollectionHelper.isEmpty((Iterable)list) || Arrays.asList("Content-Type", "Content-Encoding").contains(string)) continue;
            for (String string2 : list) {
                httpServletResponse.addHeader(string, string2);
            }
        }
        for (String string : CollectionHelper.orEmpty((List)responseInfo.getCookies())) {
            list = new javax.servlet.http.Cookie(string.getName(), string.getValue());
            if (StringHelper.isNotBlank((Object)string.getComment())) {
                list.setComment(string.getComment());
            }
            if (StringHelper.isNotBlank((Object)string.getDomain())) {
                list.setDomain(string.getDomain());
            }
            list.setHttpOnly(string.isHttpOnly());
            list.setMaxAge(string.getMaxAge());
            if (StringHelper.isNotBlank((Object)string.getPath())) {
                list.setPath(string.getPath());
            }
            list.setSecure(string.isSecure());
            if (string.getVersion() > 0) {
                list.setVersion(string.getVersion());
            }
            httpServletResponse.addCookie((javax.servlet.http.Cookie)list);
        }
        if (responseInfo.getBinaryBody() != null) {
            serializableInputStream = responseInfo.getBinaryBody();
            try {
                IOUtils.copy((InputStream)serializableInputStream, (OutputStream)httpServletResponse.getOutputStream());
            }
            finally {
                if (serializableInputStream != null) {
                    serializableInputStream.close();
                }
            }
        } else if (responseInfo.getStringBody() != null) {
            httpServletResponse.getWriter().append(responseInfo.getStringBody());
        }
        httpServletResponse.flushBuffer();
    }

    public static void writeText(HttpServletResponse httpServletResponse, ContentType contentType, CharSequence charSequence) throws IOException {
        if (contentType.isBinary()) {
            throw new IllegalArgumentException("Only textual content types are supported");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType(contentType.getMimeType());
        httpServletResponse.setCharacterEncoding("UTF-8");
        printWriter.print(charSequence);
        httpServletResponse.flushBuffer();
    }

    public static void writeUploadSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, null);
    }

    public static void writeUploadSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, ?> map) throws IOException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("success", true);
        if (map != null) {
            hashMap.putAll(map);
        }
        ServletHelper.writeJsonToResponse(httpServletRequest, httpServletResponse, hashMap);
    }

    public static void writeUploadSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Object object) throws IOException {
        ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, Collections.singletonMap(string, object));
    }

    private static String getAccessClientToken(HttpServletRequest httpServletRequest) {
        return (String)ObjectHelper.coalesce((Object[])new String[]{StringHelper.trimToNull((Object)httpServletRequest.getHeader("Access-Client-Token")), StringHelper.trimToNull((Object)httpServletRequest.getParameter("Access-Client-Token")), StringHelper.trimToNull((Object)httpServletRequest.getParameter(StringHelper.camelize((String)"Access-Client-Token")))});
    }

    private static <T> T getBean(HttpServletRequest httpServletRequest, Class<T> clazz) {
        return (T)WebApplicationContextUtils.findWebApplicationContext((ServletContext)httpServletRequest.getServletContext()).getBean(clazz);
    }

    private static boolean isWebRpc(RequestData requestData) {
        if (requestData == null) {
            return false;
        }
        String string = StringUtils.removeStart((String)requestData.getUri(), (String)"/");
        return string.startsWith("web-rpc/") || string.startsWith("run/") || string.startsWith("activate-access-client") || string.startsWith("api/");
    }

    private static void writeJsonToResponse(HttpServletResponse httpServletResponse, Object object, JsonConverter jsonConverter) throws IOException, JsonGenerationException, JsonMappingException {
        httpServletResponse.setContentType(ContentType.JSON.getMimeType());
        httpServletResponse.setCharacterEncoding("UTF-8");
        jsonConverter.writeValue((Writer)httpServletResponse.getWriter(), object);
        httpServletResponse.flushBuffer();
    }
}

