/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.server.utils.IOHelper;

public class GzipResponseStream
extends ServletOutputStream {
    private final HttpServletResponse response;
    private final ServletOutputStream output;
    private byte[] buffer;
    private int totalBytes;
    private byte[] singleBuffer;
    private GZIPOutputStream gzipStream;

    public GzipResponseStream(HttpServletResponse httpServletResponse, byte[] byArray) throws IOException {
        this.response = httpServletResponse;
        this.buffer = byArray;
        this.output = httpServletResponse.getOutputStream();
    }

    public void close() throws IOException {
        if (this.buffer != null && this.totalBytes > 0) {
            this.output.write(this.buffer, 0, this.totalBytes);
            this.buffer = null;
        }
        IOHelper.close((Closeable[])new Closeable[]{this.gzipStream, this.output});
    }

    public void flush() throws IOException {
        if (this.gzipStream != null) {
            this.gzipStream.flush();
        }
    }

    public boolean isReady() {
        return this.output.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.output.setWriteListener(writeListener);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer != null && this.totalBytes + n2 <= this.buffer.length) {
            System.arraycopy(byArray, n, this.buffer, this.totalBytes, n2);
            this.totalBytes += n2;
        } else {
            this.useGzip();
            this.gzipStream.write(byArray, n, n2);
        }
    }

    public void write(int n) throws IOException {
        if (this.singleBuffer == null) {
            this.singleBuffer = new byte[]{(byte)n};
        } else {
            this.singleBuffer[0] = (byte)n;
        }
        this.write(this.singleBuffer, 0, 1);
    }

    private void useGzip() throws IOException {
        if (this.gzipStream == null) {
            this.response.addHeader("Content-Encoding", "gzip");
            this.gzipStream = new GZIPOutputStream((OutputStream)this.output, 8192);
        }
        if (this.buffer != null && this.totalBytes > 0) {
            this.gzipStream.write(this.buffer, 0, this.totalBytes);
        }
        this.buffer = null;
    }
}

