/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.root;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.server.utils.ServiceMetadata;
import org.cyclos.server.utils.ServiceMetadataHelper;
import org.cyclos.web.root.RequestServiceFactory;
import org.cyclos.web.root.RequestServiceFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.stereotype.Component;

@Component
public class ServiceRegistrationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private Logger LOG = LogManager.getLogger(ServiceRegistrationBeanFactoryPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)configurableListableBeanFactory;
        List list = ServiceMetadataHelper.get();
        for (ServiceMetadata serviceMetadata : list) {
            RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(RequestServiceFactoryBean.class);
            rootBeanDefinition.getPropertyValues().addPropertyValue("serviceInterface", (Object)serviceMetadata.getServiceInterface());
            rootBeanDefinition.getPropertyValues().addPropertyValue("requestServiceFactory", (Object)new RuntimeBeanReference(RequestServiceFactory.class));
            rootBeanDefinition.setPrimary(true);
            rootBeanDefinition.setLazyInit(true);
            beanDefinitionRegistry.registerBeanDefinition(serviceMetadata.getBeanName(), (BeanDefinition)rootBeanDefinition);
            this.LOG.debug("Automatically registering service {}", (Object)serviceMetadata.getBeanName());
        }
    }
}

