/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.TranslatableUIElementResultVO;
import org.cyclos.model.access.BasicInitializationData;
import org.cyclos.model.contentmanagement.BaseGetVersionedDataParams;
import org.cyclos.model.contentmanagement.GetVersionedDataParams;
import org.cyclos.model.contentmanagement.ThemeResultVO;
import org.cyclos.model.contentmanagement.UIElementResultVO;
import org.cyclos.model.contentmanagement.themes.ThemeType;
import org.cyclos.model.system.licensing.BasicLicenseVO;
import org.cyclos.model.utils.DimensionsDTO;
import org.cyclos.model.utils.DistanceUnit;
import org.cyclos.model.utils.FileSizeDTO;
import org.cyclos.model.utils.LocalesData;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.contentmanagement.UiData;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.UiApi;
import org.cyclos.web.rest.helpers.AddressesApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.DevicesApiHelper;
import org.cyclos.web.rest.helpers.LocalizationApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.WizardsApiHelper;
import org.cyclos.web.rest.model.DataForUi;
import org.cyclos.web.rest.model.DistanceUnitEnum;
import org.cyclos.web.rest.model.Language;
import org.cyclos.web.rest.model.MapData;
import org.cyclos.web.rest.model.ThemeUIElement;
import org.cyclos.web.rest.model.TranslatableUIElementWithContent;
import org.cyclos.web.rest.model.UIElementWithContent;
import org.cyclos.web.rest.model.UiKind;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UiApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private DevicesApiHelper devicesApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private AddressesApiHelper addressesApiHelper;
    @Autowired
    private LocalizationApiHelper localizationApiHelper;
    @Autowired
    private WizardsApiHelper wizardsApiHelper;

    public void fill(DataForUi dataForUi, BasicInitializationData basicInitializationData) {
        dataForUi.setApplicationName(basicInitializationData.getApplicationName());
        dataForUi.setApplicationUsername(basicInitializationData.getApplicationUsername());
        dataForUi.setCyclosVersion(basicInitializationData.getApplicationVersion());
        dataForUi.setCyclosRevision(basicInitializationData.getApplicationCommitId());
        BasicLicenseVO basicLicenseVO = basicInitializationData.getLicense();
        if (basicLicenseVO != null) {
            dataForUi.setLicenseKey(basicLicenseVO.getLicenseKey());
            dataForUi.setLicensee(basicLicenseVO.getOrganizationName());
        }
        dataForUi.setCountry(basicInitializationData.getCountry());
        dataForUi.setCurrentClientTime(basicInitializationData.getCurrentClientTime());
        dataForUi.setDateFormat(basicInitializationData.getDateFormat().getPattern());
        dataForUi.setDecimalSeparator(String.valueOf(basicInitializationData.getNumberFormat().getDecimalSeparator()));
        dataForUi.setGroupingSeparator(String.valueOf(basicInitializationData.getNumberFormat().getGroupingSeparator()));
        dataForUi.setLanguage(this.toLanguage(basicInitializationData));
        dataForUi.setResourceCacheKey(basicInitializationData.getResourceCacheKey());
        dataForUi.setTimeFormat(basicInitializationData.getTimeFormat().getPattern());
        dataForUi.setTimeZoneId(basicInitializationData.getTimeZoneId());
        dataForUi.setRootUrl(basicInitializationData.getRootUrl());
        dataForUi.setApiUrl(basicInitializationData.getApiUrl());
        DimensionsDTO dimensionsDTO = basicInitializationData.getMaxImageDimensions();
        if (dimensionsDTO != null) {
            dataForUi.setMaxImageWidth(dimensionsDTO.getWidth());
            dataForUi.setMaxImageHeight(dimensionsDTO.getHeight());
        }
        dataForUi.setJpegQuality(basicInitializationData.getJpegQuality());
        FileSizeDTO fileSizeDTO = basicInitializationData.getMaxUploadSize();
        if (ModelHelper.isValid((FileSizeDTO)fileSizeDTO)) {
            dataForUi.setMaxUploadSize(fileSizeDTO.getUnit().getBytes() * fileSizeDTO.getSize());
        }
        if (basicInitializationData.isUseMap()) {
            MapData mapData = new MapData();
            mapData.setGoogleMapsApiKey(basicInitializationData.getMapBrowserApiKey());
            mapData.setDefaultLocation(this.addressesApiHelper.toGeographicalCoordinate(basicInitializationData.getDefaultMapLocation()));
            mapData.setDefaultZoom(basicInitializationData.getDefaultMapZoomWeb());
            mapData.setDefaultZoomMobile(basicInitializationData.getDefaultMapZoomMobile());
            mapData.setDistanceUnit(this.toDistanceUnitEnum(basicInitializationData.getDistanceUnit()));
            dataForUi.setMapData(mapData);
        }
    }

    public <P extends BaseGetVersionedDataParams> P newGetVersionedDataParams(Class<P> clazz, String string, String string2, String string3) {
        BaseGetVersionedDataParams baseGetVersionedDataParams = (BaseGetVersionedDataParams)ClassHelper.instantiate(clazz);
        baseGetVersionedDataParams.setCyclosVersion(string);
        baseGetVersionedDataParams.setTheme(this.apiHelper.toVersionedVO(string2));
        baseGetVersionedDataParams.setLanguage(this.apiHelper.toVersionedVO(string3));
        return (P)baseGetVersionedDataParams;
    }

    public GetVersionedDataParams newGetVersionedDataParams(UiApi.DataForUiParams dataForUiParams) {
        return this.newGetVersionedDataParams(dataForUiParams.cyclosVersion, dataForUiParams.headerIf, dataForUiParams.footerIf, null, dataForUiParams.themeIf, null);
    }

    public GetVersionedDataParams newGetVersionedDataParams(String string, String string2, String string3, String string4, String string5, String string6) {
        GetVersionedDataParams getVersionedDataParams = this.newGetVersionedDataParams(GetVersionedDataParams.class, string, string5, string6);
        getVersionedDataParams.setHeader(this.apiHelper.toTranslatableVersionedVO(string2));
        getVersionedDataParams.setFooter(this.apiHelper.toTranslatableVersionedVO(string3));
        getVersionedDataParams.setWelcomePage(this.apiHelper.toTranslatableVersionedVO(string4));
        return getVersionedDataParams;
    }

    public DataForUi toDataForUi(UiData uiData) {
        DataForUi dataForUi = new DataForUi();
        this.fill(dataForUi, uiData.getBasicInitializationData());
        dataForUi.setMaxTransactionAmountIntegers(15);
        dataForUi.setMaxTransferAmountIntegers(18);
        LocalesData localesData = uiData.getLocalesData();
        dataForUi.setDefaultLocale(this.localizationApiHelper.toUserLocale(localesData.getDefaultLocale()));
        dataForUi.setCurrentLocale(this.localizationApiHelper.toUserLocale(localesData.getCurrentLocale()));
        localesData.getAllowedLocales().stream().map(this.localizationApiHelper::toUserLocale).forEach(dataForUi.getAllowedLocales()::add);
        dataForUi.setHideUserSearchInMenu(uiData.isHideUserSearchInMenu());
        dataForUi.setDataForLogin(this.authApiHelper.toDataForLogin(uiData.getLoginData()));
        CollectionHelper.orEmpty((List)uiData.getPublicRegistrationGroups()).stream().map(this.usersApiHelper::toGroupForRegistration).forEach(dataForUi.getPublicRegistrationGroups()::add);
        dataForUi.setLargeScreenRegistrationWizard(this.wizardsApiHelper.toWizard(uiData.getLargeScreenRegistrationWizard()));
        dataForUi.setMediumScreenRegistrationWizard(this.wizardsApiHelper.toWizard(uiData.getMediumScreenRegistrationWizard()));
        dataForUi.setSmallScreenRegistrationWizard(this.wizardsApiHelper.toWizard(uiData.getSmallScreenRegistrationWizard()));
        dataForUi.setAuth(this.authApiHelper.toAuth(uiData.getAuth()));
        dataForUi.setFooter(this.toTranslatableUIElementWithContent(uiData.getFooter()));
        dataForUi.setHeader(this.toTranslatableUIElementWithContent(uiData.getHeader()));
        dataForUi.setTheme(this.toThemeUIElement(uiData.getTheme()));
        dataForUi.setAppleStoreUrl(uiData.getAppleStoreUrlMobile());
        dataForUi.setPlayStoreUrl(uiData.getPlayStoreUrlMobile());
        dataForUi.setDeviceActivationMode(this.devicesApiHelper.toDeviceActivationModeEnum(uiData.getDeviceActivationMode()));
        dataForUi.setShoppingCartWebShopCount(uiData.getShoppingCartWebShopCount());
        return dataForUi;
    }

    public DistanceUnitEnum toDistanceUnitEnum(DistanceUnit distanceUnit) {
        if (distanceUnit != null) {
            switch (distanceUnit) {
                case KILOMETER: {
                    return DistanceUnitEnum.KILOMETER;
                }
                case MILE: {
                    return DistanceUnitEnum.MILE;
                }
            }
        }
        return null;
    }

    public ThemeType toThemeType(UiKind uiKind) {
        if (uiKind == null) {
            return null;
        }
        switch (uiKind) {
            case MAIN: {
                return ThemeType.MAIN_WEB;
            }
            case MOBILE: {
                return ThemeType.MOBILE;
            }
            case PAY: {
                return ThemeType.PAY;
            }
            case CUSTOM: {
                return null;
            }
        }
        return null;
    }

    public ThemeUIElement toThemeUIElement(ThemeResultVO themeResultVO) {
        if (themeResultVO == null) {
            return null;
        }
        ThemeUIElement themeUIElement = this.toUIElementWithContent(ThemeUIElement.class, (UIElementResultVO)themeResultVO);
        themeUIElement.setDefinitions(themeResultVO.getDefinitions());
        themeUIElement.setAdvancedDefinitions(themeResultVO.getAdvancedDefinitions());
        themeUIElement.setCustomStyle(themeResultVO.getCustomStyle());
        return themeUIElement;
    }

    public TranslatableUIElementWithContent toTranslatableUIElementWithContent(TranslatableUIElementResultVO translatableUIElementResultVO) {
        if (translatableUIElementResultVO == null) {
            return null;
        }
        TranslatableUIElementWithContent translatableUIElementWithContent = new TranslatableUIElementWithContent();
        translatableUIElementWithContent.setId(ApiHelper.toId(translatableUIElementResultVO.getId()));
        translatableUIElementWithContent.setVersion(translatableUIElementResultVO.getVersion());
        translatableUIElementWithContent.setContent(translatableUIElementResultVO.getContent());
        translatableUIElementWithContent.setContentHash(translatableUIElementResultVO.getContentHash());
        translatableUIElementWithContent.setDataTranslationId(ApiHelper.toId(translatableUIElementResultVO.getDataTranslationId()));
        translatableUIElementWithContent.setDataTranslationVersion(translatableUIElementResultVO.getDataTranslationVersion());
        return translatableUIElementWithContent;
    }

    private Language toLanguage(BasicInitializationData basicInitializationData) {
        Language language = new Language();
        language.setId(ApiHelper.toId(basicInitializationData.getLanguageId()));
        language.setVersion(basicInitializationData.getLanguageVersion());
        language.setCode(basicInitializationData.getLanguage());
        return language;
    }

    private <T extends UIElementWithContent> T toUIElementWithContent(Class<T> clazz, UIElementResultVO uIElementResultVO) {
        if (uIElementResultVO == null) {
            return null;
        }
        UIElementWithContent uIElementWithContent = (UIElementWithContent)ClassHelper.instantiate(clazz);
        uIElementWithContent.setId(ApiHelper.toId(uIElementResultVO.getId()));
        uIElementWithContent.setVersion(uIElementResultVO.getVersion());
        uIElementWithContent.setContent(uIElementResultVO.getContent());
        return (T)uIElementWithContent;
    }
}

