/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewData;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoryOverviewEntryVO;
import org.cyclos.model.banking.accounts.BaseTransferQuery;
import org.cyclos.model.banking.accounts.ITransSearchData;
import org.cyclos.model.banking.accounts.TransferDirection;
import org.cyclos.model.banking.accounts.TransferSearchData;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.TransVO;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transfers.AccountFeeTransferVO;
import org.cyclos.model.banking.transfers.ChargebackTransferVO;
import org.cyclos.model.banking.transfers.InstallmentTransferVO;
import org.cyclos.model.banking.transfers.TransferData;
import org.cyclos.model.banking.transfers.TransferDetailedVO;
import org.cyclos.model.banking.transfers.TransferFeeTransferVO;
import org.cyclos.model.banking.transfers.TransferNature;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowVO;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowWithStatusesVO;
import org.cyclos.model.banking.transferstatus.TransferStatusLogVO;
import org.cyclos.model.banking.transferstatus.TransferStatusVO;
import org.cyclos.model.banking.transferstatus.TransferStatusWithFlowVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.InstallmentsApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.AccountType;
import org.cyclos.web.rest.model.BaseTransferDataForSearch;
import org.cyclos.web.rest.model.BaseTransferQueryFilters;
import org.cyclos.web.rest.model.Currency;
import org.cyclos.web.rest.model.TransactionView;
import org.cyclos.web.rest.model.Transfer;
import org.cyclos.web.rest.model.TransferDataForSearch;
import org.cyclos.web.rest.model.TransferDetailed;
import org.cyclos.web.rest.model.TransferDirectionEnum;
import org.cyclos.web.rest.model.TransferKind;
import org.cyclos.web.rest.model.TransferQueryFilters;
import org.cyclos.web.rest.model.TransferResult;
import org.cyclos.web.rest.model.TransferStatus;
import org.cyclos.web.rest.model.TransferStatusFlow;
import org.cyclos.web.rest.model.TransferStatusFlowForTransferView;
import org.cyclos.web.rest.model.TransferStatusLog;
import org.cyclos.web.rest.model.TransferView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransfersApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private InstallmentsApiHelper installmentsApiHelper;

    public AccountHistoriesOverviewQuery toAccountHistoriesOverviewQuery(TransferQueryFilters transferQueryFilters) {
        AccountHistoriesOverviewQuery accountHistoriesOverviewQuery = this.newBaseTransferQuery(AccountHistoriesOverviewQuery.class, transferQueryFilters);
        accountHistoriesOverviewQuery.setCurrencies(CollectionHelper.orEmpty(transferQueryFilters.getCurrencies()).stream().map(string -> (CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)string)).collect(Collectors.toSet()));
        accountHistoriesOverviewQuery.setFromAccounts(CollectionHelper.orEmpty(transferQueryFilters.getFromAccountTypes()).stream().map(string -> (AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)string)).collect(Collectors.toSet()));
        accountHistoriesOverviewQuery.setToAccounts(CollectionHelper.orEmpty(transferQueryFilters.getToAccountTypes()).stream().map(string -> (AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)string)).collect(Collectors.toSet()));
        return accountHistoriesOverviewQuery;
    }

    public Transfer toTransfer(TransferVO transferVO) {
        if (transferVO == null) {
            return null;
        }
        return this.newTransfer(Transfer.class, transferVO);
    }

    public TransferDataForSearch toTransferDataForSearch(AccountHistoriesOverviewData accountHistoriesOverviewData) {
        TransferDataForSearch transferDataForSearch = this.newBaseTransferSearchData(TransferDataForSearch.class, (TransferSearchData)accountHistoriesOverviewData);
        CollectionHelper.orEmpty((List)accountHistoriesOverviewData.getAccountTypes()).stream().map(this.accountsApiHelper::toAccountType).forEach(transferDataForSearch.getAccountTypes()::add);
        Set set = transferDataForSearch.getAccountTypes().stream().map(AccountType::getCurrency).collect(Collectors.toSet());
        transferDataForSearch.setCurrencies(CollectionHelper.sort(set, Comparator.comparing(Currency::getName)));
        if (accountHistoriesOverviewData.getQuery() instanceof AccountHistoriesOverviewQuery) {
            transferDataForSearch.setQuery(this.toTransferQueryFilters((AccountHistoriesOverviewQuery)accountHistoriesOverviewData.getQuery()));
        }
        return transferDataForSearch;
    }

    public TransferDetailed toTransferDetailed(TransferDetailedVO transferDetailedVO) {
        if (transferDetailedVO == null) {
            return null;
        }
        return this.newTransferDetailed(TransferDetailed.class, transferDetailedVO);
    }

    public TransferDirection toTransferDirection(TransferDirectionEnum transferDirectionEnum) {
        if (transferDirectionEnum != null) {
            switch (transferDirectionEnum) {
                case CREDIT: {
                    return TransferDirection.CREDIT;
                }
                case DEBIT: {
                    return TransferDirection.DEBIT;
                }
            }
        }
        return null;
    }

    public TransferDirectionEnum toTransferDirectionEnum(TransferDirection transferDirection) {
        if (transferDirection != null) {
            switch (transferDirection) {
                case CREDIT: {
                    return TransferDirectionEnum.CREDIT;
                }
                case DEBIT: {
                    return TransferDirectionEnum.DEBIT;
                }
            }
        }
        return null;
    }

    public TransferKind toTransferKind(TransferNature transferNature) {
        if (transferNature != null) {
            switch (transferNature) {
                case ACCOUNT_FEE: {
                    return TransferKind.ACCOUNT_FEE;
                }
                case CHARGEBACK: {
                    return TransferKind.CHARGEBACK;
                }
                case IMPORT: {
                    return TransferKind.IMPORT;
                }
                case INITIAL_CREDIT: {
                    return TransferKind.INITIAL_CREDIT;
                }
                case BALANCE_DISPOSAL: {
                    return TransferKind.BALANCE_DISPOSAL;
                }
                case INSTALLMENT: {
                    return TransferKind.INSTALLMENT;
                }
                case PAYMENT: {
                    return TransferKind.PAYMENT;
                }
                case TRANSFER_FEE: {
                    return TransferKind.TRANSFER_FEE;
                }
            }
        }
        return null;
    }

    public TransferNature toTransferNature(TransferKind transferKind) {
        if (transferKind != null) {
            switch (transferKind) {
                case ACCOUNT_FEE: {
                    return TransferNature.ACCOUNT_FEE;
                }
                case CHARGEBACK: {
                    return TransferNature.CHARGEBACK;
                }
                case IMPORT: {
                    return TransferNature.IMPORT;
                }
                case INITIAL_CREDIT: {
                    return TransferNature.INITIAL_CREDIT;
                }
                case BALANCE_DISPOSAL: {
                    return TransferNature.BALANCE_DISPOSAL;
                }
                case INSTALLMENT: {
                    return TransferNature.INSTALLMENT;
                }
                case PAYMENT: {
                    return TransferNature.PAYMENT;
                }
                case TRANSFER_FEE: {
                    return TransferNature.TRANSFER_FEE;
                }
            }
        }
        return null;
    }

    public TransferQueryFilters toTransferQueryFilters(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        TransferQueryFilters transferQueryFilters = this.newBaseTransferQueryFilters(TransferQueryFilters.class, (BaseTransferQuery)accountHistoriesOverviewQuery);
        CollectionHelper.orEmpty((Set)accountHistoriesOverviewQuery.getCurrencies()).stream().map(ModelHelper::stringOrIdFromVO).forEach(transferQueryFilters.getCurrencies()::add);
        CollectionHelper.orEmpty((Set)accountHistoriesOverviewQuery.getFromAccounts()).stream().map(ModelHelper::stringOrIdFromVO).forEach(transferQueryFilters.getFromAccountTypes()::add);
        CollectionHelper.orEmpty((Set)accountHistoriesOverviewQuery.getToAccounts()).stream().map(ModelHelper::stringOrIdFromVO).forEach(transferQueryFilters.getToAccountTypes()::add);
        return transferQueryFilters;
    }

    public TransferResult toTransferResult(AccountHistoryOverviewEntryVO accountHistoryOverviewEntryVO) {
        if (accountHistoryOverviewEntryVO == null) {
            return null;
        }
        TransferResult transferResult = this.newTransfer(TransferResult.class, (TransferVO)accountHistoryOverviewEntryVO);
        transferResult.setFromName(accountHistoryOverviewEntryVO.getFromName());
        transferResult.setToName(accountHistoryOverviewEntryVO.getToName());
        transferResult.setCustomValues(this.apiHelper.toCustomFieldValuesMap(accountHistoryOverviewEntryVO.getCustomValues()));
        return transferResult;
    }

    public TransferStatus toTransferStatus(TransferStatusWithFlowVO transferStatusWithFlowVO) {
        if (transferStatusWithFlowVO == null) {
            return null;
        }
        TransferStatus transferStatus = this.apiHelper.newEntity(TransferStatus.class, transferStatusWithFlowVO, true);
        transferStatus.setFlow(this.apiHelper.toReference((EntityModel)transferStatusWithFlowVO.getFlow()));
        return transferStatus;
    }

    public TransferStatusFlow toTransferStatusFlow(TransferStatusFlowWithStatusesVO transferStatusFlowWithStatusesVO) {
        if (transferStatusFlowWithStatusesVO == null) {
            return null;
        }
        TransferStatusFlow transferStatusFlow = this.apiHelper.newEntity(TransferStatusFlow.class, transferStatusFlowWithStatusesVO);
        CollectionHelper.orEmpty((List)transferStatusFlowWithStatusesVO.getStatuses()).stream().map(transferStatusVO -> this.apiHelper.toReference((EntityModel)transferStatusVO, true)).forEach(transferStatusFlow.getStatuses()::add);
        return transferStatusFlow;
    }

    public TransferView toTransferView(TransferData transferData) {
        if (transferData == null) {
            return null;
        }
        TransferDetailedVO transferDetailedVO = transferData.getTransfer();
        TransferView transferView = this.newTransferDetailed(TransferView.class, transferDetailedVO);
        TransactionData transactionData = transferData.getTransactionData();
        if (transactionData != null) {
            TransactionView transactionView = this.transactionsApiHelper.toTransactionView(transactionData);
            transferView.setTransaction(transactionView);
            transferView.setUsersWhichCanAddToContacts(this.transactionsApiHelper.toTransactionSubjectsEnum(transactionData.getUsersWhichCanAddToContacts()));
            transferView.setUsersWhichCanViewProfile(this.transactionsApiHelper.toTransactionSubjectsEnum(transactionData.getUsersWhichCanViewProfile()));
        }
        CollectionHelper.orEmpty((List)transferDetailedVO.getStatuses()).stream().map(transferStatusWithFlowVO -> this.toTransferStatusFlowForView((TransferStatusWithFlowVO)transferStatusWithFlowVO, transferData)).forEach(transferView.getStatusFlows()::add);
        CollectionHelper.orEmpty((List)transferData.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(transferView.getOperations()::add);
        transferView.setCanChargeback(transferData.isCanChargeback());
        transferView.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)transferData.getConfirmationPasswordInput()));
        CollectionHelper.orEmpty((List)transferData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(transferView.getExportFormats()::add);
        return transferView;
    }

    private <T extends Transfer> T newTransfer(Class<T> clazz, TransferVO transferVO) {
        Transfer transfer = (Transfer)this.transactionsApiHelper.newTrans(clazz, (TransVO)transferVO);
        transfer.setKind(this.toTransferKind(transferVO.getNature()));
        CollectionHelper.orEmpty((List)transferVO.getStatuses()).stream().map(this::toTransferStatus).forEach(transfer.getStatuses()::add);
        return (T)transfer;
    }

    private <T extends TransferDetailed> T newTransferDetailed(Class<T> clazz, TransferDetailedVO transferDetailedVO) {
        TransferDetailed transferDetailed = (TransferDetailed)this.newTransfer(clazz, (TransferVO)transferDetailedVO);
        if (transferDetailedVO.getParent() != null) {
            transferDetailed.setParent(this.toTransferDetailed(transferDetailedVO.getParent()));
        }
        if (CollectionHelper.isEmpty((Iterable)transferDetailedVO.getChildren())) {
            transferDetailed.setChildren(null);
        } else {
            transferDetailedVO.getChildren().stream().map(this::toTransferDetailed).forEach(transferDetailed.getChildren()::add);
        }
        transferDetailed.setChargedBackBy(this.toTransfer(transferDetailedVO.getChargedBackBy()));
        transferDetailed.setDescription(transferDetailedVO.getDescription());
        transferDetailed.setArate(transferDetailedVO.getARate());
        transferDetailed.setDrate(transferDetailedVO.getDRate());
        if (transferDetailedVO instanceof ChargebackTransferVO) {
            ChargebackTransferVO chargebackTransferVO = (ChargebackTransferVO)transferDetailedVO;
            transferDetailed.setChargebackOf(this.toTransfer(chargebackTransferVO.getChargebackOf()));
        } else if (transferDetailedVO instanceof InstallmentTransferVO) {
            InstallmentTransferVO installmentTransferVO = (InstallmentTransferVO)transferDetailedVO;
            transferDetailed.setInstallment(this.installmentsApiHelper.toInstallment(installmentTransferVO.getInstallment()));
        } else if (transferDetailedVO instanceof AccountFeeTransferVO) {
            AccountFeeTransferVO accountFeeTransferVO = (AccountFeeTransferVO)transferDetailedVO;
            transferDetailed.setAccountFee(this.apiHelper.toReference((EntityModel)accountFeeTransferVO.getAccountFee()));
        } else if (transferDetailedVO instanceof TransferFeeTransferVO) {
            TransferFeeTransferVO transferFeeTransferVO = (TransferFeeTransferVO)transferDetailedVO;
            transferDetailed.setTransferFee(this.apiHelper.toReference((EntityModel)transferFeeTransferVO.getTransferFee()));
        }
        return (T)transferDetailed;
    }

    private TransferStatusFlowForTransferView toTransferStatusFlowForView(TransferStatusWithFlowVO transferStatusWithFlowVO, TransferData transferData) {
        TransferStatusFlowVO transferStatusFlowVO = transferStatusWithFlowVO.getFlow();
        TransferStatusFlowForTransferView transferStatusFlowForTransferView = this.apiHelper.newEntity(TransferStatusFlowForTransferView.class, transferStatusWithFlowVO, true);
        transferStatusFlowForTransferView.setCanManage(CollectionHelper.orEmpty((List)transferData.getManagedStatusFlows()).contains(transferStatusFlowVO));
        transferData.getStatusLog().stream().filter(transferFlowStatusLogVO -> transferStatusFlowVO.equals((Object)transferFlowStatusLogVO.getFlow())).forEach(transferFlowStatusLogVO -> transferFlowStatusLogVO.getLog().stream().map(this::toTransferStatusLog).forEach(transferStatusFlowForTransferView.getLog()::add));
        return transferStatusFlowForTransferView;
    }

    private TransferStatusLog toTransferStatusLog(TransferStatusLogVO transferStatusLogVO) {
        TransferStatusLog transferStatusLog = this.apiHelper.newEntity(TransferStatusLog.class, transferStatusLogVO);
        transferStatusLog.setStatus(this.apiHelper.toReference((EntityModel)transferStatusLogVO.getStatus(), true));
        transferStatusLog.setDate(transferStatusLogVO.getDate());
        transferStatusLog.setBy(this.usersApiHelper.toUser((BasicUserVO)transferStatusLogVO.getBy()));
        transferStatusLog.setComments(transferStatusLogVO.getComments());
        return transferStatusLog;
    }

    <Q extends BaseTransferQuery> Q newBaseTransferQuery(Class<Q> clazz, BaseTransferQueryFilters baseTransferQueryFilters) {
        BaseTransferQuery baseTransferQuery = (BaseTransferQuery)this.transactionsApiHelper.newAbstractTransQuery(clazz, baseTransferQueryFilters);
        baseTransferQuery.setChargedBack(baseTransferQueryFilters.getChargedBack());
        baseTransferQuery.setNatures(CollectionHelper.orEmpty(baseTransferQueryFilters.getKinds()).stream().map(this::toTransferNature).collect(Collectors.toSet()));
        baseTransferQuery.setStatuses(CollectionHelper.orEmpty(baseTransferQueryFilters.getStatuses()).stream().map(string -> (TransferStatusVO)ModelHelper.voFromString(TransferStatusVO.class, (String)string)).collect(Collectors.toSet()));
        return (Q)baseTransferQuery;
    }

    <F extends BaseTransferQueryFilters> F newBaseTransferQueryFilters(Class<F> clazz, BaseTransferQuery baseTransferQuery) {
        BaseTransferQueryFilters baseTransferQueryFilters = (BaseTransferQueryFilters)this.transactionsApiHelper.newBaseTransQueryFilters(clazz, (AbstractTransQuery)baseTransferQuery);
        baseTransferQueryFilters.setChargedBack(baseTransferQuery.getChargedBack());
        CollectionHelper.orEmpty((Set)baseTransferQuery.getStatuses()).stream().map(ModelHelper::stringOrIdFromVO).forEach(baseTransferQueryFilters.getStatuses()::add);
        CollectionHelper.orEmpty((Set)baseTransferQuery.getNatures()).stream().map(this::toTransferKind).forEach(baseTransferQueryFilters.getKinds()::add);
        return (F)baseTransferQueryFilters;
    }

    <D extends BaseTransferDataForSearch> D newBaseTransferSearchData(Class<D> clazz, TransferSearchData transferSearchData) {
        BaseTransferDataForSearch baseTransferDataForSearch = (BaseTransferDataForSearch)this.transactionsApiHelper.newBaseTransDataForSearch(clazz, (ITransSearchData)transferSearchData);
        CollectionHelper.orEmpty((List)transferSearchData.getTransferStatusFlows()).stream().map(this::toTransferStatusFlow).forEach(baseTransferDataForSearch.getTransferStatusFlows()::add);
        return (D)baseTransferDataForSearch;
    }
}

