/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.EntityModel;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateDTO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateData;
import org.cyclos.model.access.tokens.InitializeNFCTagData;
import org.cyclos.model.access.tokens.InitializeNFCTagResult;
import org.cyclos.model.access.tokens.NFCTagInitializeDTO;
import org.cyclos.model.access.tokens.NFCTagKey;
import org.cyclos.model.access.tokens.NFCTagPersonalizeDTO;
import org.cyclos.model.access.tokens.NFCTagWithChallengeDTO;
import org.cyclos.model.access.tokens.PersonalizeNFCTagData;
import org.cyclos.model.access.tokens.TokenActionDTO;
import org.cyclos.model.access.tokens.TokenActionWithUserDTO;
import org.cyclos.model.users.groups.UserGroupVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.model.NfcDataForInitialize;
import org.cyclos.web.rest.model.NfcDataForPersonalize;
import org.cyclos.web.rest.model.NfcExternalAuthenticateParameter;
import org.cyclos.web.rest.model.NfcExternalAuthenticateResult;
import org.cyclos.web.rest.model.NfcInitializeParameter;
import org.cyclos.web.rest.model.NfcInitializeResult;
import org.cyclos.web.rest.model.NfcPersonalizeParameter;
import org.cyclos.web.rest.model.NfcTagKeyEnum;
import org.cyclos.web.rest.model.NfcTokenParameter;
import org.cyclos.web.rest.model.NfcTokenWithChallengeParameter;
import org.cyclos.web.rest.model.NfcTokenWithUserParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NfcApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public ExternalNFCTagAuthenticateDTO toExternalNFCTagAuthenticateDTO(NfcExternalAuthenticateParameter nfcExternalAuthenticateParameter) {
        if (nfcExternalAuthenticateParameter == null) {
            return null;
        }
        ExternalNFCTagAuthenticateDTO externalNFCTagAuthenticateDTO = this.newTokenActionDTO(ExternalNFCTagAuthenticateDTO.class, nfcExternalAuthenticateParameter);
        externalNFCTagAuthenticateDTO.setKeyType((NFCTagKey)ObjectHelper.defaultValue((Object)this.toNFCTagKey(nfcExternalAuthenticateParameter.getKey()), (Object)NFCTagKey.OPERATIONAL_KEY));
        externalNFCTagAuthenticateDTO.setChallenge(nfcExternalAuthenticateParameter.getTagChallenge());
        externalNFCTagAuthenticateDTO.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)nfcExternalAuthenticateParameter.getUser()));
        externalNFCTagAuthenticateDTO.setGroup((UserGroupVO)ModelHelper.voFromString(UserGroupVO.class, (String)nfcExternalAuthenticateParameter.getGroup()));
        externalNFCTagAuthenticateDTO.setAsMember(Boolean.TRUE.equals(nfcExternalAuthenticateParameter.getAsMember()));
        return externalNFCTagAuthenticateDTO;
    }

    public NfcDataForInitialize toNfcDataForInitialize(InitializeNFCTagData initializeNFCTagData) {
        if (initializeNFCTagData == null) {
            return null;
        }
        NfcDataForInitialize nfcDataForInitialize = new NfcDataForInitialize();
        CollectionHelper.orEmpty((List)initializeNFCTagData.getInitializeTokenTypes()).stream().map(this.apiHelper::toReference).forEach(nfcDataForInitialize.getInitilizeTypes()::add);
        CollectionHelper.orEmpty((List)initializeNFCTagData.getPersonalizeTokenTypes()).stream().map(this.apiHelper::toReference).forEach(nfcDataForInitialize.getPersonalizeTypes()::add);
        return nfcDataForInitialize;
    }

    public NfcDataForPersonalize toNfcDataForPersonalize(PersonalizeNFCTagData personalizeNFCTagData) {
        NfcDataForPersonalize nfcDataForPersonalize = new NfcDataForPersonalize();
        nfcDataForPersonalize.setTokenType(this.apiHelper.toReference((EntityModel)personalizeNFCTagData.getTokenType()));
        nfcDataForPersonalize.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)personalizeNFCTagData.getConfirmationPasswordInput()));
        return nfcDataForPersonalize;
    }

    public NfcExternalAuthenticateResult toNfcExternalAuthenticateResult(ExternalNFCTagAuthenticateData externalNFCTagAuthenticateData) {
        if (externalNFCTagAuthenticateData == null) {
            return null;
        }
        NfcExternalAuthenticateResult nfcExternalAuthenticateResult = new NfcExternalAuthenticateResult();
        nfcExternalAuthenticateResult.setCyclosChallenge(externalNFCTagAuthenticateData.getCyclosChallenge());
        nfcExternalAuthenticateResult.setSessionKey(externalNFCTagAuthenticateData.getSessionKey());
        return nfcExternalAuthenticateResult;
    }

    public NfcInitializeResult toNfcInitializeResult(InitializeNFCTagResult initializeNFCTagResult) {
        if (initializeNFCTagResult == null) {
            return null;
        }
        NfcInitializeResult nfcInitializeResult = new NfcInitializeResult();
        nfcInitializeResult.setApplicationKey(initializeNFCTagResult.getApplicationMasterKey());
        nfcInitializeResult.setOperationalKey(initializeNFCTagResult.getOperationalKey());
        nfcInitializeResult.setTagKey(initializeNFCTagResult.getPiccMasterKey());
        nfcInitializeResult.setTokenLabel(initializeNFCTagResult.getTokenLabel());
        return nfcInitializeResult;
    }

    public NFCTagInitializeDTO toNFCTagInitializeDTO(NfcInitializeParameter nfcInitializeParameter) {
        if (nfcInitializeParameter == null) {
            return null;
        }
        NFCTagInitializeDTO nFCTagInitializeDTO = this.newTokenActionWithUserDTO(NFCTagInitializeDTO.class, nfcInitializeParameter);
        nFCTagInitializeDTO.setLabel(nfcInitializeParameter.getLabel());
        return nFCTagInitializeDTO;
    }

    public NFCTagKey toNFCTagKey(NfcTagKeyEnum nfcTagKeyEnum) {
        if (nfcTagKeyEnum != null) {
            switch (nfcTagKeyEnum) {
                case PICC_MASTER: {
                    return NFCTagKey.PICC_MASTER_KEY;
                }
                case APP_MASTER: {
                    return NFCTagKey.APP_MASTER_KEY;
                }
                case OPERATIONAL: {
                    return NFCTagKey.OPERATIONAL_KEY;
                }
            }
        }
        return null;
    }

    public NFCTagPersonalizeDTO toNFCTagPersonalizeDTO(NfcPersonalizeParameter nfcPersonalizeParameter, String string) {
        NFCTagPersonalizeDTO nFCTagPersonalizeDTO = this.newTokenActionWithUserDTO(NFCTagPersonalizeDTO.class, nfcPersonalizeParameter);
        nFCTagPersonalizeDTO.setCyclosChallenge(nfcPersonalizeParameter.getCyclosChallenge());
        nFCTagPersonalizeDTO.setConfirmationPassword(string);
        return nFCTagPersonalizeDTO;
    }

    public NFCTagWithChallengeDTO toNFCTagWithChallengeDTO(NfcTokenWithChallengeParameter nfcTokenWithChallengeParameter) {
        if (nfcTokenWithChallengeParameter == null) {
            return null;
        }
        NFCTagWithChallengeDTO nFCTagWithChallengeDTO = this.newTokenActionDTO(NFCTagWithChallengeDTO.class, nfcTokenWithChallengeParameter);
        nFCTagWithChallengeDTO.setChallenge(nfcTokenWithChallengeParameter.getCyclosChallenge());
        return nFCTagWithChallengeDTO;
    }

    public TokenActionDTO toTokenActionDTO(NfcTokenParameter nfcTokenParameter) {
        if (nfcTokenParameter == null) {
            return null;
        }
        return this.newTokenActionDTO(TokenActionDTO.class, nfcTokenParameter);
    }

    private <A extends TokenActionDTO> A newTokenActionDTO(Class<A> clazz, NfcTokenParameter nfcTokenParameter) {
        TokenActionDTO tokenActionDTO = (TokenActionDTO)ClassHelper.instantiate(clazz);
        tokenActionDTO.setTokenType((TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)nfcTokenParameter.getType()));
        tokenActionDTO.setTokenValue(nfcTokenParameter.getToken());
        return (A)tokenActionDTO;
    }

    private <A extends TokenActionWithUserDTO> A newTokenActionWithUserDTO(Class<A> clazz, NfcTokenWithUserParameter nfcTokenWithUserParameter) {
        TokenActionWithUserDTO tokenActionWithUserDTO = (TokenActionWithUserDTO)this.newTokenActionDTO(clazz, nfcTokenWithUserParameter);
        tokenActionWithUserDTO.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)nfcTokenWithUserParameter.getUser()));
        return (A)tokenActionWithUserDTO;
    }
}

