/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.AbstractTransactionQuery;
import org.cyclos.model.banking.transactions.BaseInstallmentQuery;
import org.cyclos.model.banking.transactions.IInstallmentSearchData;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.InstallmentLocatorVO;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentOverviewSearchData;
import org.cyclos.model.banking.transactions.InstallmentPreviewVO;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentResultVO;
import org.cyclos.model.banking.transactions.InstallmentSearchData;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.InstallmentVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.BaseInstallmentDataForSearch;
import org.cyclos.web.rest.model.BaseInstallmentQueryFilters;
import org.cyclos.web.rest.model.BaseInstallmentResult;
import org.cyclos.web.rest.model.Installment;
import org.cyclos.web.rest.model.InstallmentDataForSearch;
import org.cyclos.web.rest.model.InstallmentOverviewDataForSearch;
import org.cyclos.web.rest.model.InstallmentOverviewQueryFilters;
import org.cyclos.web.rest.model.InstallmentOverviewResult;
import org.cyclos.web.rest.model.InstallmentPreview;
import org.cyclos.web.rest.model.InstallmentQueryFilters;
import org.cyclos.web.rest.model.InstallmentResult;
import org.cyclos.web.rest.model.InstallmentStatusEnum;
import org.cyclos.web.rest.model.InstallmentView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class InstallmentsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    @Lazy
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private TransfersApiHelper transfersApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;

    public Installment toInstallment(InstallmentVO installmentVO) {
        if (installmentVO == null) {
            return null;
        }
        return this.newInstallment(Installment.class, installmentVO);
    }

    public InstallmentActionDTO toInstallmentActionDTO(String string, String string2) {
        InstallmentActionDTO installmentActionDTO = new InstallmentActionDTO();
        installmentActionDTO.setInstallment((InstallmentLocatorVO)ModelHelper.voFromString(InstallmentLocatorVO.class, (String)string));
        installmentActionDTO.setConfirmationPassword(string2);
        return installmentActionDTO;
    }

    public InstallmentDataForSearch toInstallmentDataForSearch(InstallmentSearchData installmentSearchData) {
        InstallmentDataForSearch installmentDataForSearch = this.newInstallmentDataForSearch(InstallmentDataForSearch.class, (IInstallmentSearchData)installmentSearchData);
        if (installmentSearchData.getAccountOwner() instanceof UserVO) {
            installmentDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserVO)installmentSearchData.getAccountOwner())));
        }
        installmentDataForSearch.setQuery(this.toInstallmentQueryFilters((InstallmentQuery)installmentSearchData.getQuery()));
        return installmentDataForSearch;
    }

    public InstallmentOverviewDataForSearch toInstallmentOverviewDataForSearch(InstallmentOverviewSearchData installmentOverviewSearchData) {
        if (installmentOverviewSearchData == null) {
            return null;
        }
        InstallmentOverviewDataForSearch installmentOverviewDataForSearch = this.newInstallmentDataForSearch(InstallmentOverviewDataForSearch.class, (IInstallmentSearchData)installmentOverviewSearchData);
        CollectionHelper.orEmpty((List)installmentOverviewSearchData.getPreselectedPeriods()).stream().map(this.apiHelper::toPreselectedPeriod).forEach(installmentOverviewDataForSearch.getPreselectedPeriods()::add);
        installmentOverviewDataForSearch.setQuery(this.toInstallmentOverviewQueryFilters((InstallmentOverviewQuery)installmentOverviewSearchData.getQuery()));
        return installmentOverviewDataForSearch;
    }

    public InstallmentOverviewQuery toInstallmentOverviewQuery(InstallmentOverviewQueryFilters installmentOverviewQueryFilters) {
        if (installmentOverviewQueryFilters == null) {
            return null;
        }
        InstallmentOverviewQuery installmentOverviewQuery = this.newBaseInstallmentQuery(InstallmentOverviewQuery.class, installmentOverviewQueryFilters);
        installmentOverviewQuery.setCurrencies(CollectionHelper.orEmpty(installmentOverviewQueryFilters.getCurrencies()).stream().map(string -> (CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)string)).collect(Collectors.toSet()));
        installmentOverviewQuery.setFromAccounts(CollectionHelper.orEmpty(installmentOverviewQueryFilters.getFromAccountTypes()).stream().map(string -> (AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)string)).collect(Collectors.toSet()));
        installmentOverviewQuery.setToAccounts(CollectionHelper.orEmpty(installmentOverviewQueryFilters.getToAccountTypes()).stream().map(string -> (AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)string)).collect(Collectors.toSet()));
        return installmentOverviewQuery;
    }

    public InstallmentOverviewQueryFilters toInstallmentOverviewQueryFilters(InstallmentOverviewQuery installmentOverviewQuery) {
        if (installmentOverviewQuery == null) {
            return null;
        }
        InstallmentOverviewQueryFilters installmentOverviewQueryFilters = this.newBaseInstallmentQueryFilters(InstallmentOverviewQueryFilters.class, (BaseInstallmentQuery)installmentOverviewQuery);
        CollectionHelper.orEmpty((Set)installmentOverviewQuery.getCurrencies()).stream().map(ModelHelper::internalNameOrId).forEach(installmentOverviewQueryFilters.getCurrencies()::add);
        CollectionHelper.orEmpty((Set)installmentOverviewQuery.getFromAccounts()).stream().map(ModelHelper::internalNameOrId).forEach(installmentOverviewQueryFilters.getFromAccountTypes()::add);
        CollectionHelper.orEmpty((Set)installmentOverviewQuery.getToAccounts()).stream().map(ModelHelper::internalNameOrId).forEach(installmentOverviewQueryFilters.getToAccountTypes()::add);
        return installmentOverviewQueryFilters;
    }

    public InstallmentOverviewResult toInstallmentOverviewResult(InstallmentResultVO installmentResultVO) {
        if (installmentResultVO == null) {
            return null;
        }
        InstallmentOverviewResult installmentOverviewResult = this.newBaseInstallmentResult(InstallmentOverviewResult.class, installmentResultVO);
        installmentOverviewResult.setTransaction(this.transactionsApiHelper.toTransactionOverviewResult(installmentResultVO.getTransaction(), false));
        return installmentOverviewResult;
    }

    public InstallmentPreview toInstallmentPreview(InstallmentPreviewVO installmentPreviewVO) {
        if (installmentPreviewVO == null) {
            return null;
        }
        InstallmentPreview installmentPreview = new InstallmentPreview();
        installmentPreview.setNumber(installmentPreviewVO.getNumber());
        installmentPreview.setDueDate(installmentPreviewVO.getDueDate());
        installmentPreview.setMainAmount(this.apiHelper.getAmount(installmentPreviewVO.getMainAmount()));
        installmentPreview.setTotalAmount(this.apiHelper.getAmount(installmentPreviewVO.getTotalAmount()));
        CollectionHelper.orEmpty((List)installmentPreviewVO.getFees()).stream().map(this.paymentsApiHelper::toFeePreview).forEach(installmentPreview.getFees()::add);
        return installmentPreview;
    }

    public InstallmentQuery toInstallmentQuery(String string, InstallmentQueryFilters installmentQueryFilters) {
        if (installmentQueryFilters == null) {
            return null;
        }
        InstallmentQuery installmentQuery = this.newBaseInstallmentQuery(InstallmentQuery.class, installmentQueryFilters);
        installmentQuery.setOwner(ModelHelper.accountOwner((String)string));
        installmentQuery.setDirection(this.transfersApiHelper.toTransferDirection(installmentQueryFilters.getDirection()));
        installmentQuery.setAccountTypes(ModelHelper.vosFromString(AccountTypeVO.class, installmentQueryFilters.getAccountTypes()));
        return installmentQuery;
    }

    public InstallmentQueryFilters toInstallmentQueryFilters(InstallmentQuery installmentQuery) {
        if (installmentQuery == null) {
            return null;
        }
        InstallmentQueryFilters installmentQueryFilters = this.newBaseInstallmentQueryFilters(InstallmentQueryFilters.class, (BaseInstallmentQuery)installmentQuery);
        installmentQueryFilters.setDirection(this.transfersApiHelper.toTransferDirectionEnum(installmentQuery.getDirection()));
        CollectionHelper.orEmpty((Set)installmentQuery.getAccountTypes()).stream().map(ModelHelper::internalNameOrId).forEach(installmentQueryFilters.getAccountTypes()::add);
        return installmentQueryFilters;
    }

    public InstallmentResult toInstallmentResult(InstallmentResultVO installmentResultVO) {
        InstallmentResult installmentResult = this.newBaseInstallmentResult(InstallmentResult.class, installmentResultVO);
        installmentResult.setTransaction(this.transactionsApiHelper.toTransactionResult(installmentResultVO.getTransaction(), false));
        return installmentResult;
    }

    public InstallmentStatus toInstallmentStatus(InstallmentStatusEnum installmentStatusEnum) {
        if (installmentStatusEnum != null) {
            switch (installmentStatusEnum) {
                case BLOCKED: {
                    return InstallmentStatus.BLOCKED;
                }
                case CANCELED: {
                    return InstallmentStatus.CANCELED;
                }
                case FAILED: {
                    return InstallmentStatus.FAILED;
                }
                case PROCESSED: {
                    return InstallmentStatus.PROCESSED;
                }
                case SCHEDULED: {
                    return InstallmentStatus.SCHEDULED;
                }
                case SETTLED: {
                    return InstallmentStatus.SETTLED;
                }
            }
        }
        return null;
    }

    public InstallmentStatusEnum toInstallmentStatusEnum(InstallmentStatus installmentStatus) {
        if (installmentStatus != null) {
            switch (installmentStatus) {
                case BLOCKED: {
                    return InstallmentStatusEnum.BLOCKED;
                }
                case CANCELED: {
                    return InstallmentStatusEnum.CANCELED;
                }
                case FAILED: {
                    return InstallmentStatusEnum.FAILED;
                }
                case PROCESSED: {
                    return InstallmentStatusEnum.PROCESSED;
                }
                case SCHEDULED: {
                    return InstallmentStatusEnum.SCHEDULED;
                }
                case SETTLED: {
                    return InstallmentStatusEnum.SETTLED;
                }
            }
        }
        return null;
    }

    public InstallmentView toInstallmentView(InstallmentVO installmentVO) {
        if (installmentVO == null) {
            return null;
        }
        InstallmentView installmentView = this.newInstallment(InstallmentView.class, installmentVO);
        installmentView.setBy(this.usersApiHelper.toUser(installmentVO.getBy()));
        installmentView.setTransferId(ApiHelper.toId(installmentVO.getTransferId()));
        installmentView.setTransferDate(installmentVO.getTransferDate());
        installmentView.setTransferTransactionNumber(installmentVO.getTransferTransactionNumber());
        return installmentView;
    }

    private <Q extends BaseInstallmentQuery> Q newBaseInstallmentQuery(Class<Q> clazz, BaseInstallmentQueryFilters baseInstallmentQueryFilters) {
        BaseInstallmentQuery baseInstallmentQuery = (BaseInstallmentQuery)this.transactionsApiHelper.newAbstractTransactionQuery(clazz, baseInstallmentQueryFilters);
        baseInstallmentQuery.setStatuses(CollectionHelper.orEmpty(baseInstallmentQueryFilters.getStatuses()).stream().map(this::toInstallmentStatus).collect(Collectors.toSet()));
        return (Q)baseInstallmentQuery;
    }

    private <F extends BaseInstallmentQueryFilters> F newBaseInstallmentQueryFilters(Class<F> clazz, BaseInstallmentQuery baseInstallmentQuery) {
        BaseInstallmentQueryFilters baseInstallmentQueryFilters = (BaseInstallmentQueryFilters)this.transactionsApiHelper.newBaseTransactionOrInstallmentQueryFilters(clazz, (AbstractTransactionQuery)baseInstallmentQuery);
        CollectionHelper.orEmpty((Set)baseInstallmentQuery.getStatuses()).stream().map(this::toInstallmentStatusEnum).forEach(baseInstallmentQueryFilters.getStatuses()::add);
        return (F)baseInstallmentQueryFilters;
    }

    private <R extends BaseInstallmentResult> R newBaseInstallmentResult(Class<R> clazz, InstallmentResultVO installmentResultVO) {
        BaseInstallmentResult baseInstallmentResult = (BaseInstallmentResult)this.apiHelper.newEntity(clazz, installmentResultVO);
        baseInstallmentResult.setStatus(this.toInstallmentStatusEnum(installmentResultVO.getStatus()));
        baseInstallmentResult.setNumber(installmentResultVO.getNumber());
        baseInstallmentResult.setTotalInstallments(installmentResultVO.getTotalInstallments());
        baseInstallmentResult.setDueDate(installmentResultVO.getDueDate());
        baseInstallmentResult.setAmount(installmentResultVO.getAmount());
        baseInstallmentResult.setTransferId(ApiHelper.toId(installmentResultVO.getTransferId()));
        baseInstallmentResult.setTransferDate(installmentResultVO.getTransferDate());
        baseInstallmentResult.setTransferTransactionNumber(installmentResultVO.getTransferTransactionNumber());
        return (R)baseInstallmentResult;
    }

    private <I extends Installment> I newInstallment(Class<I> clazz, InstallmentVO installmentVO) {
        Installment installment = (Installment)this.apiHelper.newEntity(clazz, installmentVO);
        installment.setNumber(installmentVO.getNumber());
        installment.setAmount(installmentVO.getAmount());
        installment.setDueDate(installmentVO.getDueDate());
        installment.setStatus(this.toInstallmentStatusEnum(installmentVO.getStatus()));
        return (I)installment;
    }

    private <D extends BaseInstallmentDataForSearch> D newInstallmentDataForSearch(Class<D> clazz, IInstallmentSearchData iInstallmentSearchData) {
        BaseInstallmentDataForSearch baseInstallmentDataForSearch = (BaseInstallmentDataForSearch)ClassHelper.instantiate(clazz);
        baseInstallmentDataForSearch.setArchivingDate(iInstallmentSearchData.getArchivingDate());
        CollectionHelper.orEmpty((List)iInstallmentSearchData.getManagedGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(baseInstallmentDataForSearch.getGroups()::add);
        CollectionHelper.orEmpty((List)iInstallmentSearchData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(baseInstallmentDataForSearch.getExportFormats()::add);
        CollectionHelper.orEmpty((List)iInstallmentSearchData.getAccountTypes()).stream().map(this.accountsApiHelper::toAccountType).forEach(baseInstallmentDataForSearch.getAccountTypes()::add);
        baseInstallmentDataForSearch.setCanViewAuthorized(iInstallmentSearchData.isCanViewAuthorized());
        CollectionHelper.orEmpty((Set)iInstallmentSearchData.getVisibleNatures()).stream().map(this.transactionsApiHelper::toTransactionKind).forEach(baseInstallmentDataForSearch.getVisibleKinds()::add);
        List list = CollectionHelper.orEmpty((List)iInstallmentSearchData.getFieldsForSearch());
        List list2 = CollectionHelper.orEmpty((List)iInstallmentSearchData.getFieldsForList());
        LinkedHashSet linkedHashSet = new LinkedHashSet(list);
        linkedHashSet.addAll(list2);
        linkedHashSet.stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseInstallmentDataForSearch.getCustomFields()::add);
        list.stream().map(ModelHelper::unqualifiedInternalNameOrId).forEach(baseInstallmentDataForSearch.getFieldsInBasicSearch()::add);
        list2.stream().map(ModelHelper::unqualifiedInternalNameOrId).forEach(baseInstallmentDataForSearch.getFieldsInList()::add);
        CollectionHelper.orEmpty((List)iInstallmentSearchData.getFieldsForSearch()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseInstallmentDataForSearch.getCustomFieldsInSearch()::add);
        CollectionHelper.orEmpty((List)iInstallmentSearchData.getFieldsForList()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseInstallmentDataForSearch.getCustomFieldsInList()::add);
        return (D)baseInstallmentDataForSearch;
    }
}

