/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.AbstractPaymentTypeData;
import org.cyclos.model.banking.transactions.EasyInvoiceBarcodeParams;
import org.cyclos.model.banking.transactions.EasyInvoiceData;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceData;
import org.cyclos.model.banking.transactions.PrepareEasyInvoiceParams;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.EasyInvoicesApi;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.DataForEasyInvoice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EasyInvoicesApiHelper {
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;

    public DataForEasyInvoice toDataForEasyInvoice(PrepareEasyInvoiceData prepareEasyInvoiceData) {
        DataForEasyInvoice dataForEasyInvoice = new DataForEasyInvoice();
        dataForEasyInvoice.setTo(this.usersApiHelper.toUser((BasicUserVO)prepareEasyInvoiceData.getTo()));
        if (prepareEasyInvoiceData.getAmount() != null) {
            dataForEasyInvoice.setAmount(prepareEasyInvoiceData.getAmount().getAmount());
            dataForEasyInvoice.setCurrency(this.accountsApiHelper.toCurrency(prepareEasyInvoiceData.getAmount()));
        }
        if (prepareEasyInvoiceData instanceof EasyInvoiceData) {
            EasyInvoiceData easyInvoiceData = (EasyInvoiceData)prepareEasyInvoiceData;
            dataForEasyInvoice.setPaymentTypeData(this.transactionsApiHelper.toTransactionTypeData((AbstractPaymentTypeData)easyInvoiceData.getPaymentTypeData()));
            CollectionHelper.orEmpty((List)easyInvoiceData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferTypeWithCurrency).forEach(dataForEasyInvoice.getPaymentTypes()::add);
            dataForEasyInvoice.setCustomValues(this.apiHelper.toCustomFieldValuesList(easyInvoiceData.getCustomValues()));
        } else {
            dataForEasyInvoice.setDeviceConfirmationAvailability(this.apiHelper.toAvailabilityEnum(prepareEasyInvoiceData.getDeviceConfirmationAvailability()));
        }
        if (CollectionHelper.isEmpty(dataForEasyInvoice.getPaymentTypes())) {
            dataForEasyInvoice.setPaymentTypes(null);
        }
        if (CollectionHelper.isEmpty(dataForEasyInvoice.getCustomValues())) {
            dataForEasyInvoice.setCustomValues(null);
        }
        return dataForEasyInvoice;
    }

    public EasyInvoiceBarcodeParams toEasyInvoiceBarcodeParamsDTO(EasyInvoicesApi.GetEasyInvoiceQrCodeParams getEasyInvoiceQrCodeParams) {
        if (getEasyInvoiceQrCodeParams == null) {
            return null;
        }
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setSubject((InternalAccountOwner)ModelHelper.voFromString(UserVO.class, (String)getEasyInvoiceQrCodeParams.to));
        performPaymentDTO.setAmount(getEasyInvoiceQrCodeParams.amount);
        performPaymentDTO.setDescription(getEasyInvoiceQrCodeParams.description);
        performPaymentDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)getEasyInvoiceQrCodeParams.currency));
        performPaymentDTO.setType((TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)getEasyInvoiceQrCodeParams.type));
        performPaymentDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(getEasyInvoiceQrCodeParams.customFields));
        EasyInvoiceBarcodeParams easyInvoiceBarcodeParams = new EasyInvoiceBarcodeParams();
        easyInvoiceBarcodeParams.setSize(this.apiHelper.toImageSize(getEasyInvoiceQrCodeParams.size));
        easyInvoiceBarcodeParams.setPerformPayment(performPaymentDTO);
        return easyInvoiceBarcodeParams;
    }

    public PerformPaymentDTO toPerformPaymentDTO(EasyInvoicesApi.DataForPerformEasyInvoiceParams dataForPerformEasyInvoiceParams) {
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setSubject((InternalAccountOwner)ModelHelper.voFromString(UserLocatorVO.class, (String)dataForPerformEasyInvoiceParams.to));
        performPaymentDTO.setAmount(dataForPerformEasyInvoiceParams.amount);
        performPaymentDTO.setType((TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)dataForPerformEasyInvoiceParams.type));
        performPaymentDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)dataForPerformEasyInvoiceParams.currency));
        performPaymentDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(dataForPerformEasyInvoiceParams.customFields));
        return performPaymentDTO;
    }

    public PrepareEasyInvoiceParams toPrepareEasyInvoiceParams(EasyInvoicesApi.DataForPerformEasyInvoiceParams dataForPerformEasyInvoiceParams) {
        PrepareEasyInvoiceParams prepareEasyInvoiceParams = new PrepareEasyInvoiceParams();
        UserLocatorVO userLocatorVO = ModelHelper.userLocator((String)dataForPerformEasyInvoiceParams.to, (boolean)false);
        if (StringHelper.isBlank((Object)userLocatorVO.getPrincipalType()) && StringHelper.isNotBlank((Object)userLocatorVO.getPrincipal())) {
            userLocatorVO.setPrincipalType("*");
        }
        prepareEasyInvoiceParams.setTo(userLocatorVO);
        prepareEasyInvoiceParams.setAmount(dataForPerformEasyInvoiceParams.amount);
        prepareEasyInvoiceParams.setType((TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)dataForPerformEasyInvoiceParams.type));
        prepareEasyInvoiceParams.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)dataForPerformEasyInvoiceParams.currency));
        return prepareEasyInvoiceParams;
    }
}

