/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.contentmanagement.documentcategories.DocumentCategoryVO;
import org.cyclos.model.contentmanagement.documents.DocumentDTO;
import org.cyclos.model.contentmanagement.documents.DocumentData;
import org.cyclos.model.contentmanagement.documents.DocumentNature;
import org.cyclos.model.contentmanagement.documents.DocumentQuery;
import org.cyclos.model.contentmanagement.documents.DocumentRange;
import org.cyclos.model.contentmanagement.documents.DocumentSearchData;
import org.cyclos.model.contentmanagement.documents.DocumentVO;
import org.cyclos.model.contentmanagement.documents.DynamicDocumentData;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentDTO;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentData;
import org.cyclos.model.contentmanagement.documents.SharedDocumentDTO;
import org.cyclos.model.contentmanagement.documents.SharedDocumentData;
import org.cyclos.model.contentmanagement.documents.StaticDocumentDTO;
import org.cyclos.model.contentmanagement.documents.StaticDocumentData;
import org.cyclos.model.contentmanagement.documents.UserDocumentDTO;
import org.cyclos.model.contentmanagement.documents.UserDocumentData;
import org.cyclos.model.contentmanagement.documents.UserDocumentVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.model.utils.StoredFileVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.FilesApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.DataForDynamicDocument;
import org.cyclos.web.rest.model.Document;
import org.cyclos.web.rest.model.DocumentBasicData;
import org.cyclos.web.rest.model.DocumentDataForEdit;
import org.cyclos.web.rest.model.DocumentDataForNew;
import org.cyclos.web.rest.model.DocumentDataForSearch;
import org.cyclos.web.rest.model.DocumentEdit;
import org.cyclos.web.rest.model.DocumentKind;
import org.cyclos.web.rest.model.DocumentManage;
import org.cyclos.web.rest.model.DocumentNew;
import org.cyclos.web.rest.model.DocumentQueryFilters;
import org.cyclos.web.rest.model.DocumentRangeEnum;
import org.cyclos.web.rest.model.DocumentResult;
import org.cyclos.web.rest.model.DocumentView;
import org.cyclos.web.rest.model.ProcessDynamicDocument;
import org.cyclos.web.rest.model.StoredFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private FilesApiHelper filesApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public DataForDynamicDocument toDataForDynamicDocument(ProcessDynamicDocumentData processDynamicDocumentData) {
        DataForDynamicDocument dataForDynamicDocument = new DataForDynamicDocument();
        dataForDynamicDocument.setDocument(this.toDocument(processDynamicDocumentData.getDocument()));
        dataForDynamicDocument.setUser(this.usersApiHelper.toUser((BasicUserVO)processDynamicDocumentData.getUser()));
        processDynamicDocumentData.getFormFields().stream().map(this.apiHelper::toCustomFieldDetailed).forEach(dataForDynamicDocument.getFormFields()::add);
        return dataForDynamicDocument;
    }

    public Document toDocument(DocumentVO documentVO) {
        if (documentVO == null) {
            return null;
        }
        return this.newDocument(Document.class, documentVO);
    }

    public DocumentDataForEdit toDocumentDataForEdit(String string, DocumentData documentData) {
        DocumentDataForEdit documentDataForEdit = this.newDocumentBasicData(DocumentDataForEdit.class, documentData);
        RawFileVO rawFileVO = null;
        if (documentData instanceof UserDocumentData) {
            rawFileVO = ((UserDocumentData)documentData).getFile();
        } else if (documentData instanceof StaticDocumentData) {
            StaticDocumentData staticDocumentData = (StaticDocumentData)documentData;
            rawFileVO = staticDocumentData.getFile();
            documentDataForEdit.setDownloadUrlTemplate(staticDocumentData.getNewUrlTemplate());
        }
        documentDataForEdit.setFile(this.documentFile(string, rawFileVO));
        documentDataForEdit.setDocument(this.toDocumentEdit((DocumentDTO)documentData.getDto()));
        return documentDataForEdit;
    }

    public DocumentDataForNew toDocumentDataForNew(DocumentData documentData) {
        DocumentDataForNew documentDataForNew = this.newDocumentBasicData(DocumentDataForNew.class, documentData);
        documentDataForNew.setDocument(this.toDocumentNew((DocumentDTO)documentData.getDto()));
        return documentDataForNew;
    }

    public DocumentDataForSearch toDocumentDataForSearch(DocumentSearchData documentSearchData) {
        if (documentSearchData == null) {
            return null;
        }
        DocumentDataForSearch documentDataForSearch = new DocumentDataForSearch();
        documentDataForSearch.setQuery(this.toDocumentQueryFilters((DocumentQuery)documentSearchData.getQuery()));
        documentDataForSearch.setCanManageIndividual(documentSearchData.isCanManageIndividual());
        CollectionHelper.orEmpty((List)documentSearchData.getViewCategories()).stream().map(this.apiHelper::toReference).forEach(documentDataForSearch.getCategories()::add);
        CollectionHelper.orEmpty((List)documentSearchData.getManageCategories()).stream().map(ModelHelper::internalNameOrId).forEach(documentDataForSearch.getManageCategories()::add);
        documentDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)documentSearchData.getUser()));
        return documentDataForSearch;
    }

    public <DTO extends DocumentDTO> DTO toDocumentDTO(Class<DTO> clazz, DocumentManage documentManage) {
        if (documentManage == null) {
            return null;
        }
        DTO DTO = this.newDocumentDTO(clazz, documentManage);
        if (DTO instanceof UserDocumentDTO) {
            UserDocumentDTO userDocumentDTO = (UserDocumentDTO)DTO;
            userDocumentDTO.setMemberVisible(Boolean.TRUE.equals(documentManage.getUserVisible()));
            userDocumentDTO.setBrokerVisible(Boolean.TRUE.equals(documentManage.getBrokerVisible()));
            userDocumentDTO.setBrokerManageable(Boolean.TRUE.equals(documentManage.getBrokerManageable()));
        } else if (DTO instanceof SharedDocumentDTO) {
            SharedDocumentDTO sharedDocumentDTO = (SharedDocumentDTO)DTO;
            sharedDocumentDTO.setInternalName(documentManage.getInternalName());
            sharedDocumentDTO.setCategory((DocumentCategoryVO)ModelHelper.voFromString(DocumentCategoryVO.class, (String)documentManage.getCategory()));
            if (DTO instanceof StaticDocumentDTO) {
                ((StaticDocumentDTO)sharedDocumentDTO).setPubliclyAccessible(Boolean.TRUE.equals(documentManage.getPubliclyAccessible()));
            }
        }
        if (documentManage instanceof DocumentEdit) {
            DTO.setVersion(((DocumentEdit)documentManage).getVersion());
        }
        return DTO;
    }

    public DocumentEdit toDocumentEdit(DocumentDTO documentDTO) {
        if (documentDTO == null) {
            return null;
        }
        DocumentEdit documentEdit = this.newDocumentManage(DocumentEdit.class, documentDTO);
        documentEdit.setVersion(documentDTO.getVersion());
        return documentEdit;
    }

    public DocumentKind toDocumentKind(DocumentNature documentNature) {
        if (documentNature != null) {
            switch (documentNature) {
                case STATIC: {
                    return DocumentKind.STATIC;
                }
                case DYNAMIC: {
                    return DocumentKind.DYNAMIC;
                }
                case USER: {
                    return DocumentKind.USER;
                }
            }
        }
        return null;
    }

    public DocumentNew toDocumentNew(DocumentDTO documentDTO) {
        if (documentDTO == null) {
            return null;
        }
        return this.newDocumentManage(DocumentNew.class, documentDTO);
    }

    public DocumentQuery toDocumentQuery(DocumentQueryFilters documentQueryFilters) {
        DocumentQuery documentQuery = this.apiHelper.newQuery(DocumentQuery.class, documentQueryFilters.getPage(), documentQueryFilters.getPageSize(), documentQueryFilters.getSkipTotalCount());
        documentQuery.setDocumentRange(this.toDocumentRange(documentQueryFilters.getRange()));
        documentQuery.setEnabled(documentQueryFilters.getEnabled());
        documentQuery.setCategories(CollectionHelper.orEmpty(documentQueryFilters.getCategories()).stream().map(string -> (DocumentCategoryVO)ModelHelper.voFromString(DocumentCategoryVO.class, (String)string)).collect(Collectors.toSet()));
        documentQuery.setGroups(CollectionHelper.orEmpty(documentQueryFilters.getGroups()).stream().map(string -> (BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)string)).collect(Collectors.toSet()));
        documentQuery.setBrokers(CollectionHelper.orEmpty(documentQueryFilters.getBrokers()).stream().map(string -> (UserVO)ModelHelper.voFromString(UserVO.class, (String)string)).collect(Collectors.toSet()));
        documentQuery.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)documentQueryFilters.getUser()));
        documentQuery.setKeywords(documentQueryFilters.getKeywords());
        return documentQuery;
    }

    public DocumentQueryFilters toDocumentQueryFilters(DocumentQuery documentQuery) {
        if (documentQuery == null) {
            return null;
        }
        DocumentQueryFilters documentQueryFilters = this.apiHelper.newQueryFilters(DocumentQueryFilters.class, (QueryParameters)documentQuery);
        documentQueryFilters.setRange(this.toDocumentRangeEnum(documentQuery.getDocumentRange()));
        documentQueryFilters.setEnabled(documentQuery.getEnabled());
        documentQueryFilters.setCategories(CollectionHelper.orEmpty((Set)documentQuery.getCategories()).stream().map(ModelHelper::stringOrIdFromVO).collect(Collectors.toList()));
        documentQueryFilters.setGroups(CollectionHelper.orEmpty((Set)documentQuery.getGroups()).stream().map(ModelHelper::stringOrIdFromVO).collect(Collectors.toList()));
        documentQueryFilters.setBrokers(CollectionHelper.orEmpty((Set)documentQuery.getBrokers()).stream().map(ModelHelper::stringOrIdFromVO).collect(Collectors.toList()));
        documentQueryFilters.setUser(ModelHelper.stringOrIdFromVO((EntityVO)documentQuery.getUser()));
        documentQueryFilters.setKeywords(documentQuery.getKeywords());
        return documentQueryFilters;
    }

    public DocumentRange toDocumentRange(DocumentRangeEnum documentRangeEnum) {
        if (documentRangeEnum != null) {
            switch (documentRangeEnum) {
                case INDIVIDUAL: {
                    return DocumentRange.INDIVIDUAL;
                }
                case SHARED: {
                    return DocumentRange.SHARED;
                }
            }
        }
        return null;
    }

    public DocumentRangeEnum toDocumentRangeEnum(DocumentRange documentRange) {
        if (documentRange != null) {
            switch (documentRange) {
                case INDIVIDUAL: {
                    return DocumentRangeEnum.INDIVIDUAL;
                }
                case SHARED: {
                    return DocumentRangeEnum.SHARED;
                }
            }
        }
        return null;
    }

    public DocumentResult toDocumentResult(DocumentVO documentVO) {
        if (documentVO == null) {
            return null;
        }
        DocumentResult documentResult = this.newDocument(DocumentResult.class, documentVO);
        if (documentVO instanceof UserDocumentVO) {
            documentResult.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserDocumentVO)documentVO).getUser()));
            documentResult.setBrokerManageable(((UserDocumentVO)documentVO).isBrokerManageable());
        }
        return documentResult;
    }

    public DocumentView toDocumentView(DocumentData documentData) {
        DocumentDTO documentDTO = (DocumentDTO)documentData.getDto();
        DocumentView documentView = this.apiHelper.newEntity(DocumentView.class, documentDTO);
        documentView.setDescription(documentDTO.getDescription());
        documentView.setEnabled(documentDTO.isEnable());
        documentView.setCanEdit(documentData.isEditable());
        documentView.setCanRemove(documentData.isRemovable());
        if (documentDTO instanceof SharedDocumentDTO) {
            documentView.setCategory(this.apiHelper.toReference((EntityModel)((SharedDocumentDTO)documentDTO).getCategory()));
        }
        if (documentData instanceof UserDocumentData) {
            UserDocumentData userDocumentData = (UserDocumentData)documentData;
            UserDocumentDTO userDocumentDTO = (UserDocumentDTO)documentDTO;
            documentView.setKind(DocumentKind.USER);
            documentView.setUser(this.usersApiHelper.toUser((BasicUserVO)userDocumentData.getUser()));
            documentView.setFile(this.documentFile(documentView.getId(), userDocumentData.getFile()));
            documentView.setUserVisible(userDocumentDTO.isMemberVisible());
            documentView.setBrokerVisible(userDocumentDTO.isBrokerVisible());
            documentView.setBrokerManageable(userDocumentDTO.isBrokerManageable());
        } else if (documentData instanceof StaticDocumentData) {
            StaticDocumentData staticDocumentData = (StaticDocumentData)documentData;
            StaticDocumentDTO staticDocumentDTO = (StaticDocumentDTO)documentDTO;
            documentView.setKind(DocumentKind.STATIC);
            documentView.setFile(this.documentFile(documentView.getId(), staticDocumentData.getFile()));
            documentView.setPubliclyAccessible(staticDocumentDTO.isPubliclyAccessible());
            documentView.setDownloadUrl(this.urlFromTemplate(staticDocumentDTO, staticDocumentData.getNewUrlTemplate()));
        } else if (documentData instanceof DynamicDocumentData) {
            documentView.setKind(DocumentKind.DYNAMIC);
        }
        return documentView;
    }

    public ProcessDynamicDocumentDTO toProcessDynamicDocumentDTO(String string, String string2, ProcessDynamicDocument processDynamicDocument) {
        ProcessDynamicDocumentDTO processDynamicDocumentDTO = new ProcessDynamicDocumentDTO();
        processDynamicDocumentDTO.setDocument(new DocumentVO(this.apiHelper.fromId(string)));
        processDynamicDocumentDTO.setUser((UserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        processDynamicDocumentDTO.setFormFields(this.apiHelper.toCustomFieldValuesDTO(processDynamicDocument.getFormFields()));
        return processDynamicDocumentDTO;
    }

    private StoredFile documentFile(String string, RawFileVO rawFileVO) {
        StoredFile storedFile = this.filesApiHelper.toStoredFile((StoredFileVO)rawFileVO);
        if (storedFile != null) {
            storedFile.setUrl(this.apiHelper.urlFromApi("documents", string, "file"));
        }
        return storedFile;
    }

    private <D extends Document> D newDocument(Class<D> clazz, DocumentVO documentVO) {
        Document document = (Document)this.apiHelper.newEntity(clazz, documentVO);
        document.setCategory(this.apiHelper.toReference((EntityModel)documentVO.getCategory()));
        document.setDescription(documentVO.getDescription());
        document.setKind(this.toDocumentKind(documentVO.getNature()));
        document.setFile(this.documentFile(document.getId(), documentVO.getFile()));
        return (D)document;
    }

    private <D extends DocumentBasicData> D newDocumentBasicData(Class<D> clazz, DocumentData documentData) {
        DocumentBasicData documentBasicData = (DocumentBasicData)ClassHelper.instantiate(clazz);
        DocumentDTO documentDTO = (DocumentDTO)documentData.getDto();
        documentBasicData.setKind(documentDTO instanceof UserDocumentDTO ? DocumentKind.USER : DocumentKind.STATIC);
        if (documentDTO instanceof UserDocumentDTO) {
            UserDocumentDTO userDocumentDTO = (UserDocumentDTO)documentDTO;
            documentBasicData.setUser(this.usersApiHelper.toUser((BasicUserVO)userDocumentDTO.getUser()));
            documentBasicData.setCategories(null);
        } else if (documentDTO instanceof SharedDocumentDTO) {
            ((SharedDocumentData)documentData).getCategories().stream().map(this.apiHelper::toReference).forEach(documentBasicData.getCategories()::add);
        }
        return (D)documentBasicData;
    }

    private <DTO extends DocumentDTO> DTO newDocumentDTO(Class<DTO> clazz, DocumentManage documentManage) {
        DocumentDTO documentDTO = (DocumentDTO)ClassHelper.instantiate(clazz);
        documentDTO.setName(documentManage.getName());
        documentDTO.setDescription(documentManage.getDescription());
        documentDTO.setEnable(Boolean.TRUE.equals(documentManage.getEnabled()));
        return (DTO)documentDTO;
    }

    private <R extends DocumentManage> R newDocumentManage(Class<R> clazz, DocumentDTO documentDTO) {
        DocumentManage documentManage = (DocumentManage)ClassHelper.instantiate(clazz);
        documentManage.setName(documentDTO.getName());
        documentManage.setDescription(documentDTO.getDescription());
        documentManage.setEnabled(documentDTO.isEnable());
        if (documentDTO instanceof UserDocumentDTO) {
            UserDocumentDTO userDocumentDTO = (UserDocumentDTO)documentDTO;
            documentManage.setUserVisible(userDocumentDTO.isMemberVisible());
            documentManage.setBrokerVisible(userDocumentDTO.isBrokerVisible());
            documentManage.setBrokerManageable(userDocumentDTO.isBrokerManageable());
        } else if (documentDTO instanceof SharedDocumentDTO) {
            SharedDocumentDTO sharedDocumentDTO = (SharedDocumentDTO)documentDTO;
            documentManage.setInternalName(sharedDocumentDTO.getInternalName());
            documentManage.setCategory(ModelHelper.internalNameOrId((IEntity)sharedDocumentDTO.getCategory()));
            if (documentDTO instanceof StaticDocumentDTO) {
                documentManage.setPubliclyAccessible(((StaticDocumentDTO)sharedDocumentDTO).isPubliclyAccessible());
            }
        }
        return (R)documentManage;
    }

    private String urlFromTemplate(StaticDocumentDTO staticDocumentDTO, String string) {
        if (StringHelper.isBlank((Object)string)) {
            return null;
        }
        String string2 = StringHelper.trimToNull((Object)staticDocumentDTO.getInternalName());
        if (string2 == null) {
            string2 = staticDocumentDTO.getId().toString();
        }
        return string.replace("{key}", string2);
    }
}

