/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.marketplace.CannotBuyException;
import org.cyclos.model.marketplace.OutOfStockException;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.helpers.MarketplaceApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.ShoppingCartError;
import org.cyclos.web.rest.model.ShoppingCartErrorCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShoppingCartErrorHandler
extends BaseErrorHandler<ShoppingCartError> {
    @Autowired
    private MarketplaceApiHelper marketplaceApiHelper;
    @Autowired
    private UsersApiHelper userApiHelper;

    public ShoppingCartErrorHandler() {
        super(ShoppingCartError.class);
    }

    public boolean isHandled(Throwable throwable) {
        return throwable instanceof OutOfStockException || throwable instanceof CannotBuyException;
    }

    @Override
    protected void fill(ShoppingCartError shoppingCartError, Throwable throwable) {
        if (throwable instanceof OutOfStockException) {
            shoppingCartError.setCode(ShoppingCartErrorCode.NOT_ENOUGH_STOCK);
            shoppingCartError.setAd(this.marketplaceApiHelper.toWebshopAd(((OutOfStockException)throwable).getItem()));
        } else if (throwable instanceof CannotBuyException) {
            shoppingCartError.setCode(ShoppingCartErrorCode.CAN_NOT_BUY_FROM_SELLER);
            shoppingCartError.setSeller(this.userApiHelper.toUser((BasicUserVO)((CannotBuyException)throwable).getSeller()));
        } else {
            shoppingCartError.setCode(ShoppingCartErrorCode.UNEXPECTED);
        }
    }
}

