/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.exceptions;

import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.vouchers.BuyingMaxAmountReachedForPeriodException;
import org.cyclos.model.banking.vouchers.BuyingMaxOpenAmountException;
import org.cyclos.model.banking.vouchers.BuyingNotAllowedForUserException;
import org.cyclos.model.banking.vouchers.MaxTotalOpenAmountException;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.web.rest.exceptions.BaseErrorHandler;
import org.cyclos.web.rest.exceptions.PaymentErrorHandler;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.model.BuyVoucherError;
import org.cyclos.web.rest.model.BuyVoucherErrorCode;
import org.cyclos.web.rest.model.PaymentError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuyVoucherErrorHandler
extends BaseErrorHandler<BuyVoucherError> {
    @Autowired
    private PaymentErrorHandler paymentErrorHandler;
    @Autowired
    private AccountsApiHelper accountsApiHelper;

    public BuyVoucherErrorHandler() {
        super(BuyVoucherError.class);
    }

    @Override
    protected void fill(BuyVoucherError buyVoucherError, Throwable throwable) {
        BuyVoucherErrorCode buyVoucherErrorCode = BuyVoucherErrorCode.UNEXPECTED;
        Class<?> clazz = throwable.getClass();
        if (clazz == BuyingMaxAmountReachedForPeriodException.class) {
            buyVoucherErrorCode = BuyVoucherErrorCode.MAX_AMOUNT_FOR_PERIOD;
        } else if (clazz == BuyingMaxOpenAmountException.class) {
            buyVoucherErrorCode = BuyVoucherErrorCode.MAX_OPEN_AMOUNT;
        } else if (clazz == BuyingNotAllowedForUserException.class) {
            buyVoucherErrorCode = BuyVoucherErrorCode.NOT_ALLOWED_FOR_USER;
        } else if (clazz == MaxTotalOpenAmountException.class) {
            buyVoucherErrorCode = BuyVoucherErrorCode.MAX_TOTAL_OPEN_AMOUNT;
        } else if (TransferException.class.isAssignableFrom(clazz)) {
            buyVoucherErrorCode = BuyVoucherErrorCode.PAYMENT;
        }
        buyVoucherError.setCode(buyVoucherErrorCode);
        if (throwable instanceof BuyingMaxOpenAmountException || throwable instanceof MaxTotalOpenAmountException) {
            CurrencyAmountDTO currencyAmountDTO;
            CurrencyAmountDTO currencyAmountDTO2;
            if (throwable instanceof BuyingMaxOpenAmountException) {
                BuyingMaxOpenAmountException buyingMaxOpenAmountException = (BuyingMaxOpenAmountException)throwable;
                currencyAmountDTO2 = buyingMaxOpenAmountException.getMaxOpenAmount();
                currencyAmountDTO = buyingMaxOpenAmountException.getCurrentOpenAmount();
            } else {
                MaxTotalOpenAmountException maxTotalOpenAmountException = (MaxTotalOpenAmountException)throwable;
                currencyAmountDTO2 = maxTotalOpenAmountException.getMaxOpenAmount();
                currencyAmountDTO = maxTotalOpenAmountException.getCurrentOpenAmount();
            }
            buyVoucherError.setCurrency(this.accountsApiHelper.toCurrency(currencyAmountDTO2));
            buyVoucherError.setMaxOpenAmount(currencyAmountDTO2 == null ? null : currencyAmountDTO2.getAmount());
            buyVoucherError.setCurrentOpenAmount(currencyAmountDTO == null ? null : currencyAmountDTO.getAmount());
        } else if (throwable instanceof BuyingMaxAmountReachedForPeriodException) {
            BuyingMaxAmountReachedForPeriodException buyingMaxAmountReachedForPeriodException = (BuyingMaxAmountReachedForPeriodException)throwable;
            CurrencyAmountDTO currencyAmountDTO = buyingMaxAmountReachedForPeriodException.getAmountLeftForBuying();
            if (currencyAmountDTO != null) {
                buyVoucherError.setCurrency(this.accountsApiHelper.toCurrency(currencyAmountDTO));
                buyVoucherError.setAmountLeftForBuying(currencyAmountDTO.getAmount());
            }
            buyVoucherError.setDateAllowedAgain(buyingMaxAmountReachedForPeriodException.getDateAllowedAgain());
        } else if (throwable instanceof TransferException) {
            buyVoucherError.setPaymentError((PaymentError)this.paymentErrorHandler.getError(throwable));
        }
    }
}

