/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.VouchersApiImpl;
import org.cyclos.web.rest.model.AssignVoucher;
import org.cyclos.web.rest.model.BuyVoucher;
import org.cyclos.web.rest.model.BuyVoucherError;
import org.cyclos.web.rest.model.ChangeVoucherExpirationDate;
import org.cyclos.web.rest.model.ChangeVoucherNotificationSettings;
import org.cyclos.web.rest.model.ChangeVoucherPin;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.GeneralVouchersDataForSearch;
import org.cyclos.web.rest.model.GenerateVoucher;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.RedeemVoucher;
import org.cyclos.web.rest.model.RedeemVoucherError;
import org.cyclos.web.rest.model.SendVoucher;
import org.cyclos.web.rest.model.TopUpVoucher;
import org.cyclos.web.rest.model.TopUpVoucherError;
import org.cyclos.web.rest.model.UserVoucherTransactionsDataForSearch;
import org.cyclos.web.rest.model.UserVouchersDataForSearch;
import org.cyclos.web.rest.model.VoucherBoughtResult;
import org.cyclos.web.rest.model.VoucherBuyingPreview;
import org.cyclos.web.rest.model.VoucherCreationTypeEnum;
import org.cyclos.web.rest.model.VoucherDataForBuy;
import org.cyclos.web.rest.model.VoucherDataForGenerate;
import org.cyclos.web.rest.model.VoucherDataForRedeem;
import org.cyclos.web.rest.model.VoucherDataForTopUp;
import org.cyclos.web.rest.model.VoucherInitialDataForTransaction;
import org.cyclos.web.rest.model.VoucherOrderByEnum;
import org.cyclos.web.rest.model.VoucherRedeemPreview;
import org.cyclos.web.rest.model.VoucherRedeemResult;
import org.cyclos.web.rest.model.VoucherRelationEnum;
import org.cyclos.web.rest.model.VoucherResult;
import org.cyclos.web.rest.model.VoucherSendingPreview;
import org.cyclos.web.rest.model.VoucherStatusEnum;
import org.cyclos.web.rest.model.VoucherTopUpPreview;
import org.cyclos.web.rest.model.VoucherTransaction;
import org.cyclos.web.rest.model.VoucherTransactionKind;
import org.cyclos.web.rest.model.VoucherTransactionResult;
import org.cyclos.web.rest.model.VoucherTransactionView;
import org.cyclos.web.rest.model.VoucherView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class VouchersApi {
    @Autowired
    private VouchersApiImpl impl;
    public static final String ASSIGN_VOUCHER = "/vouchers/{key}/assign";
    public static final String BUY_VOUCHERS = "/{user}/vouchers/buy";
    public static final String BUY_VOUCHERS_WITH_STATUS = "/{user}/vouchers/buy-with-status";
    public static final String CANCEL_VOUCHER = "/vouchers/{key}/cancel";
    public static final String CHANGE_VOUCHER_EXPIRATION_DATE = "/vouchers/{key}/change-expiration";
    public static final String CHANGE_VOUCHER_NOTIFICATION_SETTINGS = "/vouchers/{key}/change-notification-settings";
    public static final String CHANGE_VOUCHER_PIN = "/vouchers/{key}/change-pin";
    public static final String EXPORT_USER_VOUCHERS = "/{user}/vouchers/export/{format}";
    public static final String EXPORT_VOUCHER = "/vouchers/{key}/export/{format}";
    public static final String EXPORT_VOUCHER_TRANSACTION = "/voucher-transactions/{id}/export/{format}";
    public static final String EXPORT_VOUCHERS = "/vouchers/export/{format}";
    public static final String GENERATE_VOUCHERS = "/vouchers/generate";
    public static final String GET_GENERAL_VOUCHERS_DATA_FOR_SEARCH = "/vouchers/data-for-search";
    public static final String GET_USER_VOUCHER_TRANSACTIONS_DATA_FOR_SEARCH = "/{user}/voucher-transactions/data-for-search";
    public static final String GET_USER_VOUCHERS_DATA_FOR_SEARCH = "/{user}/vouchers/data-for-search";
    public static final String GET_VOUCHER_DATA_FOR_BUY = "/{user}/vouchers/data-for-buy";
    public static final String GET_VOUCHER_DATA_FOR_GENERATE = "/vouchers/data-for-generate";
    public static final String GET_VOUCHER_DATA_FOR_REDEEM = "/{user}/vouchers/{token}/data-for-redeem";
    public static final String GET_VOUCHER_DATA_FOR_SEND = "/{user}/vouchers/data-for-send";
    public static final String GET_VOUCHER_DATA_FOR_TOP_UP = "/{user}/vouchers/{token}/data-for-top-up";
    public static final String GET_VOUCHER_INITIAL_DATA_FOR_REDEEM = "/{user}/vouchers/data-for-redeem";
    public static final String GET_VOUCHER_INITIAL_DATA_FOR_TOP_UP = "/{user}/vouchers/data-for-top-up";
    public static final String GET_VOUCHER_QR_CODE = "/vouchers/{key}/qr-code";
    public static final String PREVIEW_BUY_VOUCHERS = "/{user}/vouchers/preview-buy";
    public static final String PREVIEW_SEND_VOUCHER = "/{user}/vouchers/preview-send";
    public static final String PREVIEW_VOUCHER_REDEEM = "/{user}/vouchers/{token}/preview-redeem";
    public static final String PREVIEW_VOUCHER_TOP_UP = "/{user}/vouchers/{token}/preview-top-up";
    public static final String REDEEM_VOUCHER = "/{user}/vouchers/{token}/redeem";
    public static final String RESEND_PIN = "/vouchers/{key}/resend-pin";
    public static final String RESEND_VOUCHER_EMAIL = "/vouchers/{key}/resend-email";
    public static final String SEARCH_USER_VOUCHER_TRANSACTIONS = "/{user}/voucher-transactions";
    public static final String SEARCH_USER_VOUCHERS = "/{user}/vouchers";
    public static final String SEARCH_VOUCHER_TRANSACTIONS = "/vouchers/{key}/transactions";
    public static final String SEARCH_VOUCHERS = "/vouchers";
    public static final String SEND_VOUCHER = "/{user}/vouchers/send";
    public static final String TOP_UP_VOUCHER = "/{user}/vouchers/{token}/top-up";
    public static final String UNBLOCK_VOUCHER_PIN = "/vouchers/{key}/unblock-pin";
    public static final String VIEW_VOUCHER = "/vouchers/{key}";
    public static final String VIEW_VOUCHER_TRANSACTION = "/voucher-transactions/{id}";

    @RequestMapping(value={"/api/vouchers/{key}/assign"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> assignVoucher(@PathVariable(value="key") String string, @RequestBody(required=true) AssignVoucher assignVoucher, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/{key}/assign");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.assignVoucher(string, assignVoucher);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/buy"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<List<String>> buyVouchers(@PathVariable(value="user") String string, @RequestBody(required=true) BuyVoucher buyVoucher, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/buy");
        httpServletRequest.setAttribute("errorType", BuyVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.buyVouchers(string, buyVoucher, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/buy-with-status"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<VoucherBoughtResult> buyVouchersWithStatus(@PathVariable(value="user") String string, @RequestBody(required=true) BuyVoucher buyVoucher, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/buy-with-status");
        httpServletRequest.setAttribute("errorType", BuyVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.buyVouchersWithStatus(string, buyVoucher, string2);
    }

    @RequestMapping(value={"/api/vouchers/{key}/cancel"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> cancelVoucher(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/{key}/cancel");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.cancelVoucher(string, string2);
    }

    @RequestMapping(value={"/api/vouchers/{key}/change-expiration"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> changeVoucherExpirationDate(@PathVariable(value="key") String string, @RequestBody(required=true) ChangeVoucherExpirationDate changeVoucherExpirationDate, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/{key}/change-expiration");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.changeVoucherExpirationDate(string, changeVoucherExpirationDate, string2);
    }

    @RequestMapping(value={"/api/vouchers/{key}/change-notification-settings"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> changeVoucherNotificationSettings(@PathVariable(value="key") String string, @RequestBody(required=true) ChangeVoucherNotificationSettings changeVoucherNotificationSettings, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/{key}/change-notification-settings");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.changeVoucherNotificationSettings(string, changeVoucherNotificationSettings, string2);
    }

    @RequestMapping(value={"/api/vouchers/{key}/change-pin"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> changeVoucherPin(@PathVariable(value="key") String string, @RequestBody(required=true) ChangeVoucherPin changeVoucherPin, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/{key}/change-pin");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.changeVoucherPin(string, changeVoucherPin, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportUserVouchers(@PathVariable(value="format") String string, @PathVariable(value="user") String string2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="creationType", required=false) VoucherCreationTypeEnum voucherCreationTypeEnum, @RequestParam(value="expirationPeriod", required=false) List<DateTime> list3, @RequestParam(value="orderBy", required=false) VoucherOrderByEnum voucherOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="redeemBy", required=false) String string3, @RequestParam(value="redeemPeriod", required=false) List<DateTime> list4, @RequestParam(value="relation", required=false) VoucherRelationEnum voucherRelationEnum, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="statuses", required=false) List<VoucherStatusEnum> list5, @RequestParam(value="token", required=false) String string4, @RequestParam(value="types", required=false) List<String> list6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportUserVouchersParams exportUserVouchersParams = new ExportUserVouchersParams();
        exportUserVouchersParams.format = string;
        exportUserVouchersParams.user = string2;
        exportUserVouchersParams.amountRange = list;
        exportUserVouchersParams.creationPeriod = list2;
        exportUserVouchersParams.creationType = voucherCreationTypeEnum;
        exportUserVouchersParams.expirationPeriod = list3;
        exportUserVouchersParams.orderBy = voucherOrderByEnum;
        exportUserVouchersParams.page = n;
        exportUserVouchersParams.pageSize = n2;
        exportUserVouchersParams.redeemBy = string3;
        exportUserVouchersParams.redeemPeriod = list4;
        exportUserVouchersParams.relation = voucherRelationEnum;
        exportUserVouchersParams.skipTotalCount = bl;
        exportUserVouchersParams.statuses = list5;
        exportUserVouchersParams.token = string4;
        exportUserVouchersParams.types = list6;
        return this.impl.exportUserVouchers(exportUserVouchersParams);
    }

    @RequestMapping(value={"/api/vouchers/{key}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportVoucher(@PathVariable(value="key") String string, @PathVariable(value="format") String string2, @RequestParam(value="markAsPrinted", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /vouchers/{key}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.exportVoucher(string, string2, bl);
    }

    @RequestMapping(value={"/api/voucher-transactions/{id}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportVoucherTransaction(@PathVariable(value="id") String string, @PathVariable(value="format") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /voucher-transactions/{id}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.exportVoucherTransaction(string, string2);
    }

    @RequestMapping(value={"/api/vouchers/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportVouchers(@PathVariable(value="format") String string, @RequestParam(value="amountRange", required=false) List<BigDecimal> list, @RequestParam(value="buyer", required=false) String string2, @RequestParam(value="buyerGroups", required=false) List<String> list2, @RequestParam(value="creationPeriod", required=false) List<DateTime> list3, @RequestParam(value="creationType", required=false) VoucherCreationTypeEnum voucherCreationTypeEnum, @RequestParam(value="customFields", required=false) List<String> list4, @RequestParam(value="email", required=false) String string3, @RequestParam(value="expirationPeriod", required=false) List<DateTime> list5, @RequestParam(value="mobilePhone", required=false) String string4, @RequestParam(value="orderBy", required=false) VoucherOrderByEnum voucherOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="printed", required=false) Boolean bl, @RequestParam(value="redeemPeriod", required=false) List<DateTime> list6, @RequestParam(value="redeemer", required=false) String string5, @RequestParam(value="redeemerGroups", required=false) List<String> list7, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, @RequestParam(value="statuses", required=false) List<VoucherStatusEnum> list8, @RequestParam(value="token", required=false) String string6, @RequestParam(value="transactionPeriod", required=false) List<DateTime> list9, @RequestParam(value="transactionUser", required=false) String string7, @RequestParam(value="transactionUserGroups", required=false) List<String> list10, @RequestParam(value="types", required=false) List<String> list11, @RequestParam(value="markAsPrinted", required=false) Boolean bl3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /vouchers/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportVouchersParams exportVouchersParams = new ExportVouchersParams();
        exportVouchersParams.format = string;
        exportVouchersParams.amountRange = list;
        exportVouchersParams.buyer = string2;
        exportVouchersParams.buyerGroups = list2;
        exportVouchersParams.creationPeriod = list3;
        exportVouchersParams.creationType = voucherCreationTypeEnum;
        exportVouchersParams.customFields = list4;
        exportVouchersParams.email = string3;
        exportVouchersParams.expirationPeriod = list5;
        exportVouchersParams.mobilePhone = string4;
        exportVouchersParams.orderBy = voucherOrderByEnum;
        exportVouchersParams.page = n;
        exportVouchersParams.pageSize = n2;
        exportVouchersParams.printed = bl;
        exportVouchersParams.redeemPeriod = list6;
        exportVouchersParams.redeemer = string5;
        exportVouchersParams.redeemerGroups = list7;
        exportVouchersParams.skipTotalCount = bl2;
        exportVouchersParams.statuses = list8;
        exportVouchersParams.token = string6;
        exportVouchersParams.transactionPeriod = list9;
        exportVouchersParams.transactionUser = string7;
        exportVouchersParams.transactionUserGroups = list10;
        exportVouchersParams.types = list11;
        exportVouchersParams.markAsPrinted = bl3;
        return this.impl.exportVouchers(exportVouchersParams);
    }

    @RequestMapping(value={"/api/vouchers/generate"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<List<String>> generateVouchers(@RequestBody(required=true) GenerateVoucher generateVoucher, @RequestHeader(value="confirmationPassword", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/generate");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.generateVouchers(generateVoucher, string);
    }

    @RequestMapping(value={"/api/vouchers/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<GeneralVouchersDataForSearch> getGeneralVouchersDataForSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /vouchers/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getGeneralVouchersDataForSearch(list);
    }

    @RequestMapping(value={"/api/{user:.*}/voucher-transactions/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserVoucherTransactionsDataForSearch> getUserVoucherTransactionsDataForSearch(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/voucher-transactions/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserVoucherTransactionsDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserVouchersDataForSearch> getUserVouchersDataForSearch(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="relation", required=false) VoucherRelationEnum voucherRelationEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserVouchersDataForSearch(string, list, voucherRelationEnum);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/data-for-buy"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherDataForBuy> getVoucherDataForBuy(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="type", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers/data-for-buy");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getVoucherDataForBuy(string, list, string2);
    }

    @RequestMapping(value={"/api/vouchers/data-for-generate"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherDataForGenerate> getVoucherDataForGenerate(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="user", required=false) String string, @RequestParam(value="type", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /vouchers/data-for-generate");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getVoucherDataForGenerate(list, string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/{token}/data-for-redeem"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherDataForRedeem> getVoucherDataForRedeem(@PathVariable(value="user") String string, @PathVariable(value="token") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers/{token}/data-for-redeem");
        httpServletRequest.setAttribute("errorType", RedeemVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getVoucherDataForRedeem(string, string2, list);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/data-for-send"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherDataForBuy> getVoucherDataForSend(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="type", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers/data-for-send");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getVoucherDataForSend(string, list, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/{token}/data-for-top-up"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherDataForTopUp> getVoucherDataForTopUp(@PathVariable(value="user") String string, @PathVariable(value="token") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers/{token}/data-for-top-up");
        httpServletRequest.setAttribute("errorType", TopUpVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getVoucherDataForTopUp(string, string2, list);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/data-for-redeem"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherInitialDataForTransaction> getVoucherInitialDataForRedeem(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers/data-for-redeem");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getVoucherInitialDataForRedeem(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/data-for-top-up"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherInitialDataForTransaction> getVoucherInitialDataForTopUp(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers/data-for-top-up");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getVoucherInitialDataForTopUp(string, list);
    }

    @RequestMapping(value={"/api/vouchers/{key}/qr-code"}, produces={"image/png", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getVoucherQrCode(@PathVariable(value="key") String string, @RequestParam(value="size", required=false) ImageSizeEnum imageSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /vouchers/{key}/qr-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getVoucherQrCode(string, imageSizeEnum);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/preview-buy"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<VoucherBuyingPreview> previewBuyVouchers(@PathVariable(value="user") String string, @RequestBody(required=true) BuyVoucher buyVoucher, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/preview-buy");
        httpServletRequest.setAttribute("errorType", BuyVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.previewBuyVouchers(string, buyVoucher, list);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/preview-send"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<VoucherSendingPreview> previewSendVoucher(@PathVariable(value="user") String string, @RequestBody(required=true) SendVoucher sendVoucher, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/preview-send");
        httpServletRequest.setAttribute("errorType", BuyVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.previewSendVoucher(string, sendVoucher, list);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/{token}/preview-redeem"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<VoucherRedeemPreview> previewVoucherRedeem(@PathVariable(value="user") String string, @PathVariable(value="token") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RedeemVoucher redeemVoucher, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/{token}/preview-redeem");
        httpServletRequest.setAttribute("errorType", RedeemVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        PreviewVoucherRedeemParams previewVoucherRedeemParams = new PreviewVoucherRedeemParams();
        previewVoucherRedeemParams.user = string;
        previewVoucherRedeemParams.token = string2;
        previewVoucherRedeemParams.fields = list;
        previewVoucherRedeemParams.redeemVoucher = redeemVoucher;
        return this.impl.previewVoucherRedeem(previewVoucherRedeemParams);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/{token}/preview-top-up"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<VoucherTopUpPreview> previewVoucherTopUp(@PathVariable(value="user") String string, @PathVariable(value="token") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) TopUpVoucher topUpVoucher, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/{token}/preview-top-up");
        httpServletRequest.setAttribute("errorType", TopUpVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        PreviewVoucherTopUpParams previewVoucherTopUpParams = new PreviewVoucherTopUpParams();
        previewVoucherTopUpParams.user = string;
        previewVoucherTopUpParams.token = string2;
        previewVoucherTopUpParams.fields = list;
        previewVoucherTopUpParams.topUpVoucher = topUpVoucher;
        return this.impl.previewVoucherTopUp(previewVoucherTopUpParams);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/{token}/redeem"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<VoucherRedeemResult> redeemVoucher(@PathVariable(value="user") String string, @PathVariable(value="token") String string2, @RequestBody(required=false) RedeemVoucher redeemVoucher, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/{token}/redeem");
        httpServletRequest.setAttribute("errorType", RedeemVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.redeemVoucher(string, string2, redeemVoucher);
    }

    @RequestMapping(value={"/api/vouchers/{key}/resend-pin"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<List<String>> resendPin(@PathVariable(value="key") String string, @RequestParam(value="user", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/{key}/resend-pin");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.resendPin(string, string2);
    }

    @RequestMapping(value={"/api/vouchers/{key}/resend-email"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> resendVoucherEmail(@PathVariable(value="key") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/{key}/resend-email");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.resendVoucherEmail(string);
    }

    @RequestMapping(value={"/api/{user:.*}/voucher-transactions"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<VoucherTransactionResult>> searchUserVoucherTransactions(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="amountRange", required=false) List<BigDecimal> list2, @RequestParam(value="by", required=false) String string2, @RequestParam(value="datePeriod", required=false) List<DateTime> list3, @RequestParam(value="kind", required=false) VoucherTransactionKind voucherTransactionKind, @RequestParam(value="kinds", required=false) List<VoucherTransactionKind> list4, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="types", required=false) List<String> list5, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/voucher-transactions");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUserVoucherTransactionsParams searchUserVoucherTransactionsParams = new SearchUserVoucherTransactionsParams();
        searchUserVoucherTransactionsParams.user = string;
        searchUserVoucherTransactionsParams.fields = list;
        searchUserVoucherTransactionsParams.amountRange = list2;
        searchUserVoucherTransactionsParams.by = string2;
        searchUserVoucherTransactionsParams.datePeriod = list3;
        searchUserVoucherTransactionsParams.kind = voucherTransactionKind;
        searchUserVoucherTransactionsParams.kinds = list4;
        searchUserVoucherTransactionsParams.page = n;
        searchUserVoucherTransactionsParams.pageSize = n2;
        searchUserVoucherTransactionsParams.skipTotalCount = bl;
        searchUserVoucherTransactionsParams.types = list5;
        return this.impl.searchUserVoucherTransactions(searchUserVoucherTransactionsParams);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<VoucherResult>> searchUserVouchers(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="amountRange", required=false) List<BigDecimal> list2, @RequestParam(value="creationPeriod", required=false) List<DateTime> list3, @RequestParam(value="creationType", required=false) VoucherCreationTypeEnum voucherCreationTypeEnum, @RequestParam(value="expirationPeriod", required=false) List<DateTime> list4, @RequestParam(value="orderBy", required=false) VoucherOrderByEnum voucherOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="redeemBy", required=false) String string2, @RequestParam(value="redeemPeriod", required=false) List<DateTime> list5, @RequestParam(value="relation", required=false) VoucherRelationEnum voucherRelationEnum, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="statuses", required=false) List<VoucherStatusEnum> list6, @RequestParam(value="token", required=false) String string3, @RequestParam(value="types", required=false) List<String> list7, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/vouchers");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUserVouchersParams searchUserVouchersParams = new SearchUserVouchersParams();
        searchUserVouchersParams.user = string;
        searchUserVouchersParams.fields = list;
        searchUserVouchersParams.amountRange = list2;
        searchUserVouchersParams.creationPeriod = list3;
        searchUserVouchersParams.creationType = voucherCreationTypeEnum;
        searchUserVouchersParams.expirationPeriod = list4;
        searchUserVouchersParams.orderBy = voucherOrderByEnum;
        searchUserVouchersParams.page = n;
        searchUserVouchersParams.pageSize = n2;
        searchUserVouchersParams.redeemBy = string2;
        searchUserVouchersParams.redeemPeriod = list5;
        searchUserVouchersParams.relation = voucherRelationEnum;
        searchUserVouchersParams.skipTotalCount = bl;
        searchUserVouchersParams.statuses = list6;
        searchUserVouchersParams.token = string3;
        searchUserVouchersParams.types = list7;
        return this.impl.searchUserVouchers(searchUserVouchersParams);
    }

    @RequestMapping(value={"/api/vouchers/{key}/transactions"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<VoucherTransaction>> searchVoucherTransactions(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /vouchers/{key}/transactions");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchVoucherTransactionsParams searchVoucherTransactionsParams = new SearchVoucherTransactionsParams();
        searchVoucherTransactionsParams.key = string;
        searchVoucherTransactionsParams.fields = list;
        searchVoucherTransactionsParams.page = n;
        searchVoucherTransactionsParams.pageSize = n2;
        searchVoucherTransactionsParams.skipTotalCount = bl;
        return this.impl.searchVoucherTransactions(searchVoucherTransactionsParams);
    }

    @RequestMapping(value={"/api/vouchers"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<VoucherResult>> searchVouchers(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="amountRange", required=false) List<BigDecimal> list2, @RequestParam(value="buyer", required=false) String string, @RequestParam(value="buyerGroups", required=false) List<String> list3, @RequestParam(value="creationPeriod", required=false) List<DateTime> list4, @RequestParam(value="creationType", required=false) VoucherCreationTypeEnum voucherCreationTypeEnum, @RequestParam(value="customFields", required=false) List<String> list5, @RequestParam(value="email", required=false) String string2, @RequestParam(value="expirationPeriod", required=false) List<DateTime> list6, @RequestParam(value="mobilePhone", required=false) String string3, @RequestParam(value="orderBy", required=false) VoucherOrderByEnum voucherOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="printed", required=false) Boolean bl, @RequestParam(value="redeemPeriod", required=false) List<DateTime> list7, @RequestParam(value="redeemer", required=false) String string4, @RequestParam(value="redeemerGroups", required=false) List<String> list8, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, @RequestParam(value="statuses", required=false) List<VoucherStatusEnum> list9, @RequestParam(value="token", required=false) String string5, @RequestParam(value="transactionPeriod", required=false) List<DateTime> list10, @RequestParam(value="transactionUser", required=false) String string6, @RequestParam(value="transactionUserGroups", required=false) List<String> list11, @RequestParam(value="types", required=false) List<String> list12, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /vouchers");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchVouchersParams searchVouchersParams = new SearchVouchersParams();
        searchVouchersParams.fields = list;
        searchVouchersParams.amountRange = list2;
        searchVouchersParams.buyer = string;
        searchVouchersParams.buyerGroups = list3;
        searchVouchersParams.creationPeriod = list4;
        searchVouchersParams.creationType = voucherCreationTypeEnum;
        searchVouchersParams.customFields = list5;
        searchVouchersParams.email = string2;
        searchVouchersParams.expirationPeriod = list6;
        searchVouchersParams.mobilePhone = string3;
        searchVouchersParams.orderBy = voucherOrderByEnum;
        searchVouchersParams.page = n;
        searchVouchersParams.pageSize = n2;
        searchVouchersParams.printed = bl;
        searchVouchersParams.redeemPeriod = list7;
        searchVouchersParams.redeemer = string4;
        searchVouchersParams.redeemerGroups = list8;
        searchVouchersParams.skipTotalCount = bl2;
        searchVouchersParams.statuses = list9;
        searchVouchersParams.token = string5;
        searchVouchersParams.transactionPeriod = list10;
        searchVouchersParams.transactionUser = string6;
        searchVouchersParams.transactionUserGroups = list11;
        searchVouchersParams.types = list12;
        return this.impl.searchVouchers(searchVouchersParams);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/send"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<VoucherBoughtResult> sendVoucher(@PathVariable(value="user") String string, @RequestBody(required=true) SendVoucher sendVoucher, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/send");
        httpServletRequest.setAttribute("errorType", BuyVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.sendVoucher(string, sendVoucher, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/vouchers/{token}/top-up"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<VoucherTransactionResult> topUpVoucher(@PathVariable(value="user") String string, @PathVariable(value="token") String string2, @RequestHeader(value="confirmationPassword", required=false) String string3, @RequestBody(required=false) TopUpVoucher topUpVoucher, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/vouchers/{token}/top-up");
        httpServletRequest.setAttribute("errorType", TopUpVoucherError.class);
        ServletHelper.denyGuest(httpServletRequest);
        TopUpVoucherParams topUpVoucherParams = new TopUpVoucherParams();
        topUpVoucherParams.user = string;
        topUpVoucherParams.token = string2;
        topUpVoucherParams.confirmationPassword = string3;
        topUpVoucherParams.topUpVoucher = topUpVoucher;
        return this.impl.topUpVoucher(topUpVoucherParams);
    }

    @RequestMapping(value={"/api/vouchers/{key}/unblock-pin"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> unblockVoucherPin(@PathVariable(value="key") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /vouchers/{key}/unblock-pin");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.unblockVoucherPin(string);
    }

    @RequestMapping(value={"/api/vouchers/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherView> viewVoucher(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /vouchers/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewVoucher(string, list);
    }

    @RequestMapping(value={"/api/voucher-transactions/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<VoucherTransactionView> viewVoucherTransaction(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /voucher-transactions/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewVoucherTransaction(string, list);
    }

    public static class ExportUserVouchersParams {
        public String format;
        public static final String FORMAT = "format";
        public String user;
        public static final String USER = "user";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public VoucherCreationTypeEnum creationType;
        public static final String CREATION_TYPE = "creationType";
        public List<DateTime> expirationPeriod;
        public static final String EXPIRATION_PERIOD = "expirationPeriod";
        public VoucherOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public String redeemBy;
        public static final String REDEEM_BY = "redeemBy";
        public List<DateTime> redeemPeriod;
        public static final String REDEEM_PERIOD = "redeemPeriod";
        public VoucherRelationEnum relation;
        public static final String RELATION = "relation";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<VoucherStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public String token;
        public static final String TOKEN = "token";
        public List<String> types;
        public static final String TYPES = "types";
    }

    public static class ExportVouchersParams {
        public String format;
        public static final String FORMAT = "format";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String buyer;
        public static final String BUYER = "buyer";
        public List<String> buyerGroups;
        public static final String BUYER_GROUPS = "buyerGroups";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public VoucherCreationTypeEnum creationType;
        public static final String CREATION_TYPE = "creationType";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public String email;
        public static final String EMAIL = "email";
        public List<DateTime> expirationPeriod;
        public static final String EXPIRATION_PERIOD = "expirationPeriod";
        public String mobilePhone;
        public static final String MOBILE_PHONE = "mobilePhone";
        public VoucherOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean printed;
        public static final String PRINTED = "printed";
        public List<DateTime> redeemPeriod;
        public static final String REDEEM_PERIOD = "redeemPeriod";
        public String redeemer;
        public static final String REDEEMER = "redeemer";
        public List<String> redeemerGroups;
        public static final String REDEEMER_GROUPS = "redeemerGroups";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<VoucherStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public String token;
        public static final String TOKEN = "token";
        public List<DateTime> transactionPeriod;
        public static final String TRANSACTION_PERIOD = "transactionPeriod";
        public String transactionUser;
        public static final String TRANSACTION_USER = "transactionUser";
        public List<String> transactionUserGroups;
        public static final String TRANSACTION_USER_GROUPS = "transactionUserGroups";
        public List<String> types;
        public static final String TYPES = "types";
        public Boolean markAsPrinted;
        public static final String MARK_AS_PRINTED = "markAsPrinted";
    }

    public static class PreviewVoucherRedeemParams {
        public String user;
        public static final String USER = "user";
        public String token;
        public static final String TOKEN = "token";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RedeemVoucher redeemVoucher;
        public static final String REDEEM_VOUCHER = "redeemVoucher";
    }

    public static class PreviewVoucherTopUpParams {
        public String user;
        public static final String USER = "user";
        public String token;
        public static final String TOKEN = "token";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public TopUpVoucher topUpVoucher;
        public static final String TOP_UP_VOUCHER = "topUpVoucher";
    }

    public static class SearchUserVoucherTransactionsParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String by;
        public static final String BY = "by";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public VoucherTransactionKind kind;
        public static final String KIND = "kind";
        public List<VoucherTransactionKind> kinds;
        public static final String KINDS = "kinds";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<String> types;
        public static final String TYPES = "types";
    }

    public static class SearchUserVouchersParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public VoucherCreationTypeEnum creationType;
        public static final String CREATION_TYPE = "creationType";
        public List<DateTime> expirationPeriod;
        public static final String EXPIRATION_PERIOD = "expirationPeriod";
        public VoucherOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public String redeemBy;
        public static final String REDEEM_BY = "redeemBy";
        public List<DateTime> redeemPeriod;
        public static final String REDEEM_PERIOD = "redeemPeriod";
        public VoucherRelationEnum relation;
        public static final String RELATION = "relation";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<VoucherStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public String token;
        public static final String TOKEN = "token";
        public List<String> types;
        public static final String TYPES = "types";
    }

    public static class SearchVoucherTransactionsParams {
        public String key;
        public static final String KEY = "key";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }

    public static class SearchVouchersParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String buyer;
        public static final String BUYER = "buyer";
        public List<String> buyerGroups;
        public static final String BUYER_GROUPS = "buyerGroups";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public VoucherCreationTypeEnum creationType;
        public static final String CREATION_TYPE = "creationType";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public String email;
        public static final String EMAIL = "email";
        public List<DateTime> expirationPeriod;
        public static final String EXPIRATION_PERIOD = "expirationPeriod";
        public String mobilePhone;
        public static final String MOBILE_PHONE = "mobilePhone";
        public VoucherOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean printed;
        public static final String PRINTED = "printed";
        public List<DateTime> redeemPeriod;
        public static final String REDEEM_PERIOD = "redeemPeriod";
        public String redeemer;
        public static final String REDEEMER = "redeemer";
        public List<String> redeemerGroups;
        public static final String REDEEMER_GROUPS = "redeemerGroups";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<VoucherStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public String token;
        public static final String TOKEN = "token";
        public List<DateTime> transactionPeriod;
        public static final String TRANSACTION_PERIOD = "transactionPeriod";
        public String transactionUser;
        public static final String TRANSACTION_USER = "transactionUser";
        public List<String> transactionUserGroups;
        public static final String TRANSACTION_USER_GROUPS = "transactionUserGroups";
        public List<String> types;
        public static final String TYPES = "types";
    }

    public static class TopUpVoucherParams {
        public String user;
        public static final String USER = "user";
        public String token;
        public static final String TOKEN = "token";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
        public TopUpVoucher topUpVoucher;
        public static final String TOP_UP_VOUCHER = "topUpVoucher";
    }
}

