/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.ValidationApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserRegistrationResult;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(produces={"application/json"})
public class ValidationApi {
    @Autowired
    private ValidationApiImpl impl;
    public static final String MANUALLY_VALIDATE_EMAIL_CHANGE = "/{user}/email-change/validate";
    public static final String MANUALLY_VALIDATE_USER_REGISTRATION = "/{user}/registration/validate";
    public static final String RESEND_EMAIL_CHANGE_EMAIL = "/{user}/email-change/resend";
    public static final String RESEND_USER_REGISTRATION_EMAIL = "/{user}/registration/resend";
    public static final String VALIDATE_EMAIL_CHANGE = "/validate/email-change/{key}";
    public static final String VALIDATE_USER_REGISTRATION = "/validate/registration/{key}";

    @RequestMapping(value={"/api/{user:.*}/email-change/validate"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> manuallyValidateEmailChange(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/email-change/validate");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.manuallyValidateEmailChange(string);
    }

    @RequestMapping(value={"/api/{user:.*}/registration/validate"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<UserRegistrationResult> manuallyValidateUserRegistration(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/registration/validate");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.manuallyValidateUserRegistration(string);
    }

    @RequestMapping(value={"/api/{user:.*}/email-change/resend"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> resendEmailChangeEmail(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/email-change/resend");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.resendEmailChangeEmail(string);
    }

    @RequestMapping(value={"/api/{user:.*}/registration/resend"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> resendUserRegistrationEmail(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/registration/resend");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.resendUserRegistrationEmail(string);
    }

    @RequestMapping(value={"/api/validate/email-change/{key}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> validateEmailChange(@PathVariable(value="key") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /validate/email-change/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.validateEmailChange(string);
    }

    @RequestMapping(value={"/api/validate/registration/{key}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<UserRegistrationResult> validateUserRegistration(@PathVariable(value="key") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /validate/registration/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.validateUserRegistration(string);
    }
}

