/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.TransactionsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ExternalPaymentStatusEnum;
import org.cyclos.web.rest.model.PaymentCreationTypeEnum;
import org.cyclos.web.rest.model.PaymentRequestStatusEnum;
import org.cyclos.web.rest.model.RecurringPaymentStatusEnum;
import org.cyclos.web.rest.model.ScheduledPaymentStatusEnum;
import org.cyclos.web.rest.model.TicketStatusEnum;
import org.cyclos.web.rest.model.TransOrderByEnum;
import org.cyclos.web.rest.model.TransactionAuthorizationStatusEnum;
import org.cyclos.web.rest.model.TransactionDataForSearch;
import org.cyclos.web.rest.model.TransactionKind;
import org.cyclos.web.rest.model.TransactionOverviewDataForSearch;
import org.cyclos.web.rest.model.TransactionOverviewResult;
import org.cyclos.web.rest.model.TransactionResult;
import org.cyclos.web.rest.model.TransactionView;
import org.cyclos.web.rest.model.TransferDirectionEnum;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class TransactionsApi {
    @Autowired
    private TransactionsApiImpl impl;
    public static final String EXPORT_TRANSACTION = "/transactions/{key}/export/{format}";
    public static final String EXPORT_TRANSACTIONS = "/{owner}/transactions/export/{format}";
    public static final String EXPORT_TRANSACTIONS_OVERVIEW = "/transactions/export/{format}";
    public static final String GET_TRANSACTIONS_DATA_FOR_SEARCH = "/{owner}/transactions/data-for-search";
    public static final String GET_TRANSACTIONS_OVERVIEW_DATA_FOR_SEARCH = "/transactions/data-for-search";
    public static final String SEARCH_TRANSACTIONS = "/{owner}/transactions";
    public static final String SEARCH_TRANSACTIONS_OVERVIEW = "/transactions";
    public static final String VIEW_TRANSACTION = "/transactions/{key}";

    @RequestMapping(value={"/api/transactions/{key}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportTransaction(@PathVariable(value="key") String string, @PathVariable(value="format") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transactions/{key}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.exportTransaction(string, string2);
    }

    @RequestMapping(value={"/api/{owner:.*}/transactions/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportTransactions(@PathVariable(value="owner") String string, @PathVariable(value="format") String string2, @RequestParam(value="accessClients", required=false) List<String> list, @RequestParam(value="accountTypes", required=false) List<String> list2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list3, @RequestParam(value="authorizationPerformedBy", required=false) String string3, @RequestParam(value="authorizationRoles", required=false) List<String> list4, @RequestParam(value="authorizationStatuses", required=false) List<TransactionAuthorizationStatusEnum> list5, @RequestParam(value="authorized", required=false) Boolean bl, @RequestParam(value="brokers", required=false) List<String> list6, @RequestParam(value="by", required=false) String string4, @RequestParam(value="channels", required=false) List<String> list7, @RequestParam(value="creationTypes", required=false) List<PaymentCreationTypeEnum> list8, @RequestParam(value="customFields", required=false) List<String> list9, @RequestParam(value="datePeriod", required=false) List<DateTime> list10, @RequestParam(value="direction", required=false) TransferDirectionEnum transferDirectionEnum, @RequestParam(value="excludedIds", required=false) List<String> list11, @RequestParam(value="externalPaymentExpiration", required=false) List<DateTime> list12, @RequestParam(value="externalPaymentStatuses", required=false) List<ExternalPaymentStatusEnum> list13, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list14, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransactionKind> list15, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="paymentRequestExpiration", required=false) List<DateTime> list16, @RequestParam(value="paymentRequestStatuses", required=false) List<PaymentRequestStatusEnum> list17, @RequestParam(value="recurringPaymentStatuses", required=false) List<RecurringPaymentStatusEnum> list18, @RequestParam(value="scheduledPaymentStatuses", required=false) List<ScheduledPaymentStatusEnum> list19, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="ticketExpiration", required=false) List<DateTime> list20, @RequestParam(value="ticketStatuses", required=false) List<TicketStatusEnum> list21, @RequestParam(value="transactionNumber", required=false) String string5, @RequestParam(value="transferFilters", required=false) List<String> list22, @RequestParam(value="transferTypes", required=false) List<String> list23, @RequestParam(value="user", required=false) String string6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/transactions/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportTransactionsParams exportTransactionsParams = new ExportTransactionsParams();
        exportTransactionsParams.owner = string;
        exportTransactionsParams.format = string2;
        exportTransactionsParams.accessClients = list;
        exportTransactionsParams.accountTypes = list2;
        exportTransactionsParams.amountRange = list3;
        exportTransactionsParams.authorizationPerformedBy = string3;
        exportTransactionsParams.authorizationRoles = list4;
        exportTransactionsParams.authorizationStatuses = list5;
        exportTransactionsParams.authorized = bl;
        exportTransactionsParams.brokers = list6;
        exportTransactionsParams.by = string4;
        exportTransactionsParams.channels = list7;
        exportTransactionsParams.creationTypes = list8;
        exportTransactionsParams.customFields = list9;
        exportTransactionsParams.datePeriod = list10;
        exportTransactionsParams.direction = transferDirectionEnum;
        exportTransactionsParams.excludedIds = list11;
        exportTransactionsParams.externalPaymentExpiration = list12;
        exportTransactionsParams.externalPaymentStatuses = list13;
        exportTransactionsParams.fromCurrentAccessClient = bl2;
        exportTransactionsParams.groups = list14;
        exportTransactionsParams.includeGeneratedByAccessClient = bl3;
        exportTransactionsParams.kinds = list15;
        exportTransactionsParams.orderBy = transOrderByEnum;
        exportTransactionsParams.page = n;
        exportTransactionsParams.pageSize = n2;
        exportTransactionsParams.paymentRequestExpiration = list16;
        exportTransactionsParams.paymentRequestStatuses = list17;
        exportTransactionsParams.recurringPaymentStatuses = list18;
        exportTransactionsParams.scheduledPaymentStatuses = list19;
        exportTransactionsParams.skipTotalCount = bl4;
        exportTransactionsParams.ticketExpiration = list20;
        exportTransactionsParams.ticketStatuses = list21;
        exportTransactionsParams.transactionNumber = string5;
        exportTransactionsParams.transferFilters = list22;
        exportTransactionsParams.transferTypes = list23;
        exportTransactionsParams.user = string6;
        return this.impl.exportTransactions(exportTransactionsParams);
    }

    @RequestMapping(value={"/api/transactions/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportTransactionsOverview(@PathVariable(value="format") String string, @RequestParam(value="accessClients", required=false) List<String> list, @RequestParam(value="amountRange", required=false) List<BigDecimal> list2, @RequestParam(value="authorizationPerformedBy", required=false) String string2, @RequestParam(value="authorizationRoles", required=false) List<String> list3, @RequestParam(value="authorizationStatuses", required=false) List<TransactionAuthorizationStatusEnum> list4, @RequestParam(value="authorized", required=false) Boolean bl, @RequestParam(value="brokers", required=false) List<String> list5, @RequestParam(value="by", required=false) String string3, @RequestParam(value="channels", required=false) List<String> list6, @RequestParam(value="creationTypes", required=false) List<PaymentCreationTypeEnum> list7, @RequestParam(value="currencies", required=false) List<String> list8, @RequestParam(value="customFields", required=false) List<String> list9, @RequestParam(value="datePeriod", required=false) List<DateTime> list10, @RequestParam(value="excludedIds", required=false) List<String> list11, @RequestParam(value="externalPaymentExpiration", required=false) List<DateTime> list12, @RequestParam(value="externalPaymentStatuses", required=false) List<ExternalPaymentStatusEnum> list13, @RequestParam(value="fromAccountTypes", required=false) List<String> list14, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list15, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransactionKind> list16, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="paymentRequestExpiration", required=false) List<DateTime> list17, @RequestParam(value="paymentRequestStatuses", required=false) List<PaymentRequestStatusEnum> list18, @RequestParam(value="pendingMyAuthorization", required=false) Boolean bl4, @RequestParam(value="recurringPaymentStatuses", required=false) List<RecurringPaymentStatusEnum> list19, @RequestParam(value="scheduledPaymentStatuses", required=false) List<ScheduledPaymentStatusEnum> list20, @RequestParam(value="skipTotalCount", required=false) Boolean bl5, @RequestParam(value="ticketExpiration", required=false) List<DateTime> list21, @RequestParam(value="ticketStatuses", required=false) List<TicketStatusEnum> list22, @RequestParam(value="toAccountTypes", required=false) List<String> list23, @RequestParam(value="transactionNumber", required=false) String string4, @RequestParam(value="transferFilters", required=false) List<String> list24, @RequestParam(value="transferTypes", required=false) List<String> list25, @RequestParam(value="user", required=false) String string5, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transactions/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportTransactionsOverviewParams exportTransactionsOverviewParams = new ExportTransactionsOverviewParams();
        exportTransactionsOverviewParams.format = string;
        exportTransactionsOverviewParams.accessClients = list;
        exportTransactionsOverviewParams.amountRange = list2;
        exportTransactionsOverviewParams.authorizationPerformedBy = string2;
        exportTransactionsOverviewParams.authorizationRoles = list3;
        exportTransactionsOverviewParams.authorizationStatuses = list4;
        exportTransactionsOverviewParams.authorized = bl;
        exportTransactionsOverviewParams.brokers = list5;
        exportTransactionsOverviewParams.by = string3;
        exportTransactionsOverviewParams.channels = list6;
        exportTransactionsOverviewParams.creationTypes = list7;
        exportTransactionsOverviewParams.currencies = list8;
        exportTransactionsOverviewParams.customFields = list9;
        exportTransactionsOverviewParams.datePeriod = list10;
        exportTransactionsOverviewParams.excludedIds = list11;
        exportTransactionsOverviewParams.externalPaymentExpiration = list12;
        exportTransactionsOverviewParams.externalPaymentStatuses = list13;
        exportTransactionsOverviewParams.fromAccountTypes = list14;
        exportTransactionsOverviewParams.fromCurrentAccessClient = bl2;
        exportTransactionsOverviewParams.groups = list15;
        exportTransactionsOverviewParams.includeGeneratedByAccessClient = bl3;
        exportTransactionsOverviewParams.kinds = list16;
        exportTransactionsOverviewParams.orderBy = transOrderByEnum;
        exportTransactionsOverviewParams.page = n;
        exportTransactionsOverviewParams.pageSize = n2;
        exportTransactionsOverviewParams.paymentRequestExpiration = list17;
        exportTransactionsOverviewParams.paymentRequestStatuses = list18;
        exportTransactionsOverviewParams.pendingMyAuthorization = bl4;
        exportTransactionsOverviewParams.recurringPaymentStatuses = list19;
        exportTransactionsOverviewParams.scheduledPaymentStatuses = list20;
        exportTransactionsOverviewParams.skipTotalCount = bl5;
        exportTransactionsOverviewParams.ticketExpiration = list21;
        exportTransactionsOverviewParams.ticketStatuses = list22;
        exportTransactionsOverviewParams.toAccountTypes = list23;
        exportTransactionsOverviewParams.transactionNumber = string4;
        exportTransactionsOverviewParams.transferFilters = list24;
        exportTransactionsOverviewParams.transferTypes = list25;
        exportTransactionsOverviewParams.user = string5;
        return this.impl.exportTransactionsOverview(exportTransactionsOverviewParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/transactions/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TransactionDataForSearch> getTransactionsDataForSearch(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/transactions/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getTransactionsDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/transactions/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TransactionOverviewDataForSearch> getTransactionsOverviewDataForSearch(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="pendingMyAuthorization", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transactions/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getTransactionsOverviewDataForSearch(list, bl);
    }

    @RequestMapping(value={"/api/{owner:.*}/transactions"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<TransactionResult>> searchTransactions(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accessClients", required=false) List<String> list2, @RequestParam(value="accountTypes", required=false) List<String> list3, @RequestParam(value="amountRange", required=false) List<BigDecimal> list4, @RequestParam(value="authorizationPerformedBy", required=false) String string2, @RequestParam(value="authorizationRoles", required=false) List<String> list5, @RequestParam(value="authorizationStatuses", required=false) List<TransactionAuthorizationStatusEnum> list6, @RequestParam(value="authorized", required=false) Boolean bl, @RequestParam(value="brokers", required=false) List<String> list7, @RequestParam(value="by", required=false) String string3, @RequestParam(value="channels", required=false) List<String> list8, @RequestParam(value="creationTypes", required=false) List<PaymentCreationTypeEnum> list9, @RequestParam(value="customFields", required=false) List<String> list10, @RequestParam(value="datePeriod", required=false) List<DateTime> list11, @RequestParam(value="direction", required=false) TransferDirectionEnum transferDirectionEnum, @RequestParam(value="excludedIds", required=false) List<String> list12, @RequestParam(value="externalPaymentExpiration", required=false) List<DateTime> list13, @RequestParam(value="externalPaymentStatuses", required=false) List<ExternalPaymentStatusEnum> list14, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list15, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransactionKind> list16, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="paymentRequestExpiration", required=false) List<DateTime> list17, @RequestParam(value="paymentRequestStatuses", required=false) List<PaymentRequestStatusEnum> list18, @RequestParam(value="recurringPaymentStatuses", required=false) List<RecurringPaymentStatusEnum> list19, @RequestParam(value="scheduledPaymentStatuses", required=false) List<ScheduledPaymentStatusEnum> list20, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="ticketExpiration", required=false) List<DateTime> list21, @RequestParam(value="ticketStatuses", required=false) List<TicketStatusEnum> list22, @RequestParam(value="transactionNumber", required=false) String string4, @RequestParam(value="transferFilters", required=false) List<String> list23, @RequestParam(value="transferTypes", required=false) List<String> list24, @RequestParam(value="user", required=false) String string5, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/transactions");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchTransactionsParams searchTransactionsParams = new SearchTransactionsParams();
        searchTransactionsParams.owner = string;
        searchTransactionsParams.fields = list;
        searchTransactionsParams.accessClients = list2;
        searchTransactionsParams.accountTypes = list3;
        searchTransactionsParams.amountRange = list4;
        searchTransactionsParams.authorizationPerformedBy = string2;
        searchTransactionsParams.authorizationRoles = list5;
        searchTransactionsParams.authorizationStatuses = list6;
        searchTransactionsParams.authorized = bl;
        searchTransactionsParams.brokers = list7;
        searchTransactionsParams.by = string3;
        searchTransactionsParams.channels = list8;
        searchTransactionsParams.creationTypes = list9;
        searchTransactionsParams.customFields = list10;
        searchTransactionsParams.datePeriod = list11;
        searchTransactionsParams.direction = transferDirectionEnum;
        searchTransactionsParams.excludedIds = list12;
        searchTransactionsParams.externalPaymentExpiration = list13;
        searchTransactionsParams.externalPaymentStatuses = list14;
        searchTransactionsParams.fromCurrentAccessClient = bl2;
        searchTransactionsParams.groups = list15;
        searchTransactionsParams.includeGeneratedByAccessClient = bl3;
        searchTransactionsParams.kinds = list16;
        searchTransactionsParams.orderBy = transOrderByEnum;
        searchTransactionsParams.page = n;
        searchTransactionsParams.pageSize = n2;
        searchTransactionsParams.paymentRequestExpiration = list17;
        searchTransactionsParams.paymentRequestStatuses = list18;
        searchTransactionsParams.recurringPaymentStatuses = list19;
        searchTransactionsParams.scheduledPaymentStatuses = list20;
        searchTransactionsParams.skipTotalCount = bl4;
        searchTransactionsParams.ticketExpiration = list21;
        searchTransactionsParams.ticketStatuses = list22;
        searchTransactionsParams.transactionNumber = string4;
        searchTransactionsParams.transferFilters = list23;
        searchTransactionsParams.transferTypes = list24;
        searchTransactionsParams.user = string5;
        return this.impl.searchTransactions(searchTransactionsParams);
    }

    @RequestMapping(value={"/api/transactions"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<TransactionOverviewResult>> searchTransactionsOverview(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accessClients", required=false) List<String> list2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list3, @RequestParam(value="authorizationPerformedBy", required=false) String string, @RequestParam(value="authorizationRoles", required=false) List<String> list4, @RequestParam(value="authorizationStatuses", required=false) List<TransactionAuthorizationStatusEnum> list5, @RequestParam(value="authorized", required=false) Boolean bl, @RequestParam(value="brokers", required=false) List<String> list6, @RequestParam(value="by", required=false) String string2, @RequestParam(value="channels", required=false) List<String> list7, @RequestParam(value="creationTypes", required=false) List<PaymentCreationTypeEnum> list8, @RequestParam(value="currencies", required=false) List<String> list9, @RequestParam(value="customFields", required=false) List<String> list10, @RequestParam(value="datePeriod", required=false) List<DateTime> list11, @RequestParam(value="excludedIds", required=false) List<String> list12, @RequestParam(value="externalPaymentExpiration", required=false) List<DateTime> list13, @RequestParam(value="externalPaymentStatuses", required=false) List<ExternalPaymentStatusEnum> list14, @RequestParam(value="fromAccountTypes", required=false) List<String> list15, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list16, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransactionKind> list17, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="paymentRequestExpiration", required=false) List<DateTime> list18, @RequestParam(value="paymentRequestStatuses", required=false) List<PaymentRequestStatusEnum> list19, @RequestParam(value="pendingMyAuthorization", required=false) Boolean bl4, @RequestParam(value="recurringPaymentStatuses", required=false) List<RecurringPaymentStatusEnum> list20, @RequestParam(value="scheduledPaymentStatuses", required=false) List<ScheduledPaymentStatusEnum> list21, @RequestParam(value="skipTotalCount", required=false) Boolean bl5, @RequestParam(value="ticketExpiration", required=false) List<DateTime> list22, @RequestParam(value="ticketStatuses", required=false) List<TicketStatusEnum> list23, @RequestParam(value="toAccountTypes", required=false) List<String> list24, @RequestParam(value="transactionNumber", required=false) String string3, @RequestParam(value="transferFilters", required=false) List<String> list25, @RequestParam(value="transferTypes", required=false) List<String> list26, @RequestParam(value="user", required=false) String string4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transactions");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchTransactionsOverviewParams searchTransactionsOverviewParams = new SearchTransactionsOverviewParams();
        searchTransactionsOverviewParams.fields = list;
        searchTransactionsOverviewParams.accessClients = list2;
        searchTransactionsOverviewParams.amountRange = list3;
        searchTransactionsOverviewParams.authorizationPerformedBy = string;
        searchTransactionsOverviewParams.authorizationRoles = list4;
        searchTransactionsOverviewParams.authorizationStatuses = list5;
        searchTransactionsOverviewParams.authorized = bl;
        searchTransactionsOverviewParams.brokers = list6;
        searchTransactionsOverviewParams.by = string2;
        searchTransactionsOverviewParams.channels = list7;
        searchTransactionsOverviewParams.creationTypes = list8;
        searchTransactionsOverviewParams.currencies = list9;
        searchTransactionsOverviewParams.customFields = list10;
        searchTransactionsOverviewParams.datePeriod = list11;
        searchTransactionsOverviewParams.excludedIds = list12;
        searchTransactionsOverviewParams.externalPaymentExpiration = list13;
        searchTransactionsOverviewParams.externalPaymentStatuses = list14;
        searchTransactionsOverviewParams.fromAccountTypes = list15;
        searchTransactionsOverviewParams.fromCurrentAccessClient = bl2;
        searchTransactionsOverviewParams.groups = list16;
        searchTransactionsOverviewParams.includeGeneratedByAccessClient = bl3;
        searchTransactionsOverviewParams.kinds = list17;
        searchTransactionsOverviewParams.orderBy = transOrderByEnum;
        searchTransactionsOverviewParams.page = n;
        searchTransactionsOverviewParams.pageSize = n2;
        searchTransactionsOverviewParams.paymentRequestExpiration = list18;
        searchTransactionsOverviewParams.paymentRequestStatuses = list19;
        searchTransactionsOverviewParams.pendingMyAuthorization = bl4;
        searchTransactionsOverviewParams.recurringPaymentStatuses = list20;
        searchTransactionsOverviewParams.scheduledPaymentStatuses = list21;
        searchTransactionsOverviewParams.skipTotalCount = bl5;
        searchTransactionsOverviewParams.ticketExpiration = list22;
        searchTransactionsOverviewParams.ticketStatuses = list23;
        searchTransactionsOverviewParams.toAccountTypes = list24;
        searchTransactionsOverviewParams.transactionNumber = string3;
        searchTransactionsOverviewParams.transferFilters = list25;
        searchTransactionsOverviewParams.transferTypes = list26;
        searchTransactionsOverviewParams.user = string4;
        return this.impl.searchTransactionsOverview(searchTransactionsOverviewParams);
    }

    @RequestMapping(value={"/api/transactions/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TransactionView> viewTransaction(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transactions/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewTransaction(string, list);
    }

    public static class ExportTransactionsParams {
        public String owner;
        public static final String OWNER = "owner";
        public String format;
        public static final String FORMAT = "format";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<String> accountTypes;
        public static final String ACCOUNT_TYPES = "accountTypes";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String authorizationPerformedBy;
        public static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
        public List<String> authorizationRoles;
        public static final String AUTHORIZATION_ROLES = "authorizationRoles";
        public List<TransactionAuthorizationStatusEnum> authorizationStatuses;
        public static final String AUTHORIZATION_STATUSES = "authorizationStatuses";
        public Boolean authorized;
        public static final String AUTHORIZED = "authorized";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public List<PaymentCreationTypeEnum> creationTypes;
        public static final String CREATION_TYPES = "creationTypes";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public TransferDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<DateTime> externalPaymentExpiration;
        public static final String EXTERNAL_PAYMENT_EXPIRATION = "externalPaymentExpiration";
        public List<ExternalPaymentStatusEnum> externalPaymentStatuses;
        public static final String EXTERNAL_PAYMENT_STATUSES = "externalPaymentStatuses";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransactionKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<DateTime> paymentRequestExpiration;
        public static final String PAYMENT_REQUEST_EXPIRATION = "paymentRequestExpiration";
        public List<PaymentRequestStatusEnum> paymentRequestStatuses;
        public static final String PAYMENT_REQUEST_STATUSES = "paymentRequestStatuses";
        public List<RecurringPaymentStatusEnum> recurringPaymentStatuses;
        public static final String RECURRING_PAYMENT_STATUSES = "recurringPaymentStatuses";
        public List<ScheduledPaymentStatusEnum> scheduledPaymentStatuses;
        public static final String SCHEDULED_PAYMENT_STATUSES = "scheduledPaymentStatuses";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<DateTime> ticketExpiration;
        public static final String TICKET_EXPIRATION = "ticketExpiration";
        public List<TicketStatusEnum> ticketStatuses;
        public static final String TICKET_STATUSES = "ticketStatuses";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class ExportTransactionsOverviewParams {
        public String format;
        public static final String FORMAT = "format";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String authorizationPerformedBy;
        public static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
        public List<String> authorizationRoles;
        public static final String AUTHORIZATION_ROLES = "authorizationRoles";
        public List<TransactionAuthorizationStatusEnum> authorizationStatuses;
        public static final String AUTHORIZATION_STATUSES = "authorizationStatuses";
        public Boolean authorized;
        public static final String AUTHORIZED = "authorized";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public List<PaymentCreationTypeEnum> creationTypes;
        public static final String CREATION_TYPES = "creationTypes";
        public List<String> currencies;
        public static final String CURRENCIES = "currencies";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<DateTime> externalPaymentExpiration;
        public static final String EXTERNAL_PAYMENT_EXPIRATION = "externalPaymentExpiration";
        public List<ExternalPaymentStatusEnum> externalPaymentStatuses;
        public static final String EXTERNAL_PAYMENT_STATUSES = "externalPaymentStatuses";
        public List<String> fromAccountTypes;
        public static final String FROM_ACCOUNT_TYPES = "fromAccountTypes";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransactionKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<DateTime> paymentRequestExpiration;
        public static final String PAYMENT_REQUEST_EXPIRATION = "paymentRequestExpiration";
        public List<PaymentRequestStatusEnum> paymentRequestStatuses;
        public static final String PAYMENT_REQUEST_STATUSES = "paymentRequestStatuses";
        public Boolean pendingMyAuthorization;
        public static final String PENDING_MY_AUTHORIZATION = "pendingMyAuthorization";
        public List<RecurringPaymentStatusEnum> recurringPaymentStatuses;
        public static final String RECURRING_PAYMENT_STATUSES = "recurringPaymentStatuses";
        public List<ScheduledPaymentStatusEnum> scheduledPaymentStatuses;
        public static final String SCHEDULED_PAYMENT_STATUSES = "scheduledPaymentStatuses";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<DateTime> ticketExpiration;
        public static final String TICKET_EXPIRATION = "ticketExpiration";
        public List<TicketStatusEnum> ticketStatuses;
        public static final String TICKET_STATUSES = "ticketStatuses";
        public List<String> toAccountTypes;
        public static final String TO_ACCOUNT_TYPES = "toAccountTypes";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchTransactionsParams {
        public String owner;
        public static final String OWNER = "owner";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<String> accountTypes;
        public static final String ACCOUNT_TYPES = "accountTypes";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String authorizationPerformedBy;
        public static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
        public List<String> authorizationRoles;
        public static final String AUTHORIZATION_ROLES = "authorizationRoles";
        public List<TransactionAuthorizationStatusEnum> authorizationStatuses;
        public static final String AUTHORIZATION_STATUSES = "authorizationStatuses";
        public Boolean authorized;
        public static final String AUTHORIZED = "authorized";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public List<PaymentCreationTypeEnum> creationTypes;
        public static final String CREATION_TYPES = "creationTypes";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public TransferDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<DateTime> externalPaymentExpiration;
        public static final String EXTERNAL_PAYMENT_EXPIRATION = "externalPaymentExpiration";
        public List<ExternalPaymentStatusEnum> externalPaymentStatuses;
        public static final String EXTERNAL_PAYMENT_STATUSES = "externalPaymentStatuses";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransactionKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<DateTime> paymentRequestExpiration;
        public static final String PAYMENT_REQUEST_EXPIRATION = "paymentRequestExpiration";
        public List<PaymentRequestStatusEnum> paymentRequestStatuses;
        public static final String PAYMENT_REQUEST_STATUSES = "paymentRequestStatuses";
        public List<RecurringPaymentStatusEnum> recurringPaymentStatuses;
        public static final String RECURRING_PAYMENT_STATUSES = "recurringPaymentStatuses";
        public List<ScheduledPaymentStatusEnum> scheduledPaymentStatuses;
        public static final String SCHEDULED_PAYMENT_STATUSES = "scheduledPaymentStatuses";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<DateTime> ticketExpiration;
        public static final String TICKET_EXPIRATION = "ticketExpiration";
        public List<TicketStatusEnum> ticketStatuses;
        public static final String TICKET_STATUSES = "ticketStatuses";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchTransactionsOverviewParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String authorizationPerformedBy;
        public static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
        public List<String> authorizationRoles;
        public static final String AUTHORIZATION_ROLES = "authorizationRoles";
        public List<TransactionAuthorizationStatusEnum> authorizationStatuses;
        public static final String AUTHORIZATION_STATUSES = "authorizationStatuses";
        public Boolean authorized;
        public static final String AUTHORIZED = "authorized";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public List<PaymentCreationTypeEnum> creationTypes;
        public static final String CREATION_TYPES = "creationTypes";
        public List<String> currencies;
        public static final String CURRENCIES = "currencies";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<DateTime> externalPaymentExpiration;
        public static final String EXTERNAL_PAYMENT_EXPIRATION = "externalPaymentExpiration";
        public List<ExternalPaymentStatusEnum> externalPaymentStatuses;
        public static final String EXTERNAL_PAYMENT_STATUSES = "externalPaymentStatuses";
        public List<String> fromAccountTypes;
        public static final String FROM_ACCOUNT_TYPES = "fromAccountTypes";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransactionKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public List<DateTime> paymentRequestExpiration;
        public static final String PAYMENT_REQUEST_EXPIRATION = "paymentRequestExpiration";
        public List<PaymentRequestStatusEnum> paymentRequestStatuses;
        public static final String PAYMENT_REQUEST_STATUSES = "paymentRequestStatuses";
        public Boolean pendingMyAuthorization;
        public static final String PENDING_MY_AUTHORIZATION = "pendingMyAuthorization";
        public List<RecurringPaymentStatusEnum> recurringPaymentStatuses;
        public static final String RECURRING_PAYMENT_STATUSES = "recurringPaymentStatuses";
        public List<ScheduledPaymentStatusEnum> scheduledPaymentStatuses;
        public static final String SCHEDULED_PAYMENT_STATUSES = "scheduledPaymentStatuses";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<DateTime> ticketExpiration;
        public static final String TICKET_EXPIRATION = "ticketExpiration";
        public List<TicketStatusEnum> ticketStatuses;
        public static final String TICKET_STATUSES = "ticketStatuses";
        public List<String> toAccountTypes;
        public static final String TO_ACCOUNT_TYPES = "toAccountTypes";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }
}

