/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.TotpApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.OtpResult;
import org.cyclos.web.rest.model.SendOtp;
import org.cyclos.web.rest.model.TotpSecretData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class TotpApi {
    @Autowired
    private TotpApiImpl impl;
    public static final String ACTIVATE_TOTP_SECRET = "/totp-secret/activate";
    public static final String DELETE_USER_TOTP_SECRET = "/{user}/totp-secret";
    public static final String SEND_TOTP_SECRET_ACTIVATION_CODE = "/totp-secret/send-activaction-code";
    public static final String VERIFY_TOTP_SECRET_ACTIVATION_CODE = "/totp-secret/verify-activation-code";
    public static final String VIEW_USER_TOTP_SECRET = "/{user}/totp-secret";

    @RequestMapping(value={"/api/totp-secret/activate"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> activateTotpSecret(@RequestBody(required=true) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /totp-secret/activate");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.activateTotpSecret(string);
    }

    @RequestMapping(value={"/api/{user:.*}/totp-secret"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteUserTotpSecret(@PathVariable(value="user") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /{user}/totp-secret");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteUserTotpSecret(string, string2);
    }

    @RequestMapping(value={"/api/totp-secret/send-activaction-code"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<OtpResult> sendTotpSecretActivationCode(@RequestBody(required=true) SendOtp sendOtp, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /totp-secret/send-activaction-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.sendTotpSecretActivationCode(sendOtp, list);
    }

    @RequestMapping(value={"/api/totp-secret/verify-activation-code"}, produces={"text/plain", "application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<String> verifyTotpSecretActivationCode(@RequestBody(required=true) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /totp-secret/verify-activation-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.verifyTotpSecretActivationCode(string);
    }

    @RequestMapping(value={"/api/{user:.*}/totp-secret"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TotpSecretData> viewUserTotpSecret(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/totp-secret");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewUserTotpSecret(string, list);
    }
}

