/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.ShoppingCartsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ShoppingCartCheckout;
import org.cyclos.web.rest.model.ShoppingCartCheckoutError;
import org.cyclos.web.rest.model.ShoppingCartDataForCheckout;
import org.cyclos.web.rest.model.ShoppingCartError;
import org.cyclos.web.rest.model.ShoppingCartResult;
import org.cyclos.web.rest.model.ShoppingCartView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class ShoppingCartsApi {
    @Autowired
    private ShoppingCartsApiImpl impl;
    public static final String ADD_ITEM_TO_SHOPPING_CART = "/shopping-carts/items/{ad}";
    public static final String ADJUST_AND_GET_SHOPPING_CART_DETAILS = "/shopping-carts/{id}/adjust";
    public static final String CHECKOUT_SHOPPING_CART = "/shopping-carts/{id}/checkout";
    public static final String GET_SHOPPING_CART_DATA_FOR_CHECKOUT = "/shopping-carts/{id}/data-for-checkout";
    public static final String GET_SHOPPING_CART_DETAILS = "/shopping-carts/{id}";
    public static final String GET_SHOPPING_CARTS = "/shopping-carts";
    public static final String MODIFY_ITEM_QUANTITY_ON_SHOPPING_CART = "/shopping-carts/items/{ad}";
    public static final String REMOVE_ITEM_FROM_SHOPPING_CART = "/shopping-carts/items/{ad}";
    public static final String REMOVE_SHOPPING_CART = "/shopping-carts/{id}";

    @RequestMapping(value={"/api/shopping-carts/items/{ad:.*}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Integer> addItemToShoppingCart(@PathVariable(value="ad") String string, @RequestParam(value="quantity", required=false) Double d, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /shopping-carts/items/{ad}");
        httpServletRequest.setAttribute("errorType", ShoppingCartError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.addItemToShoppingCart(string, d);
    }

    @RequestMapping(value={"/api/shopping-carts/{id}/adjust"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ShoppingCartView> adjustAndGetShoppingCartDetails(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /shopping-carts/{id}/adjust");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.adjustAndGetShoppingCartDetails(string, list);
    }

    @RequestMapping(value={"/api/shopping-carts/{id}/checkout"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Integer> checkoutShoppingCart(@PathVariable(value="id") String string, @RequestBody(required=true) ShoppingCartCheckout shoppingCartCheckout, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /shopping-carts/{id}/checkout");
        httpServletRequest.setAttribute("errorType", ShoppingCartCheckoutError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.checkoutShoppingCart(string, shoppingCartCheckout, string2);
    }

    @RequestMapping(value={"/api/shopping-carts/{id}/data-for-checkout"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ShoppingCartDataForCheckout> getShoppingCartDataForCheckout(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /shopping-carts/{id}/data-for-checkout");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getShoppingCartDataForCheckout(string, list);
    }

    @RequestMapping(value={"/api/shopping-carts/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ShoppingCartView> getShoppingCartDetails(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /shopping-carts/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getShoppingCartDetails(string, list);
    }

    @RequestMapping(value={"/api/shopping-carts"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<ShoppingCartResult>> getShoppingCarts(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /shopping-carts");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getShoppingCarts(list);
    }

    @RequestMapping(value={"/api/shopping-carts/items/{ad:.*}"}, produces={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Integer> modifyItemQuantityOnShoppingCart(@PathVariable(value="ad") String string, @RequestParam(value="quantity", required=true) Double d, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /shopping-carts/items/{ad}");
        httpServletRequest.setAttribute("errorType", ShoppingCartError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.modifyItemQuantityOnShoppingCart(string, d);
    }

    @RequestMapping(value={"/api/shopping-carts/items/{ad:.*}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Integer> removeItemFromShoppingCart(@PathVariable(value="ad") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /shopping-carts/items/{ad}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.removeItemFromShoppingCart(string);
    }

    @RequestMapping(value={"/api/shopping-carts/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Integer> removeShoppingCart(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /shopping-carts/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.removeShoppingCart(string);
    }
}

