/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.RecurringPaymentsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.RecurringPaymentDataForEdit;
import org.cyclos.web.rest.model.RecurringPaymentEdit;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class RecurringPaymentsApi {
    @Autowired
    private RecurringPaymentsApiImpl impl;
    public static final String BLOCK_RECURRING_PAYMENT = "/recurring-payments/{key}/block";
    public static final String CANCEL_RECURRING_PAYMENT = "/recurring-payments/{key}/cancel";
    public static final String GET_RECURRING_PAYMENT_DATA_FOR_EDIT = "/recurring-payments/{key}/data-for-edit";
    public static final String MODIFY_RECURRING_PAYMENT = "/recurring-payments/{key}/modify";
    public static final String UNBLOCK_RECURRING_PAYMENT = "/recurring-payments/{key}/unblock";

    @RequestMapping(value={"/api/recurring-payments/{key}/block"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> blockRecurringPayment(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /recurring-payments/{key}/block");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.blockRecurringPayment(string, string2);
    }

    @RequestMapping(value={"/api/recurring-payments/{key}/cancel"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> cancelRecurringPayment(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /recurring-payments/{key}/cancel");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.cancelRecurringPayment(string, string2);
    }

    @RequestMapping(value={"/api/recurring-payments/{key}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<RecurringPaymentDataForEdit> getRecurringPaymentDataForEdit(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /recurring-payments/{key}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getRecurringPaymentDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/recurring-payments/{key}/modify"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> modifyRecurringPayment(@PathVariable(value="key") String string, @RequestBody(required=true) RecurringPaymentEdit recurringPaymentEdit, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /recurring-payments/{key}/modify");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.modifyRecurringPayment(string, recurringPaymentEdit, string2);
    }

    @RequestMapping(value={"/api/recurring-payments/{key}/unblock"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> unblockRecurringPayment(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /recurring-payments/{key}/unblock");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.unblockRecurringPayment(string, string2);
    }
}

