/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.model.users.records.RecordData;
import org.cyclos.model.users.records.RecordDataParams;
import org.cyclos.model.users.records.RecordQuery;
import org.cyclos.model.users.records.RecordSearchData;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.records.SharedRecordFieldsSearchData;
import org.cyclos.model.users.records.SystemRecordVO;
import org.cyclos.model.users.records.UserRecordQuery;
import org.cyclos.model.users.records.UserRecordSearchData;
import org.cyclos.model.users.records.UserRecordVO;
import org.cyclos.model.users.recordtypes.RecordTypeVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.users.RecordService;
import org.cyclos.services.users.RecordTypeService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.RecordsApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.RecordsApiHelper;
import org.cyclos.web.rest.model.GeneralRecordsDataForSearch;
import org.cyclos.web.rest.model.GeneralRecordsQueryFilters;
import org.cyclos.web.rest.model.OwnerRecordData;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.RecordDataForEdit;
import org.cyclos.web.rest.model.RecordDataForNew;
import org.cyclos.web.rest.model.RecordDataForSearch;
import org.cyclos.web.rest.model.RecordEdit;
import org.cyclos.web.rest.model.RecordQueryFilters;
import org.cyclos.web.rest.model.RecordResult;
import org.cyclos.web.rest.model.RecordType;
import org.cyclos.web.rest.model.RecordView;
import org.cyclos.web.rest.model.RecordWithOwnerResult;
import org.cyclos.web.rest.model.SharedRecordsDataForSearch;
import org.cyclos.web.rest.model.SharedRecordsQueryFilters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class RecordsApiImpl
extends BaseApiImpl {
    @Autowired
    private RecordService recordService;
    @Autowired
    private RecordTypeService recordTypeService;
    @Autowired
    private RecordsApiHelper recordsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public ResponseEntity<String> createRecord(RecordsApi.CreateRecordParams createRecordParams) {
        RecordDTO recordDTO = this.recordsApiHelper.toRecordDTO(null, createRecordParams.owner, createRecordParams.type, createRecordParams.recordNew);
        String string = ApiHelper.toId(this.recordService.saveWithConfirmationPassword((EntityDTO)recordDTO, createRecordParams.confirmationPassword));
        return this.created(this.apiHelper.uriFromApi("records", string), string);
    }

    public ResponseEntity<Void> deleteRecord(String string, String string2) {
        this.recordService.removeWithConfirmationPassword(this.apiHelper.fromId(string), string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputStream> exportGeneralRecords(RecordsApi.ExportGeneralRecordsParams exportGeneralRecordsParams) {
        GeneralRecordsQueryFilters generalRecordsQueryFilters = (GeneralRecordsQueryFilters)ClassHelper.convert((Object)exportGeneralRecordsParams, GeneralRecordsQueryFilters.class);
        UserRecordQuery userRecordQuery = this.recordsApiHelper.toGeneralRecordsQuery(exportGeneralRecordsParams.type, generalRecordsQueryFilters);
        return this.exportRecords(exportGeneralRecordsParams.format, (RecordQuery)userRecordQuery);
    }

    public ResponseEntity<InputStream> exportOwnerRecords(RecordsApi.ExportOwnerRecordsParams exportOwnerRecordsParams) {
        RecordQueryFilters recordQueryFilters = (RecordQueryFilters)ClassHelper.convert((Object)exportOwnerRecordsParams, RecordQueryFilters.class);
        RecordQuery recordQuery = this.recordsApiHelper.toRecordQuery(exportOwnerRecordsParams.owner, exportOwnerRecordsParams.type, recordQueryFilters);
        return this.exportRecords(exportOwnerRecordsParams.format, recordQuery);
    }

    public ResponseEntity<InputStream> exportSharedRecords(RecordsApi.ExportSharedRecordsParams exportSharedRecordsParams) {
        SharedRecordsQueryFilters sharedRecordsQueryFilters = (SharedRecordsQueryFilters)ClassHelper.convert((Object)exportSharedRecordsParams, SharedRecordsQueryFilters.class);
        UserRecordQuery userRecordQuery = this.recordsApiHelper.toSharedRecordQuery(sharedRecordsQueryFilters);
        return this.exportRecords(exportSharedRecordsParams.format, (RecordQuery)userRecordQuery);
    }

    public ResponseEntity<PasswordInput> getPasswordInputForRemoveRecord(String string, List<String> list) {
        CredentialInputDTO credentialInputDTO = this.recordService.getConfirmationPasswordInputForRemove(this.apiHelper.fromId(string));
        PasswordInput passwordInput = this.authApiHelper.toPasswordInput((ICredentialInputDTO)credentialInputDTO);
        return this.ok(passwordInput);
    }

    public ResponseEntity<RecordDataForEdit> getRecordDataForEdit(String string, List<String> list) {
        RecordData recordData = (RecordData)this.recordService.getData(this.apiHelper.fromId(string));
        RecordDataForEdit recordDataForEdit = this.recordsApiHelper.toRecordDataForEdit(recordData);
        return this.ok(recordDataForEdit);
    }

    public ResponseEntity<GeneralRecordsDataForSearch> getRecordDataForGeneralSearch(String string, List<String> list) {
        UserRecordSearchData userRecordSearchData = (UserRecordSearchData)this.recordService.getSearchData((RecordTypeVO)ModelHelper.voFromString(RecordTypeVO.class, (String)string), null);
        GeneralRecordsDataForSearch generalRecordsDataForSearch = this.recordsApiHelper.toGeneralRecordsDataForSearch(userRecordSearchData);
        return this.ok(generalRecordsDataForSearch);
    }

    public ResponseEntity<RecordDataForNew> getRecordDataForNew(String string, String string2, List<String> list) {
        RecordDataParams recordDataParams = new RecordDataParams();
        recordDataParams.setRecordType((RecordTypeVO)ModelHelper.voFromString(RecordTypeVO.class, (String)string2));
        if (!this.apiHelper.isSystem(string)) {
            recordDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        }
        RecordData recordData = (RecordData)this.recordService.getDataForNew((Object)recordDataParams);
        RecordDataForNew recordDataForNew = this.recordsApiHelper.toRecordDataForNew(recordData);
        return this.ok(recordDataForNew);
    }

    public ResponseEntity<RecordDataForSearch> getRecordDataForOwnerSearch(String string, String string2, List<String> list) {
        RecordSearchData recordSearchData = this.recordService.getSearchData((RecordTypeVO)ModelHelper.voFromString(RecordTypeVO.class, (String)string2), this.apiHelper.isSystem(string) ? null : (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        RecordDataForSearch recordDataForSearch = this.recordsApiHelper.toRecordDataForSearch(recordSearchData);
        return this.ok(recordDataForSearch);
    }

    public ResponseEntity<SharedRecordsDataForSearch> getRecordDataForSharedSearch(List<String> list) {
        SharedRecordFieldsSearchData sharedRecordFieldsSearchData = this.recordService.getSharedFieldsSearchData();
        SharedRecordsDataForSearch sharedRecordsDataForSearch = this.recordsApiHelper.toSharedRecordsDataForSearch(sharedRecordFieldsSearchData);
        return this.ok(sharedRecordsDataForSearch);
    }

    public ResponseEntity<OwnerRecordData> getRecordTypeByOwner(String string, String string2, List<String> list) {
        Optional<OwnerRecordData> optional = this.getRecordTypes(string).stream().filter(ownerRecordData -> string2.equals(ownerRecordData.getType().getId()) || string2.equals(ownerRecordData.getType().getInternalName())).findAny();
        if (!optional.isPresent()) {
            throw new EntityNotFoundException(RecordType.class, string2);
        }
        return this.ok(optional.get());
    }

    public ResponseEntity<List<OwnerRecordData>> listRecordTypesByOwner(String string, List<String> list) {
        return this.ok(this.getRecordTypes(string));
    }

    public ResponseEntity<List<RecordType>> listRecordTypesForGeneralSearch(List<String> list) {
        List list2 = this.recordTypeService.listRecordTypesForGeneralSearch();
        List list3 = list2.stream().map(this.recordsApiHelper::toRecordType).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<List<RecordWithOwnerResult>> searchGeneralRecords(RecordsApi.SearchGeneralRecordsParams searchGeneralRecordsParams) {
        GeneralRecordsQueryFilters generalRecordsQueryFilters = (GeneralRecordsQueryFilters)ClassHelper.convert((Object)searchGeneralRecordsParams, GeneralRecordsQueryFilters.class);
        UserRecordQuery userRecordQuery = this.recordsApiHelper.toGeneralRecordsQuery(searchGeneralRecordsParams.type, generalRecordsQueryFilters);
        Page page = this.recordService.search((RecordQuery)userRecordQuery);
        return this.pageResponse(page, this.recordsApiHelper::toRecordWithOwnerResult);
    }

    public ResponseEntity<List<RecordResult>> searchOwnerRecords(RecordsApi.SearchOwnerRecordsParams searchOwnerRecordsParams) {
        RecordQueryFilters recordQueryFilters = (RecordQueryFilters)ClassHelper.convert((Object)searchOwnerRecordsParams, RecordQueryFilters.class);
        RecordQuery recordQuery = this.recordsApiHelper.toRecordQuery(searchOwnerRecordsParams.owner, searchOwnerRecordsParams.type, recordQueryFilters);
        Page page = this.recordService.search(recordQuery);
        return this.pageResponse(page, this.recordsApiHelper::toRecordResult);
    }

    public ResponseEntity<List<RecordWithOwnerResult>> searchSharedRecords(RecordsApi.SearchSharedRecordsParams searchSharedRecordsParams) {
        SharedRecordsQueryFilters sharedRecordsQueryFilters = (SharedRecordsQueryFilters)ClassHelper.convert((Object)searchSharedRecordsParams, SharedRecordsQueryFilters.class);
        UserRecordQuery userRecordQuery = this.recordsApiHelper.toSharedRecordQuery(sharedRecordsQueryFilters);
        Page page = this.recordService.search((RecordQuery)userRecordQuery);
        return this.pageResponse(page, this.recordsApiHelper::toRecordWithOwnerResult);
    }

    public ResponseEntity<Void> updateRecord(String string, RecordEdit recordEdit, String string2) {
        UserRecordVO userRecordVO;
        String string3;
        RecordVO recordVO = this.recordService.loadVO(this.apiHelper.fromId(string));
        String string4 = ApiHelper.toId(recordVO.getType().getId());
        if (recordVO instanceof SystemRecordVO) {
            string3 = "SYSTEM";
        } else {
            userRecordVO = (UserRecordVO)recordVO;
            string3 = ApiHelper.toId(userRecordVO.getUser().getId());
        }
        userRecordVO = this.recordsApiHelper.toRecordDTO(string, string3, string4, recordEdit);
        this.recordService.saveWithConfirmationPassword((EntityDTO)userRecordVO, string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<RecordView> viewRecord(String string, List<String> list) {
        RecordData recordData = (RecordData)this.recordService.getData(this.apiHelper.fromId(string));
        RecordView recordView = this.recordsApiHelper.toRecordView(recordData);
        return this.ok(recordView);
    }

    private ResponseEntity<InputStream> exportRecords(String string, RecordQuery recordQuery) {
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)string);
        FileInfo fileInfo = this.recordService.exportRecords(exportFormatVO, recordQuery);
        return this.writeFile(fileInfo);
    }

    private List<OwnerRecordData> getRecordTypes(String string) {
        List<OwnerRecordData> list = this.recordService.getRecordTypeCount(ModelHelper.accountOwner((String)string)).stream().map(this.recordsApiHelper::toOwnerRecordData).collect(Collectors.toList());
        return list;
    }
}

