/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.OrdersApiImpl;
import org.cyclos.web.rest.model.AcceptOrderByBuyer;
import org.cyclos.web.rest.model.AcceptOrderBySeller;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.OrderDataForAcceptByBuyer;
import org.cyclos.web.rest.model.OrderDataForEdit;
import org.cyclos.web.rest.model.OrderDataForNew;
import org.cyclos.web.rest.model.OrderDataForSearch;
import org.cyclos.web.rest.model.OrderDataForSetDeliveryMethod;
import org.cyclos.web.rest.model.OrderEdit;
import org.cyclos.web.rest.model.OrderNew;
import org.cyclos.web.rest.model.OrderStatusEnum;
import org.cyclos.web.rest.model.OrderView;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.RejectOrder;
import org.cyclos.web.rest.model.SetDeliveryMethod;
import org.cyclos.web.rest.model.UserOrderResult;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class OrdersApi {
    @Autowired
    private OrdersApiImpl impl;
    public static final String ACCEPT_ORDER_BY_BUYER = "/orders/{order}/buyer/accept";
    public static final String ACCEPT_ORDER_BY_SELLER = "/orders/{order}/seller/accept";
    public static final String CREATE_ORDER = "/{user}/orders";
    public static final String DELETE_ORDER = "/orders/{order}";
    public static final String EXPORT_ORDER = "/orders/{order}/export/{format}";
    public static final String GET_DATA_FOR_SET_DELIVERY_METHOD = "/orders/{order}/seller/data-for-set-delivery";
    public static final String GET_ORDER_DATA_FOR_ACCEPT_BY_BUYER = "/orders/{order}/buyer/data-for-accept";
    public static final String GET_ORDER_DATA_FOR_EDIT = "/orders/{order}/data-for-edit";
    public static final String GET_ORDER_DATA_FOR_NEW = "/{user}/orders/data-for-new";
    public static final String GET_ORDER_DATA_FOR_SEARCH = "/{user}/orders/data-for-search";
    public static final String REJECT_ORDER = "/orders/{order}/reject";
    public static final String SEARCH_USER_ORDERS = "/{user}/orders";
    public static final String SET_DELIVERY_METHOD = "/orders/{order}/seller/set-delivery";
    public static final String UPDATE_ORDER = "/orders/{order}";
    public static final String VIEW_ORDER = "/orders/{order}";

    @RequestMapping(value={"/api/orders/{order:.*}/buyer/accept"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> acceptOrderByBuyer(@PathVariable(value="order") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, @RequestBody(required=false) AcceptOrderByBuyer acceptOrderByBuyer, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /orders/{order}/buyer/accept");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.acceptOrderByBuyer(string, string2, acceptOrderByBuyer);
    }

    @RequestMapping(value={"/api/orders/{order:.*}/seller/accept"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> acceptOrderBySeller(@PathVariable(value="order") String string, @RequestBody(required=false) AcceptOrderBySeller acceptOrderBySeller, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /orders/{order}/seller/accept");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.acceptOrderBySeller(string, acceptOrderBySeller);
    }

    @RequestMapping(value={"/api/{user:.*}/orders"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createOrder(@PathVariable(value="user") String string, @RequestBody(required=true) OrderNew orderNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/orders");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.createOrder(string, orderNew);
    }

    @RequestMapping(value={"/api/orders/{order:.*}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteOrder(@PathVariable(value="order") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /orders/{order}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteOrder(string);
    }

    @RequestMapping(value={"/api/orders/{order:.*}/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportOrder(@PathVariable(value="order") String string, @PathVariable(value="format") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /orders/{order}/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.exportOrder(string, string2);
    }

    @RequestMapping(value={"/api/orders/{order:.*}/seller/data-for-set-delivery"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OrderDataForSetDeliveryMethod> getDataForSetDeliveryMethod(@PathVariable(value="order") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /orders/{order}/seller/data-for-set-delivery");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDataForSetDeliveryMethod(string, list);
    }

    @RequestMapping(value={"/api/orders/{order:.*}/buyer/data-for-accept"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OrderDataForAcceptByBuyer> getOrderDataForAcceptByBuyer(@PathVariable(value="order") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /orders/{order}/buyer/data-for-accept");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOrderDataForAcceptByBuyer(string, list);
    }

    @RequestMapping(value={"/api/orders/{order:.*}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OrderDataForEdit> getOrderDataForEdit(@PathVariable(value="order") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /orders/{order}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOrderDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/orders/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OrderDataForNew> getOrderDataForNew(@PathVariable(value="user") String string, @RequestParam(value="buyer", required=true) String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="currency", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/orders/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        GetOrderDataForNewParams getOrderDataForNewParams = new GetOrderDataForNewParams();
        getOrderDataForNewParams.user = string;
        getOrderDataForNewParams.buyer = string2;
        getOrderDataForNewParams.fields = list;
        getOrderDataForNewParams.currency = string3;
        return this.impl.getOrderDataForNew(getOrderDataForNewParams);
    }

    @RequestMapping(value={"/api/{user:.*}/orders/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OrderDataForSearch> getOrderDataForSearch(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="sales", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/orders/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOrderDataForSearch(string, list, bl);
    }

    @RequestMapping(value={"/api/orders/{order:.*}/reject"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> rejectOrder(@PathVariable(value="order") String string, @RequestBody(required=false) RejectOrder rejectOrder, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /orders/{order}/reject");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.rejectOrder(string, rejectOrder);
    }

    @RequestMapping(value={"/api/{user:.*}/orders"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserOrderResult>> searchUserOrders(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="number", required=false) String string2, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="productNumber", required=false) String string3, @RequestParam(value="relatedUser", required=false) String string4, @RequestParam(value="sales", required=false) Boolean bl, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, @RequestParam(value="statuses", required=false) List<OrderStatusEnum> list3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/orders");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUserOrdersParams searchUserOrdersParams = new SearchUserOrdersParams();
        searchUserOrdersParams.user = string;
        searchUserOrdersParams.fields = list;
        searchUserOrdersParams.creationPeriod = list2;
        searchUserOrdersParams.number = string2;
        searchUserOrdersParams.page = n;
        searchUserOrdersParams.pageSize = n2;
        searchUserOrdersParams.productNumber = string3;
        searchUserOrdersParams.relatedUser = string4;
        searchUserOrdersParams.sales = bl;
        searchUserOrdersParams.skipTotalCount = bl2;
        searchUserOrdersParams.statuses = list3;
        return this.impl.searchUserOrders(searchUserOrdersParams);
    }

    @RequestMapping(value={"/api/orders/{order:.*}/seller/set-delivery"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> setDeliveryMethod(@PathVariable(value="order") String string, @RequestBody(required=false) SetDeliveryMethod setDeliveryMethod, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /orders/{order}/seller/set-delivery");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.setDeliveryMethod(string, setDeliveryMethod);
    }

    @RequestMapping(value={"/api/orders/{order:.*}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateOrder(@PathVariable(value="order") String string, @RequestBody(required=true) OrderEdit orderEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /orders/{order}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateOrder(string, orderEdit);
    }

    @RequestMapping(value={"/api/orders/{order:.*}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OrderView> viewOrder(@PathVariable(value="order") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /orders/{order}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewOrder(string, list);
    }

    public static class GetOrderDataForNewParams {
        public String user;
        public static final String USER = "user";
        public String buyer;
        public static final String BUYER = "buyer";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String currency;
        public static final String CURRENCY = "currency";
    }

    public static class SearchUserOrdersParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public String number;
        public static final String NUMBER = "number";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public String productNumber;
        public static final String PRODUCT_NUMBER = "productNumber";
        public String relatedUser;
        public static final String RELATED_USER = "relatedUser";
        public Boolean sales;
        public static final String SALES = "sales";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<OrderStatusEnum> statuses;
        public static final String STATUSES = "statuses";
    }
}

