/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.OperatorsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.GeneralOperatorsDataForSearch;
import org.cyclos.web.rest.model.OperatorDataForNew;
import org.cyclos.web.rest.model.OperatorNew;
import org.cyclos.web.rest.model.OperatorResult;
import org.cyclos.web.rest.model.UserOperatorsDataForSearch;
import org.cyclos.web.rest.model.UserRegistrationResult;
import org.cyclos.web.rest.model.UserStatusEnum;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class OperatorsApi {
    @Autowired
    private OperatorsApiImpl impl;
    public static final String GET_GENERAL_OPERATORS_DATA_FOR_SEARCH = "/operators/data-for-search";
    public static final String GET_OPERATOR_DATA_FOR_NEW = "/{user}/operators/data-for-new";
    public static final String GET_USER_OPERATORS_DATA_FOR_SEARCH = "/{user}/operators/data-for-search";
    public static final String REGISTER_OPERATOR = "/{user}/operators";
    public static final String SEARCH_GENERAL_OPERATORS = "/operators";
    public static final String SEARCH_USER_OPERATORS = "/{user}/operators";

    @RequestMapping(value={"/api/operators/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<GeneralOperatorsDataForSearch> getGeneralOperatorsDataForSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /operators/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getGeneralOperatorsDataForSearch(list);
    }

    @RequestMapping(value={"/api/{user:.*}/operators/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperatorDataForNew> getOperatorDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="group", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/operators/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOperatorDataForNew(string, list, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/operators/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserOperatorsDataForSearch> getUserOperatorsDataForSearch(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/operators/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserOperatorsDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/operators"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<UserRegistrationResult> registerOperator(@PathVariable(value="user") String string, @RequestBody(required=true) OperatorNew operatorNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/operators");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.registerOperator(string, operatorNew);
    }

    @RequestMapping(value={"/api/operators"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<OperatorResult>> searchGeneralOperators(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="broker", required=false) String string, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="keywords", required=false) String string2, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, @RequestParam(value="statuses", required=false) List<UserStatusEnum> list3, @RequestParam(value="userGroups", required=false) List<String> list4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /operators");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchGeneralOperatorsParams searchGeneralOperatorsParams = new SearchGeneralOperatorsParams();
        searchGeneralOperatorsParams.fields = list;
        searchGeneralOperatorsParams.broker = string;
        searchGeneralOperatorsParams.creationPeriod = list2;
        searchGeneralOperatorsParams.keywords = string2;
        searchGeneralOperatorsParams.page = n;
        searchGeneralOperatorsParams.pageSize = n2;
        searchGeneralOperatorsParams.skipTotalCount = bl;
        searchGeneralOperatorsParams.statuses = list3;
        searchGeneralOperatorsParams.userGroups = list4;
        return this.impl.searchGeneralOperators(searchGeneralOperatorsParams);
    }

    @RequestMapping(value={"/api/{user:.*}/operators"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<OperatorResult>> searchUserOperators(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="creationPeriod", required=false) List<DateTime> list2, @RequestParam(value="ignoreProfileFieldsInList", required=false) Boolean bl, @RequestParam(value="keywords", required=false) String string2, @RequestParam(value="operatorGroups", required=false) List<String> list3, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl2, @RequestParam(value="statuses", required=false) List<UserStatusEnum> list4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/operators");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUserOperatorsParams searchUserOperatorsParams = new SearchUserOperatorsParams();
        searchUserOperatorsParams.user = string;
        searchUserOperatorsParams.fields = list;
        searchUserOperatorsParams.creationPeriod = list2;
        searchUserOperatorsParams.ignoreProfileFieldsInList = bl;
        searchUserOperatorsParams.keywords = string2;
        searchUserOperatorsParams.operatorGroups = list3;
        searchUserOperatorsParams.page = n;
        searchUserOperatorsParams.pageSize = n2;
        searchUserOperatorsParams.skipTotalCount = bl2;
        searchUserOperatorsParams.statuses = list4;
        return this.impl.searchUserOperators(searchUserOperatorsParams);
    }

    public static class SearchGeneralOperatorsParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String broker;
        public static final String BROKER = "broker";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> userGroups;
        public static final String USER_GROUPS = "userGroups";
    }

    public static class SearchUserOperatorsParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<DateTime> creationPeriod;
        public static final String CREATION_PERIOD = "creationPeriod";
        public Boolean ignoreProfileFieldsInList;
        public static final String IGNORE_PROFILE_FIELDS_IN_LIST = "ignoreProfileFieldsInList";
        public String keywords;
        public static final String KEYWORDS = "keywords";
        public List<String> operatorGroups;
        public static final String OPERATOR_GROUPS = "operatorGroups";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<UserStatusEnum> statuses;
        public static final String STATUSES = "statuses";
    }
}

