/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.access.Role;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeData;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsDTO;
import org.cyclos.model.messaging.notificationsettings.NotificationSettingsData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.messaging.NotificationSettingsService;
import org.cyclos.services.users.InternalBasicUserService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.NotificationSettingsApiHelper;
import org.cyclos.web.rest.model.DataForEmailUnsubscribe;
import org.cyclos.web.rest.model.NotificationSettingsDataForEdit;
import org.cyclos.web.rest.model.NotificationSettingsEdit;
import org.cyclos.web.rest.model.NotificationSettingsView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class NotificationSettingsApiImpl
extends BaseApiImpl {
    @Autowired
    private NotificationSettingsService notificationSettingsService;
    @Autowired
    private NotificationSettingsApiHelper notificationSettingsApiHelper;
    @Autowired
    private InternalBasicUserService internalBasicUserService;

    public ResponseEntity<Void> emailUnsubscribe(String string) {
        this.notificationSettingsService.emailUnsubscribe(string);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DataForEmailUnsubscribe> getDataForEmailUnsubscribe(String string, List<String> list) {
        EmailUnsubscribeData emailUnsubscribeData = this.notificationSettingsService.getEmailUnsubscribeData(string);
        DataForEmailUnsubscribe dataForEmailUnsubscribe = this.notificationSettingsApiHelper.toDataForEmailUnsubscribe(emailUnsubscribeData);
        return this.ok(dataForEmailUnsubscribe);
    }

    public ResponseEntity<NotificationSettingsDataForEdit> getNotificationSettingsDataForEdit(String string, List<String> list) {
        NotificationSettingsData notificationSettingsData = this.notificationSettingsService.getData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        NotificationSettingsDataForEdit notificationSettingsDataForEdit = this.notificationSettingsApiHelper.toNotificationSettingsDataForEdit(notificationSettingsData);
        return this.ok(notificationSettingsDataForEdit);
    }

    public ResponseEntity<Void> saveNotificationSettings(String string, NotificationSettingsEdit notificationSettingsEdit) {
        Role role = this.internalBasicUserService.getMainRole((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        Object object = role == Role.ADMIN ? this.notificationSettingsApiHelper.toAdminNotificationSettingsDTO(string, notificationSettingsEdit) : this.notificationSettingsApiHelper.toUserNotificationSettingsDTO(string, notificationSettingsEdit);
        this.notificationSettingsService.save((NotificationSettingsDTO)object);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<NotificationSettingsView> viewNotificationSettings(String string, List<String> list) {
        NotificationSettingsData notificationSettingsData = this.notificationSettingsService.getData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        NotificationSettingsView notificationSettingsView = this.notificationSettingsApiHelper.toNotificationSettingsView(notificationSettingsData);
        return this.ok(notificationSettingsView);
    }
}

