/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.ExternalPaymentActionDTO;
import org.cyclos.model.banking.transactions.ExternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ExternalPaymentVO;
import org.cyclos.model.banking.transactions.PerformExternalPaymentDTO;
import org.cyclos.model.banking.transactions.PerformExternalPaymentData;
import org.cyclos.model.banking.transactions.PerformExternalPaymentTypeData;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.banking.ExternalPaymentService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.ExternalPaymentsApi;
import org.cyclos.web.rest.helpers.ExternalPaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.ExternalPaymentPreview;
import org.cyclos.web.rest.model.PerformExternalPayment;
import org.cyclos.web.rest.model.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ExternalPaymentsApiImpl
extends BaseApiImpl {
    @Autowired
    private ExternalPaymentsApiHelper externalPaymentsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private ExternalPaymentService externalPaymentService;

    public ResponseEntity<Void> cancelExternalPayment(String string, String string2, String string3) {
        ExternalPaymentActionDTO externalPaymentActionDTO = this.externalPaymentsApiHelper.toExternalPaymentActionDTO(string, string2, string3);
        this.externalPaymentService.cancel(externalPaymentActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DataForTransaction> dataForPerformExternalPayment(String string, List<String> list, String string2) {
        DataForTransaction dataForTransaction;
        InternalAccountOwner internalAccountOwner = ModelHelper.accountOwner((String)string);
        TransferTypeVO transferTypeVO = (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)string2);
        if (transferTypeVO == null) {
            PerformExternalPaymentData performExternalPaymentData = this.externalPaymentService.getExternalPaymentData(internalAccountOwner);
            dataForTransaction = this.externalPaymentsApiHelper.toDataForPerformExternalPayment(performExternalPaymentData);
        } else {
            PerformExternalPaymentTypeData performExternalPaymentTypeData = this.externalPaymentService.getExternalPaymentTypeData(internalAccountOwner, transferTypeVO);
            dataForTransaction = this.externalPaymentsApiHelper.toDataForPerformExternalPayment(performExternalPaymentTypeData);
        }
        return this.ok(dataForTransaction);
    }

    public ResponseEntity<Transaction> performExternalPayment(ExternalPaymentsApi.PerformExternalPaymentParams performExternalPaymentParams) {
        PerformExternalPaymentDTO performExternalPaymentDTO = this.externalPaymentsApiHelper.toPerformExternalPaymentDTO(performExternalPaymentParams.owner, performExternalPaymentParams.confirmationPassword, performExternalPaymentParams.performExternalPayment);
        ExternalPaymentVO externalPaymentVO = this.externalPaymentService.perform(performExternalPaymentDTO);
        Transaction transaction = this.transactionsApiHelper.toTransaction((TransactionVO)externalPaymentVO);
        return this.ok(transaction);
    }

    public ResponseEntity<ExternalPaymentPreview> previewExternalPayment(String string, PerformExternalPayment performExternalPayment, List<String> list) {
        PerformExternalPaymentDTO performExternalPaymentDTO = this.externalPaymentsApiHelper.toPerformExternalPaymentDTO(string, null, performExternalPayment);
        ExternalPaymentPreviewVO externalPaymentPreviewVO = this.externalPaymentService.preview(performExternalPaymentDTO);
        ExternalPaymentPreview externalPaymentPreview = this.externalPaymentsApiHelper.toExternalPaymentPreview(externalPaymentPreviewVO);
        return this.ok(externalPaymentPreview);
    }
}

