/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.access.DeviceConfirmationService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.DeviceConfirmationsApiHelper;
import org.cyclos.web.rest.model.CreateDeviceConfirmation;
import org.cyclos.web.rest.model.DataForDeviceConfirmationApproval;
import org.cyclos.web.rest.model.DeviceConfirmationActionParams;
import org.cyclos.web.rest.model.DeviceConfirmationView;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class DeviceConfirmationsApiImpl
extends BaseApiImpl {
    @Autowired
    private DeviceConfirmationService deviceConfirmationService;
    @Autowired
    private DeviceConfirmationsApiHelper deviceConfirmationsApiHelper;
    @Autowired
    private ApiHelper apiHelper;

    public ResponseEntity<Void> approveDeviceConfirmation(String string, DeviceConfirmationActionParams deviceConfirmationActionParams) {
        this.deviceConfirmationService.approve(string, this.apiHelper.fromId(deviceConfirmationActionParams.getDeviceId()).longValue(), deviceConfirmationActionParams.getHmac());
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> createDeviceConfirmation(CreateDeviceConfirmation createDeviceConfirmation) {
        String string = this.deviceConfirmationService.create(this.deviceConfirmationsApiHelper.toCreateDeviceConfirmationParams(createDeviceConfirmation)).getId();
        return this.created(this.apiHelper.uriFromApi("device-confirmations", string), string);
    }

    public ResponseEntity<DataForDeviceConfirmationApproval> dataForDeviceConfirmationApproval(String string) {
        return this.ok(this.deviceConfirmationsApiHelper.toDataForApproval(this.deviceConfirmationService.getApprovalData(this.apiHelper.fromId(string))));
    }

    public ResponseEntity<Void> deleteDeviceConfirmation(String string) {
        this.deviceConfirmationService.remove(string);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputStream> getDeviceConfirmationQrCode(String string, ImageSizeEnum imageSizeEnum) throws IOException {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams = this.deviceConfirmationsApiHelper.toDeviceConfirmationBarcodeParams(string, imageSizeEnum);
        SerializableInputStream serializableInputStream = this.deviceConfirmationService.barcode(deviceConfirmationBarcodeParams);
        ServletHelper.setContentType(httpServletResponse, ContentType.PNG);
        ServletHelper.writeContents(httpServletResponse, (InputStream)serializableInputStream);
        httpServletResponse.flushBuffer();
        return null;
    }

    public ResponseEntity<Void> rejectDeviceConfirmation(String string, DeviceConfirmationActionParams deviceConfirmationActionParams) {
        this.deviceConfirmationService.reject(string, this.apiHelper.fromId(deviceConfirmationActionParams.getDeviceId()).longValue(), deviceConfirmationActionParams.getHmac());
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DeviceConfirmationView> viewDeviceConfirmation(String string) {
        return this.ok(this.deviceConfirmationsApiHelper.toDeviceConfirmationView(this.deviceConfirmationService.load(string)));
    }
}

