/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.DeliveryMethodsApiImpl;
import org.cyclos.web.rest.model.DeliveryMethodDataForEdit;
import org.cyclos.web.rest.model.DeliveryMethodDataForNew;
import org.cyclos.web.rest.model.DeliveryMethodEdit;
import org.cyclos.web.rest.model.DeliveryMethodNew;
import org.cyclos.web.rest.model.DeliveryMethodView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserDeliveryMethodsListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class DeliveryMethodsApi {
    @Autowired
    private DeliveryMethodsApiImpl impl;
    public static final String CREATE_DELIVERY_METHOD = "/{user}/delivery-methods";
    public static final String DELETE_DELIVERY_METHOD = "/delivery-methods/{id}";
    public static final String GET_DELIVERY_METHOD_DATA_FOR_EDIT = "/delivery-methods/{id}/data-for-edit";
    public static final String GET_DELIVERY_METHOD_DATA_FOR_NEW = "/{user}/delivery-methods/data-for-new";
    public static final String GET_USER_DELIVERY_METHODS_LIST_DATA = "/{user}/delivery-methods/list-data";
    public static final String UPDATE_DELIVERY_METHOD = "/delivery-methods/{id}";
    public static final String VIEW_DELIVERY_METHOD = "/delivery-methods/{id}";

    @RequestMapping(value={"/api/{user:.*}/delivery-methods"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createDeliveryMethod(@PathVariable(value="user") String string, @RequestBody(required=true) DeliveryMethodNew deliveryMethodNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/delivery-methods");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.createDeliveryMethod(string, deliveryMethodNew);
    }

    @RequestMapping(value={"/api/delivery-methods/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteDeliveryMethod(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /delivery-methods/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteDeliveryMethod(string);
    }

    @RequestMapping(value={"/api/delivery-methods/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DeliveryMethodDataForEdit> getDeliveryMethodDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /delivery-methods/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDeliveryMethodDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/delivery-methods/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DeliveryMethodDataForNew> getDeliveryMethodDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/delivery-methods/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDeliveryMethodDataForNew(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/delivery-methods/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserDeliveryMethodsListData> getUserDeliveryMethodsListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/delivery-methods/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserDeliveryMethodsListData(string, list);
    }

    @RequestMapping(value={"/api/delivery-methods/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateDeliveryMethod(@PathVariable(value="id") String string, @RequestBody(required=true) DeliveryMethodEdit deliveryMethodEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /delivery-methods/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateDeliveryMethod(string, deliveryMethodEdit);
    }

    @RequestMapping(value={"/api/delivery-methods/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DeliveryMethodView> viewDeliveryMethod(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /delivery-methods/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewDeliveryMethod(string, list);
    }
}

