/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.utils.DimensionsDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.CaptchaService;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.CaptchaApi;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class CaptchaApiImpl
extends BaseApiImpl {
    @Autowired
    private CaptchaService captchaService;

    public ResponseEntity<Void> deleteCaptcha(String string) throws URISyntaxException {
        this.captchaService.remove(string);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputStream> getCaptchaContent(CaptchaApi.GetCaptchaContentParams getCaptchaContentParams) throws IOException {
        DimensionsDTO dimensionsDTO = null;
        if (getCaptchaContentParams.width != null || getCaptchaContentParams.height != null) {
            dimensionsDTO = ModelHelper.dimensions((int)((Integer)ObjectHelper.defaultValue((Object)getCaptchaContentParams.width, (Object)0)), (int)((Integer)ObjectHelper.defaultValue((Object)getCaptchaContentParams.height, (Object)0)));
        }
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        ServletHelper.setContentType(httpServletResponse, ContentType.PNG);
        ServletHelper.setNoCache(httpServletResponse);
        try (SerializableInputStream serializableInputStream = this.captchaService.readImage(getCaptchaContentParams.id, (BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)getCaptchaContentParams.group), dimensionsDTO);){
            ServletHelper.writeContents(httpServletResponse, (InputStream)serializableInputStream);
        }
        return null;
    }

    public ResponseEntity<String> newCaptcha(String string, String string2) throws URISyntaxException {
        String string3 = this.captchaService.generate(string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("captcha");
        arrayList.add(string3);
        if (StringHelper.isNotBlank((Object)string)) {
            arrayList.add(string);
        }
        return this.created(this.apiHelper.uriFromApi(arrayList), string3);
    }
}

