/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.AdQuestionsApiImpl;
import org.cyclos.web.rest.model.AdKind;
import org.cyclos.web.rest.model.AdQuestionResult;
import org.cyclos.web.rest.model.AdQuestionView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class AdQuestionsApi {
    @Autowired
    private AdQuestionsApiImpl impl;
    public static final String ANSWER_AD_QUESTION = "/questions/{id}/answer";
    public static final String CREATE_AD_QUESTION = "/marketplace/{ad}/questions";
    public static final String DELETE_AD_QUESTION = "/questions/{id}";
    public static final String GET_AD_QUESTION = "/questions/{id}";
    public static final String SEARCH_UNANSWERED_AD_QUESTIONS = "/{user}/unanswered-questions";

    @RequestMapping(value={"/api/questions/{id}/answer"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> answerAdQuestion(@PathVariable(value="id") String string, @RequestBody(required=true) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /questions/{id}/answer");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.answerAdQuestion(string, string2);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/questions"}, produces={"text/plain", "application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<String> createAdQuestion(@PathVariable(value="ad") String string, @RequestBody(required=true) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/questions");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createAdQuestion(string, string2);
    }

    @RequestMapping(value={"/api/questions/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteAdQuestion(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /questions/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteAdQuestion(string);
    }

    @RequestMapping(value={"/api/questions/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AdQuestionView> getAdQuestion(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /questions/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAdQuestion(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/unanswered-questions"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<AdQuestionResult>> searchUnansweredAdQuestions(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="kind", required=false) AdKind adKind, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/unanswered-questions");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchUnansweredAdQuestionsParams searchUnansweredAdQuestionsParams = new SearchUnansweredAdQuestionsParams();
        searchUnansweredAdQuestionsParams.user = string;
        searchUnansweredAdQuestionsParams.fields = list;
        searchUnansweredAdQuestionsParams.kind = adKind;
        searchUnansweredAdQuestionsParams.page = n;
        searchUnansweredAdQuestionsParams.pageSize = n2;
        searchUnansweredAdQuestionsParams.skipTotalCount = bl;
        return this.impl.searchUnansweredAdQuestions(searchUnansweredAdQuestionsParams);
    }

    public static class SearchUnansweredAdQuestionsParams {
        public String user;
        public static final String USER = "user";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public AdKind kind;
        public static final String KIND = "kind";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
    }
}

