/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.filters;

import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.web.controllers.StaticFileCompressingContentResolver;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="staticFilesGZipFilter")
public class StaticFilesGZipFilter
extends GenericFilterBean {
    public static final String BEAN_NAME = "staticFilesGZipFilter";
    @Autowired
    private CyclosProperties cyclosProperties;
    private File tempDir;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String string = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        File file = new File(this.getServletContext().getRealPath(string));
        if (file.exists()) {
            ContentType contentType = ContentType.getByFileName((String)file.getName());
            if (string.contains("/fonts/")) {
                ServletHelper.setLongCache(httpServletResponse);
            } else {
                ServletHelper.setUseCache(httpServletResponse);
            }
            new StaticContentResolver(file, string, contentType).write(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(404);
        }
    }

    @PostConstruct
    public void initialize() {
        this.tempDir = new File(this.cyclosProperties.getTempDir(), "staticFiles");
    }

    private class StaticContentResolver
    extends StaticFileCompressingContentResolver {
        private final String uri;
        private final ContentType contentType;
        private final File originalFile;

        public StaticContentResolver(File file, String string, ContentType contentType) {
            this.originalFile = file;
            this.uri = string;
            this.contentType = (ContentType)ObjectHelper.defaultValue((Object)contentType, (Object)ContentType.TEXT);
        }

        @Override
        protected ContentType resolveContentType(File file) throws IOException {
            return this.contentType;
        }

        @Override
        protected File resolveGZipFile(File file) {
            File file2 = new File(StaticFilesGZipFilter.this.tempDir, this.uri + ".gz");
            file2.getParentFile().mkdirs();
            return file2;
        }

        @Override
        protected File resolveOriginalFile() throws IOException {
            return this.originalFile;
        }
    }
}

