/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.filters;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="corsFilter")
public class CORSFilter
extends OncePerRequestFilter {
    public static final String BEAN_NAME = "corsFilter";
    private static final String EXPOSE_HEADERS = StringHelper.join(Arrays.asList("Location", "X-Has-Next-Page", "X-Total-Count", "X-Page-Size", "X-Current-Page", "X-Page-Count"), (String)", ");
    @Autowired
    private CyclosProperties cyclosProperties;

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        List list = this.cyclosProperties.getCorsOrigins();
        if (CollectionHelper.isEmpty((Iterable)list)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        httpServletResponse.addHeader("Access-Control-Allow-Origin", this.getCorsOrigin(httpServletRequest.getHeader("Origin"), list));
        httpServletResponse.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, PATCH");
        httpServletResponse.addHeader("Access-Control-Expose-Headers", EXPOSE_HEADERS);
        if (httpServletRequest.getMethod().equalsIgnoreCase("options")) {
            String string = httpServletRequest.getHeader("Access-Control-Request-Headers");
            if (StringHelper.isNotBlank((Object)string)) {
                httpServletResponse.setHeader("Access-Control-Allow-Headers", string);
            }
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.flushBuffer();
            return;
        }
        if ("post".equalsIgnoreCase(httpServletRequest.getMethod())) {
            httpServletResponse.addHeader("Cache-Control", "no-cache");
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private String getCorsOrigin(String string, List<String> list) {
        return list.contains(string) ? string : list.get(0);
    }
}

