/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.system;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.CyclosException;
import org.cyclos.model.system.monitor.SystemMonitorExportResult;
import org.cyclos.services.system.SystemMonitorService;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class SystemMonitorController
extends BaseController {
    @Autowired
    private SystemMonitorService systemMonitorService;

    @PostMapping(value={"/content/system-monitor/export"})
    public void systemReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            SystemMonitorExportResult systemMonitorExportResult = this.systemMonitorService.export();
            ServletHelper.writePDFContents(httpServletResponse, systemMonitorExportResult.getReportName(), (InputStream)systemMonitorExportResult.getReportContent());
        }
        catch (CyclosException cyclosException) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, cyclosException);
        }
    }
}

