/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.system;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.system.imports.AdImportedFileDTO;
import org.cyclos.model.system.imports.GeneralReferenceImportedFileDTO;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.system.imports.PaymentImportedFileDTO;
import org.cyclos.model.system.imports.RecordImportedFileDTO;
import org.cyclos.model.system.imports.TokenImportedFileDTO;
import org.cyclos.model.system.imports.TransferImportedFileDTO;
import org.cyclos.model.system.imports.UserImportedFileDTO;
import org.cyclos.model.system.imports.UserPaymentImportedFileDTO;
import org.cyclos.model.system.imports.UserSendVouchersImportedFileDTO;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.ImportService;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ImportController
extends BaseController {
    @Autowired
    private ImportService importService;

    @PostMapping(value={"/content/import"})
    public void importUsers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="importedFileJSON") String string, @RequestParam(value="type") String string2, @RequestParam(name="confirmationPassword", required=false) String string3) throws IOException {
        try {
            ImportType importType = ImportType.valueOf((String)string2);
            Class<UserImportedFileDTO> clazz = null;
            switch (importType) {
                case USERS_IMPORT: {
                    clazz = UserImportedFileDTO.class;
                    break;
                }
                case RECORDS_IMPORT: {
                    clazz = RecordImportedFileDTO.class;
                    break;
                }
                case ADS_IMPORT: {
                    clazz = AdImportedFileDTO.class;
                    break;
                }
                case GENERAL_REFERENCES_IMPORT: {
                    clazz = GeneralReferenceImportedFileDTO.class;
                    break;
                }
                case TRANSFERS_IMPORT: {
                    clazz = TransferImportedFileDTO.class;
                    break;
                }
                case PAYMENTS_IMPORT: {
                    clazz = PaymentImportedFileDTO.class;
                    break;
                }
                case TOKENS_IMPORT: {
                    clazz = TokenImportedFileDTO.class;
                    break;
                }
                case USER_PAYMENTS_IMPORT: {
                    clazz = UserPaymentImportedFileDTO.class;
                    break;
                }
                case USER_SEND_VOUCHERS_IMPORT: {
                    clazz = UserSendVouchersImportedFileDTO.class;
                }
            }
            if (clazz == null) {
                throw new IllegalStateException("Import type not supported");
            }
            ImportedFileDTO importedFileDTO = (ImportedFileDTO)this.jsonConverter.readValue(string, clazz);
            importedFileDTO.setFileName(multipartFile.getOriginalFilename());
            Long l = this.importService.upload(importedFileDTO, new SerializableInputStream(multipartFile.getInputStream()), string3);
            ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, Collections.singletonMap("id", l));
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }
}

