/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.help;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.access.BasicInitializationData;
import org.cyclos.model.access.Role;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.licensing.BasicLicenseVO;
import org.cyclos.services.contentmanagement.StaticContentService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.controllers.index.IndexController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class HelpController
extends BaseController {
    @Autowired
    private StaticContentService staticContentService;
    @Autowired
    private IndexController indexController;

    @GetMapping(value={"/content/help/admin"})
    public void helpAdmin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.staticContentService.getHelpContent(Role.ADMIN);
        ServletHelper.writeText(httpServletResponse, ContentType.HTML, string);
    }

    @GetMapping(value={"/content/help/user"})
    public ModelAndView helpUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.staticContentService.getHelpContent(Role.MEMBER);
        BasicInitializationData basicInitializationData = this.initializationService.getBasicInitializationData();
        ModelAndView modelAndView = new ModelAndView("help").addAllObjects(this.indexController.indexModel(ServletHelper.getRequestData(), basicInitializationData));
        BasicLicenseVO basicLicenseVO = (BasicLicenseVO)modelAndView.getModel().get("license");
        String string2 = basicLicenseVO.getOrganizationName();
        Object object = this.message(GeneralKeys.Ui.HELP_LICENSED_TO, string2);
        if (!((String)object).contains(string2)) {
            object = "This Cyclos instance is licensed to " + string2;
        }
        modelAndView.addObject("themeUrl", (Object)("/content/themes/" + basicInitializationData.getThemeId() + ".css?_k=" + basicInitializationData.getResourceCacheKey() + "&lastModified=" + basicInitializationData.getThemeLastModified()));
        modelAndView.addObject("licensedTo", object);
        modelAndView.addObject("helpContent", (Object)string);
        return modelAndView;
    }
}

