/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web;

import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.apache.logging.log4j.web.Log4jServletContextListener;
import org.apache.logging.log4j.web.Log4jServletFilter;
import org.cyclos.bootstrap.BootstrapConfiguration;
import org.cyclos.bootstrap.ServicesConfiguration;
import org.cyclos.web.RootWebConfiguration;
import org.cyclos.web.WebConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.DispatcherServlet;

public class WebInitializer
implements WebApplicationInitializer {
    private AnnotationConfigWebApplicationContext rootAppContext;
    private ServletContext servletContext;

    public void onStartup(ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
        this.rootAppContext = new AnnotationConfigWebApplicationContext();
        this.rootAppContext.setServletContext(servletContext);
        this.rootAppContext.register(new Class[]{BootstrapConfiguration.class});
        this.rootAppContext.register(new Class[]{ServicesConfiguration.class});
        this.rootAppContext.register(new Class[]{RootWebConfiguration.class});
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)this.rootAppContext));
        servletContext.addListener(Log4jServletContextListener.class);
        FilterRegistration.Dynamic dynamic = servletContext.addFilter("log4j", Log4jServletFilter.class);
        dynamic.setAsyncSupported(true);
        dynamic.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        FilterRegistration.Dynamic dynamic2 = servletContext.addFilter("characterEncoding", (Filter)new CharacterEncodingFilter("UTF-8", true));
        dynamic2.setAsyncSupported(true);
        dynamic2.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        this.delegatingFilter("requestContextFilter", "/*");
        this.delegatingFilter("requestDataFilter", "/*");
        this.delegatingFilter("corsFilter", "/*");
        this.delegatingFilter("gwtCacheFilter", "/cyclos.gwt/*");
        this.delegatingFilter("staticFilesGZipFilter", "/js/*", "/mobile/*", "/fonts/*");
        this.delegatingFilter("wsGZipFilter", "/web-rpc/*", "/api/*", "/run/*", "/content/profiling/*");
        DispatcherServlet dispatcherServlet = new DispatcherServlet();
        AnnotationConfigWebApplicationContext annotationConfigWebApplicationContext = new AnnotationConfigWebApplicationContext();
        annotationConfigWebApplicationContext.setParent((ApplicationContext)this.rootAppContext);
        annotationConfigWebApplicationContext.setServletConfig(dispatcherServlet.getServletConfig());
        annotationConfigWebApplicationContext.register(new Class[]{WebConfiguration.class});
        dispatcherServlet.setApplicationContext((ApplicationContext)annotationConfigWebApplicationContext);
        ServletRegistration.Dynamic dynamic3 = servletContext.addServlet("dispatcher", (Servlet)dispatcherServlet);
        dynamic3.setLoadOnStartup(1);
        dynamic3.setAsyncSupported(true);
        dynamic3.addMapping(new String[]{"/", "/*"});
    }

    private FilterRegistration.Dynamic delegatingFilter(String string, String ... stringArray) {
        FilterRegistration.Dynamic dynamic = this.servletContext.addFilter(string, DelegatingFilterProxy.class);
        dynamic.setAsyncSupported(true);
        dynamic.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, stringArray);
        return dynamic;
    }
}

