/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web;

import java.util.Set;
import javax.annotation.PostConstruct;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.DateTime;
import org.cyclos.web.app.AppPackage;
import org.cyclos.web.controllers.ControllersPackage;
import org.cyclos.web.rest.RestPackage;
import org.cyclos.web.rest.exceptions.ExceptionResolver;
import org.cyclos.web.rest.model.ValuedEnum;
import org.cyclos.web.rest.root.RestModelMultipartArgumentResolver;
import org.cyclos.web.rpc.WebRpcPackage;
import org.cyclos.web.utils.CustomCommonsMultiPartResolver;
import org.cyclos.web.utils.StringToDateTimeConverter;
import org.cyclos.web.utils.StringToValuedEnumConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.MediaType;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

@EnableWebMvc
@Configuration
@ComponentScan(basePackageClasses={AppPackage.class, RestPackage.class, ControllersPackage.class, WebRpcPackage.class})
public class WebConfiguration
implements WebMvcConfigurer {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    private RequestMappingHandlerAdapter adapter;
    @Autowired
    private CyclosProperties cyclosProperties;

    public void addFormatters(FormatterRegistry formatterRegistry) {
        formatterRegistry.addConverter(String.class, DateTime.class, (Converter)new StringToDateTimeConverter());
        ClassPathScanningCandidateComponentProvider classPathScanningCandidateComponentProvider = new ClassPathScanningCandidateComponentProvider(true);
        classPathScanningCandidateComponentProvider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ValuedEnum.class));
        Set set = classPathScanningCandidateComponentProvider.findCandidateComponents(ValuedEnum.class.getPackage().getName());
        for (BeanDefinition beanDefinition : set) {
            try {
                Class<?> clazz = Class.forName(beanDefinition.getBeanClassName());
                if (!ValuedEnum.class.isAssignableFrom(clazz)) continue;
                formatterRegistry.addConverter(String.class, clazz, new StringToValuedEnumConverter(clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer contentNegotiationConfigurer) {
        contentNegotiationConfigurer.defaultContentType(new MediaType[]{MediaType.ALL});
        contentNegotiationConfigurer.ignoreAcceptHeader(true);
        contentNegotiationConfigurer.favorPathExtension(false);
    }

    @Bean
    public ExceptionResolver exceptionResolver() {
        return new ExceptionResolver();
    }

    @PostConstruct
    public void initialize() {
        HandlerMethodArgumentResolverComposite handlerMethodArgumentResolverComposite = new HandlerMethodArgumentResolverComposite();
        handlerMethodArgumentResolverComposite.addResolver((HandlerMethodArgumentResolver)new RestModelMultipartArgumentResolver(this.jacksonConfiguration.getObjectMapper()));
        handlerMethodArgumentResolverComposite.addResolvers(this.adapter.getArgumentResolvers());
        this.adapter.setArgumentResolvers(handlerMethodArgumentResolverComposite.getResolvers());
    }

    @Bean
    public MultipartResolver multipartResolver() {
        return new CustomCommonsMultiPartResolver();
    }

    @Bean
    public SpringTemplateEngine templateEngine() {
        SpringTemplateEngine springTemplateEngine = new SpringTemplateEngine();
        springTemplateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver());
        springTemplateEngine.setEnableSpringELCompiler(true);
        return springTemplateEngine;
    }

    @Bean
    public SpringResourceTemplateResolver templateResolver() {
        SpringResourceTemplateResolver springResourceTemplateResolver = new SpringResourceTemplateResolver();
        springResourceTemplateResolver.setApplicationContext(this.applicationContext);
        springResourceTemplateResolver.setPrefix("classpath:/templates/");
        springResourceTemplateResolver.setSuffix(".html");
        springResourceTemplateResolver.setTemplateMode(TemplateMode.HTML);
        springResourceTemplateResolver.setCacheable(!this.cyclosProperties.isDevelopment());
        return springResourceTemplateResolver;
    }

    @Bean
    public ThymeleafViewResolver viewResolver() {
        ThymeleafViewResolver thymeleafViewResolver = new ThymeleafViewResolver();
        thymeleafViewResolver.setTemplateEngine((ISpringTemplateEngine)this.templateEngine());
        thymeleafViewResolver.setCache(!this.cyclosProperties.isDevelopment());
        thymeleafViewResolver.setCharacterEncoding("UTF-8");
        return thymeleafViewResolver;
    }
}

