/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.int2of5;

import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5LogicImpl;

public class ITF14LogicImpl
extends Interleaved2Of5LogicImpl {
    public ITF14LogicImpl(ChecksumMode mode, boolean displayChecksum) {
        super(mode, displayChecksum);
    }

    protected String handleChecksum(StringBuffer sb) {
        int msgLen = sb.length();
        if (this.getChecksumMode() == ChecksumMode.CP_AUTO) {
            switch (msgLen) {
                case 13: {
                    return this.doHandleChecksum(sb, ChecksumMode.CP_ADD);
                }
                case 14: {
                    return this.doHandleChecksum(sb, ChecksumMode.CP_CHECK);
                }
            }
            throw new IllegalArgumentException("Message must have a length of exactly 13 or 14 digits. This message has " + msgLen + " characters.");
        }
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            this.verifyMessageLength(msgLen, 13);
        } else {
            this.verifyMessageLength(msgLen, 14);
        }
        return super.handleChecksum(sb);
    }

    private void verifyMessageLength(int actualLength, int expectedLength) {
        if (actualLength != expectedLength) {
            throw new IllegalArgumentException("Message must have a length of exactly " + expectedLength + " digits. This message has " + actualLength + " characters.");
        }
    }
}

