/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.model.utils.ITimeInterval;

public class TimeIntervalValidation
implements PropertyValidation {
    private final ITimeInterval interval;
    private final boolean acceptLessThen;
    private final boolean acceptEqualTo;
    private final boolean acceptGreaterThan;
    private final ValidationError error;

    public TimeIntervalValidation(ITimeInterval iTimeInterval, boolean bl, boolean bl2, boolean bl3, ValidationError validationError) {
        if (iTimeInterval == null || !iTimeInterval.isValid()) {
            throw new IllegalArgumentException("Cannot compare to an invalid interval");
        }
        this.interval = iTimeInterval;
        this.acceptLessThen = bl;
        this.acceptEqualTo = bl2;
        this.acceptGreaterThan = bl3;
        this.error = validationError;
    }

    @Override
    public ValidationError validate(Object object, Object object2, Object object3) {
        if (object3 instanceof ITimeInterval) {
            ITimeInterval iTimeInterval = (ITimeInterval)object3;
            if (!iTimeInterval.isValid()) {
                return null;
            }
            int n = Long.compare(iTimeInterval.getMilliseconds(), this.interval.getMilliseconds());
            if (!this.acceptLessThen && n < 0 || !this.acceptEqualTo && n == 0 || !this.acceptGreaterThan && n > 0) {
                return this.error;
            }
        }
        return null;
    }
}

