/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import java.math.BigDecimal;
import org.cyclos.impl.utils.formatting.BigDecimalFormattable;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.model.utils.ICurrencyAmount;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.coercion.CoercionHelper;

public class ComparableValidation
extends BasePropertyValidation {
    private final Comparable<?> comparable;
    private final boolean acceptNegative;
    private final boolean acceptZero;
    private final boolean acceptPositive;

    public ComparableValidation(Comparable<?> comparable, boolean bl, boolean bl2, boolean bl3, ValidationError validationError) {
        super(validationError);
        this.comparable = comparable;
        this.acceptNegative = bl;
        this.acceptZero = bl2;
        this.acceptPositive = bl3;
    }

    @Override
    protected boolean isValid(Object object, Object object2, Object object3) {
        if (this.comparable == null) {
            return true;
        }
        if (object3 instanceof ICurrencyAmount) {
            object3 = ((ICurrencyAmount)object3).getAmount();
        }
        if (object3 instanceof Comparable) {
            int n;
            Object object4 = this.comparable;
            if (object3 instanceof BigDecimal && object4 instanceof ICurrencyAmount) {
                object4 = ((ICurrencyAmount)object4).getAmount();
            }
            if (object3 instanceof BigDecimal && object4 instanceof BigDecimalFormattable) {
                object4 = ((BigDecimalFormattable)object4).getValue();
            }
            if (!object3.getClass().isInstance(object4)) {
                object4 = CoercionHelper.coerce(object3.getClass(), this.comparable);
            }
            if ((n = object3 instanceof BigDecimal && object4 instanceof BigDecimal ? BigDecimalHelper.compareTo((BigDecimal)((BigDecimal)object3), (BigDecimal)((BigDecimal)object4)) : ((Comparable)object3).compareTo(object4)) < 0) {
                return this.acceptNegative;
            }
            if (n == 0) {
                return this.acceptZero;
            }
            if (n > 0) {
                return this.acceptPositive;
            }
        }
        return true;
    }
}

