/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation;

import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.EntityPropertyValidation;
import org.cyclos.impl.utils.validation.validations.PropertyValidations;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.utils.IIntegerRange;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.Range;
import org.cyclos.model.utils.TimeField;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.MessageKey;

public class Property {
    private final PropertyAccess access;
    private Set<PropertyValidation> validations = new LinkedHashSet<PropertyValidation>();
    private Object display;
    private Property parent;
    private Map<org.cyclos.model.Property<?, ?>, Property> nested;

    public Property(PropertyAccess propertyAccess, Object object) {
        this(propertyAccess);
        this.display = object;
    }

    private Property(PropertyAccess propertyAccess) {
        this.access = propertyAccess;
    }

    public Property add(PropertyValidation propertyValidation) {
        this.validations.add(propertyValidation);
        return this;
    }

    @Deprecated
    public Property allOf(Collection<?> collection) {
        return this.add(PropertyValidations.allOf(collection));
    }

    @Deprecated
    public Property allOf(Object ... objectArray) {
        return this.allOf(Arrays.asList(objectArray));
    }

    public Property anyOf(Collection<?> collection) {
        return this.add(PropertyValidations.anyOf(collection));
    }

    public Property anyOf(Object ... objectArray) {
        return this.anyOf(Arrays.asList(objectArray));
    }

    public Property between(Comparable<?> comparable, Comparable<?> comparable2) {
        if (comparable != null) {
            this.greaterEquals(comparable);
        }
        if (comparable2 != null) {
            this.lessEquals(comparable2);
        }
        return this;
    }

    public Property between(Range<? extends Comparable<?>> range) {
        if (range == null) {
            return this;
        }
        return this.between(range.getMin(), range.getMax());
    }

    public Property betweenExcluding(Comparable<?> comparable, Comparable<?> comparable2) {
        if (comparable != null) {
            this.greaterThan(comparable);
        }
        if (comparable2 != null) {
            this.lessThan(comparable2);
        }
        return this;
    }

    public Property betweenIncludingOnlyFrom(Comparable<?> comparable, Comparable<?> comparable2) {
        if (comparable != null) {
            this.greaterEquals(comparable);
        }
        if (comparable2 != null) {
            this.lessThan(comparable2);
        }
        return this;
    }

    public Property betweenIncludingOnlyTo(Comparable<?> comparable, Comparable<?> comparable2) {
        if (comparable != null) {
            this.greaterThan(comparable);
        }
        if (comparable2 != null) {
            this.lessEquals(comparable2);
        }
        return this;
    }

    public Property captcha(CaptchaConfiguration captchaConfiguration) {
        return this.add(PropertyValidations.captcha(captchaConfiguration));
    }

    public Property characterEncoding() {
        return this.add(PropertyValidations.characterEncoding());
    }

    public Property childOf(Object object, MessageKey messageKey) {
        return this.add(PropertyValidations.childOf(object, messageKey));
    }

    public Property color() {
        return this.add(PropertyValidations.color());
    }

    public Property comparable(Comparable<?> comparable, String string) {
        return this.comparable(comparable, string, null);
    }

    public Property comparable(Comparable<?> comparable, String string, ValidationError validationError) {
        return this.add(PropertyValidations.comparable(comparable, string, validationError));
    }

    public Property date() {
        return this.add(PropertyValidations.date());
    }

    public Property email() {
        return this.add(PropertyValidations.email());
    }

    public <E extends SimpleEntity> Property entity(Class<E> clazz, EntityValidation<E> entityValidation) {
        return this.add(new EntityPropertyValidation<E>(clazz, entityValidation));
    }

    public Property fixedLength(int n) {
        return this.add(PropertyValidations.fixedLength(n));
    }

    public Property futureDate() {
        return this.add(PropertyValidations.futureDate());
    }

    public Property futurePeriod() {
        return this.add(PropertyValidations.futurePeriod());
    }

    public PropertyAccess getAccess() {
        return this.access;
    }

    public Object getDisplay() {
        return this.display;
    }

    public Object getIdentifier() {
        return this.access.getIdentifier();
    }

    public Collection<Property> getNestedProperties() {
        if (this.nested == null) {
            return Collections.emptySet();
        }
        return this.nested.values();
    }

    public Property getParent() {
        return this.parent;
    }

    public Object getValidationIdentifier() {
        return this.access.getValidationIdentifier();
    }

    public Collection<PropertyValidation> getValidations() {
        return this.validations;
    }

    public Object getValue(Object object) {
        return this.access.get(object);
    }

    public Property greaterEquals(Comparable<?> comparable) {
        return this.add(PropertyValidations.greaterEquals(comparable));
    }

    public Property greaterThan(Comparable<?> comparable) {
        return this.add(PropertyValidations.greaterThan(comparable));
    }

    public Property identifier() {
        return this.add(PropertyValidations.identifier());
    }

    public Property internalName(boolean bl) {
        if (bl) {
            this.required();
        }
        return this.maxLength(50).identifier();
    }

    public Property internetAddress() {
        return this.add(PropertyValidations.internetAddress());
    }

    public Property internetAddressList() {
        return this.add(PropertyValidations.internetAddressList());
    }

    public Property invalid() {
        return this.add(PropertyValidations.invalid(false, null));
    }

    public Property invalid(boolean bl) {
        return this.add(PropertyValidations.invalid(bl, null));
    }

    public Property invalid(boolean bl, ValidationError validationError) {
        return this.add(PropertyValidations.invalid(bl, validationError));
    }

    public Property invalid(MessageKey messageKey) {
        return this.invalid(new ValidationError(messageKey));
    }

    public Property invalid(MessageKey messageKey, Object ... objectArray) {
        return this.invalid(new ValidationError(messageKey, objectArray));
    }

    public Property invalid(ValidationError validationError) {
        return this.add(PropertyValidations.invalid(false, validationError));
    }

    public Property ipAddress() {
        return this.add(PropertyValidations.ipAddress());
    }

    public Property latLong() {
        return this.add(PropertyValidations.latLong());
    }

    public Property length(IIntegerRange iIntegerRange) {
        Integer n;
        Integer n2 = iIntegerRange == null ? null : (Integer)iIntegerRange.getMin();
        Integer n3 = n = iIntegerRange == null ? null : (Integer)iIntegerRange.getMax();
        if (n2 == null && n == null) {
            return this;
        }
        if (n2 == null) {
            return this.maxLength(n);
        }
        if (n == null) {
            return this.minLength(n2);
        }
        return this.length(n2, n);
    }

    public Property length(int n, int n2) {
        if (n == n2) {
            return this.fixedLength(n);
        }
        this.minLength(n);
        return this.maxLength(n2);
    }

    public Property lessEquals(Comparable<?> comparable) {
        return this.add(PropertyValidations.lessEquals(comparable));
    }

    public Property lessThan(Comparable<?> comparable) {
        return this.add(PropertyValidations.lessThan(comparable));
    }

    public Property mask(int n) {
        return this.add(PropertyValidations.mask(n));
    }

    public Property maskValue(String string) {
        return this.add(PropertyValidations.maskValue(string));
    }

    public Property maxElements(int n) {
        return this.add(PropertyValidations.maxElements(n));
    }

    public Property maxInterval(int n, TimeField timeField) {
        return this.add(PropertyValidations.maxInterval((ITimeInterval)new TimeInterval(Integer.valueOf(n), timeField)));
    }

    public Property maxLength(int n) {
        return this.add(PropertyValidations.maxLength(n));
    }

    public Property maxWordSize(int n) {
        return this.add(PropertyValidations.maxWordSize(n));
    }

    public Property minElements(int n) {
        return this.add(PropertyValidations.minElements(n));
    }

    public Property minInterval(int n, TimeField timeField) {
        return this.add(PropertyValidations.minInterval((ITimeInterval)new TimeInterval(Integer.valueOf(n), timeField)));
    }

    public Property minLength(int n) {
        return this.add(PropertyValidations.minLength(n));
    }

    public Property mustBeInstanceOf(Class<? extends BaseEntity> clazz) {
        return this.add(PropertyValidations.mustBeInstanceOf(clazz));
    }

    public Property name() {
        return this.maxLength(100).noUrl();
    }

    public Property negativeIntegerNonZero() {
        return this.negativeNonZero(0);
    }

    public Property negativeNonZero(int n) {
        return this.add(PropertyValidations.negativeNonZero(n));
    }

    public Property negativeOrZero() {
        return this.add(PropertyValidations.negativeOrZero());
    }

    public Property nested(org.cyclos.model.Property<?, ?> property, MessageKey messageKey) {
        return this.nestedInternal(property, messageKey);
    }

    public Property nested(org.cyclos.model.Property<?, ?> property, String string) {
        return this.nestedInternal(property, string);
    }

    public Property noFuturePeriod() {
        return this.add(PropertyValidations.noFuturePeriod());
    }

    public Property noneOf(Collection<?> collection) {
        return this.add(PropertyValidations.noneOf(collection));
    }

    public Property noneOf(Object ... objectArray) {
        return this.noneOf(Arrays.asList(objectArray));
    }

    public Property noPropertyOf(Collection<Class<?>> collection) {
        return this.add(PropertyValidations.noPropertyOf(collection));
    }

    public Property notContains(String string) {
        return this.add(PropertyValidations.notContains(string));
    }

    public Property noUrl() {
        return this.add(PropertyValidations.noUrl());
    }

    public Property pastDate() {
        return this.add(PropertyValidations.pastDate());
    }

    public Property period() {
        return this.add(PropertyValidations.period());
    }

    public Property phoneNumber(ConfigurationAccessor configurationAccessor, PhoneNature phoneNature) {
        return this.add(PropertyValidations.phone(configurationAccessor, phoneNature));
    }

    public Property positiveIntegerNonZero() {
        return this.positiveNonZero(0);
    }

    public Property positiveNonZero() {
        return this.add(PropertyValidations.positiveNonZero());
    }

    public Property positiveNonZero(HasCurrency hasCurrency) {
        Currency currency = hasCurrency == null ? null : hasCurrency.getCurrency();
        int n = currency == null ? BigDecimalHelper.MAX_SCALE : currency.getPrecision();
        return this.add(PropertyValidations.positiveNonZero(n));
    }

    public Property positiveNonZero(int n) {
        return this.add(PropertyValidations.positiveNonZero(n));
    }

    public Property positiveOrZero() {
        return this.add(PropertyValidations.positiveOrZero());
    }

    public Property positiveOrZero(HasCurrency hasCurrency) {
        Currency currency = hasCurrency == null ? null : hasCurrency.getCurrency();
        int n = currency == null ? BigDecimalHelper.MAX_SCALE : currency.getPrecision();
        return this.add(PropertyValidations.positiveOrZero(n));
    }

    public Property range(RangeOptionalType rangeOptionalType) {
        return this.add(PropertyValidations.range(rangeOptionalType));
    }

    public Property regex(String string) {
        return this.add(PropertyValidations.regex(string));
    }

    public Property required() {
        return this.add(PropertyValidations.required());
    }

    public Property timeInterval() {
        return this.positiveOrZero().maxInterval(100, TimeField.YEARS);
    }

    public String toString() {
        return this.access.toString();
    }

    public Property unique(String string, AbstractJPAQuery<?, ?> abstractJPAQuery) {
        if (abstractJPAQuery == null) {
            return this;
        }
        return this.add(PropertyValidations.unique(string, abstractJPAQuery));
    }

    public Property url() {
        return this.add(PropertyValidations.url());
    }

    private Property nestedInternal(org.cyclos.model.Property<?, ?> property, Object object) {
        Property property2;
        if (this.nested == null) {
            this.nested = new LinkedHashMap();
        }
        if ((property2 = this.nested.get(property)) == null) {
            property2 = new Property(new BeanPropertyAccess(property), object);
            property2.parent = this;
            this.nested.put(property, property2);
        }
        return property2;
    }
}

