/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.utils.ParameterVO;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;

public enum MailTemplateVariable implements HasMessageKey
{
    SALUTATION,
    UNSUBSCRIBE,
    SENT_TO,
    NO_REPLY,
    SUBJECT,
    MESSAGE,
    EMAIL;


    public static MailTemplateVariable variable(String string) {
        try {
            string = StringHelper.transformCase((String)string, (boolean)true, (char)'_');
            return MailTemplateVariable.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public MessageKey getMessageKey() {
        switch (this.ordinal()) {
            case 0: {
                return ContentManagementKeys.StaticContents.VARIABLE_SALUTATION;
            }
            case 1: {
                return ContentManagementKeys.StaticContents.VARIABLE_UNSUBSCRIBE;
            }
            case 2: {
                return ContentManagementKeys.StaticContents.VARIABLE_SENT_TO;
            }
            case 3: {
                return ContentManagementKeys.StaticContents.VARIABLE_NO_REPLY;
            }
            case 4: {
                return ContentManagementKeys.StaticContents.VARIABLE_SUBJECT;
            }
            case 5: {
                return ContentManagementKeys.StaticContents.VARIABLE_MESSAGE;
            }
            case 6: {
                return ContentManagementKeys.StaticContents.VARIABLE_EMAIL;
            }
        }
        return null;
    }

    public ParameterVO toParameter(TranslationHandler translationHandler) {
        return new ParameterVO(StringHelper.camelize((String)this.name()), translationHandler.message(this.getMessageKey(), new Object[0]));
    }
}

