/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.model.utils.FileInfo;

public class CustomNotification {
    private BasicUser user;
    private boolean email;
    private String emailSubject;
    private String emailBody;
    private List<FileInfo> emailAttachments;
    private boolean sms;
    private String smsMessage;
    private boolean smsEvenIfDisabled;
    private boolean app;
    private String appTitle;
    private String appBody;
    private String appCustomUrl;
    private String appImageUrl;
    private Map<String, String> appVariables;
    private String appAndroidIconColor;
    private boolean appIosUseBadge = true;

    public void addAppVariable(String string, String string2) {
        if (this.appVariables == null) {
            this.appVariables = new HashMap<String, String>();
        }
        this.appVariables.put(string, string2);
    }

    public void addEmailAttachment(FileInfo fileInfo) {
        if (this.emailAttachments == null) {
            this.emailAttachments = new ArrayList<FileInfo>();
        }
        this.emailAttachments.add(fileInfo);
    }

    public String getAppAndroidIconColor() {
        return this.appAndroidIconColor;
    }

    public String getAppBody() {
        return this.appBody;
    }

    public String getAppCustomUrl() {
        return this.appCustomUrl;
    }

    public String getAppImageUrl() {
        return this.appImageUrl;
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public Map<String, String> getAppVariables() {
        return this.appVariables;
    }

    public List<FileInfo> getEmailAttachments() {
        return this.emailAttachments;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getSmsMessage() {
        return this.smsMessage;
    }

    public BasicUser getUser() {
        return this.user;
    }

    public boolean isApp() {
        return this.app;
    }

    public boolean isAppIosUseBadge() {
        return this.appIosUseBadge;
    }

    public boolean isEmail() {
        return this.email;
    }

    public boolean isSms() {
        return this.sms;
    }

    public boolean isSmsEvenIfDisabled() {
        return this.smsEvenIfDisabled;
    }

    @JsonIgnore
    public boolean isValid() {
        if (this.user == null) {
            return false;
        }
        if (this.email && (this.emailBody == null || this.emailSubject == null)) {
            return false;
        }
        if (this.sms && this.smsMessage == null) {
            return false;
        }
        return !this.app || this.appBody != null && this.appTitle != null;
    }

    public void setApp(boolean bl) {
        this.app = bl;
    }

    public void setAppAndroidIconColor(String string) {
        this.appAndroidIconColor = string;
    }

    public void setAppBody(String string) {
        this.appBody = string;
    }

    public void setAppCustomUrl(String string) {
        this.appCustomUrl = string;
    }

    public void setAppImageUrl(String string) {
        this.appImageUrl = string;
    }

    public void setAppIosUseBadge(boolean bl) {
        this.appIosUseBadge = bl;
    }

    public void setAppTitle(String string) {
        this.appTitle = string;
    }

    public void setAppVariables(Map<String, String> map) {
        this.appVariables = map;
    }

    public void setEmail(boolean bl) {
        this.email = bl;
    }

    public void setEmailAttachments(List<FileInfo> list) {
        this.emailAttachments = list;
    }

    public void setEmailBody(String string) {
        this.emailBody = string;
    }

    public void setEmailSubject(String string) {
        this.emailSubject = string;
    }

    public void setSms(boolean bl) {
        this.sms = bl;
    }

    public void setSmsEvenIfDisabled(boolean bl) {
        this.smsEvenIfDisabled = bl;
    }

    public void setSmsMessage(String string) {
        this.smsMessage = string;
    }

    public void setUser(BasicUser basicUser) {
        this.user = basicUser;
    }
}

