/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.formatting;

import com.mysema.commons.lang.CloseableIterator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.model.EntityVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.TransformedCloseableIterator;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.TransformedList;
import org.cyclos.utils.TransformedMap;
import org.cyclos.utils.TransformedSet;

public class DataTranslationProxy {
    private static final int MAX_CACHE_SIZE = (int)Runtime.getRuntime().maxMemory() / 0x100000;
    private static final Map<Class<?>, Class<?>> CLASS_CACHE = new WeakHashMap();

    public static final <T> T proxy(T t, DataTranslationHandler dataTranslationHandler) {
        return DataTranslationProxy.proxy(t, dataTranslationHandler, InvocationContext.getSessionData().getConfiguration().getLanguage());
    }

    public static final <T> T proxy(T t, DataTranslationHandler dataTranslationHandler, Language language) {
        return DataTranslationProxy.proxy(t, dataTranslationHandler, language, new IdentityHashMap<Object, Proxy>());
    }

    public static <T> T proxy(T t, DataTranslationHandler dataTranslationHandler, Language language, IdentityHashMap<Object, Proxy> identityHashMap) {
        if (t == null || t instanceof Proxy || Modifier.isFinal(t.getClass().getModifiers())) {
            return t;
        }
        Proxy proxy = identityHashMap.get(t);
        if (proxy != null) {
            return (T)proxy;
        }
        if (identityHashMap.size() > MAX_CACHE_SIZE) {
            identityHashMap.clear();
        }
        if (t instanceof ProcessableForProxying) {
            proxy = (Proxy)ClassHelper.instantiate(DataTranslationProxy.getProxyClass(t.getClass()));
            if (t instanceof SimpleEntity) {
                FieldHelper.set((Object)proxy, (String)EntityVO.ID.getName(), (Object)((SimpleEntity)t).getId());
            }
            proxy.setHandler((MethodHandler)new DataTranslationMethodHandler(t, dataTranslationHandler, language, identityHashMap));
            identityHashMap.put(t, proxy);
            return (T)proxy;
        }
        if (t instanceof Set) {
            return (T)new TransformedSet((Set)t, object -> DataTranslationProxy.proxy(object, dataTranslationHandler, language, identityHashMap));
        }
        if (t instanceof List) {
            return (T)new TransformedList((List)t, object -> DataTranslationProxy.proxy(object, dataTranslationHandler, language, identityHashMap));
        }
        if (t instanceof Map) {
            return (T)new TransformedMap((Map)t, object -> DataTranslationProxy.proxy(object, dataTranslationHandler, language, identityHashMap), object -> DataTranslationProxy.proxy(object, dataTranslationHandler, language, identityHashMap));
        }
        if (t instanceof Iterator) {
            boolean bl = false;
            if (t instanceof DataIterator) {
                bl = ((DataIterator)t).isPartialData();
            }
            return (T)CloseableIteratorHelper.asDataIterator((CloseableIterator)new TransformedCloseableIterator((Iterator)t, object -> DataTranslationProxy.proxy(object, dataTranslationHandler, language, identityHashMap)), (boolean)bl);
        }
        return t;
    }

    public static final <T> T unproxy(Object object) {
        MethodHandler methodHandler;
        if (object instanceof Proxy && (methodHandler = ProxyFactory.getHandler((Proxy)((Proxy)object))) instanceof DataTranslationMethodHandler) {
            return (T)((DataTranslationMethodHandler)methodHandler).delegate;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Class<?> getProxyClass(Class<?> clazz) {
        Class clazz2 = CLASS_CACHE.get(clazz);
        if (clazz2 == null) {
            Map<Class<?>, Class<?>> map = CLASS_CACHE;
            synchronized (map) {
                clazz2 = CLASS_CACHE.get(clazz);
                if (clazz2 == null) {
                    ProxyFactory proxyFactory = new ProxyFactory();
                    proxyFactory.setSuperclass(clazz);
                    clazz2 = proxyFactory.createClass();
                    CLASS_CACHE.put(clazz, clazz2);
                }
            }
        }
        return clazz2;
    }

    private static class DataTranslationMethodHandler
    implements MethodHandler {
        private DataTranslationHandler dataTranslationHandler;
        private Language language;
        private Object delegate;
        private BaseEntity entity;
        private IdentityHashMap<Object, Proxy> resolved;

        public DataTranslationMethodHandler(Object object, DataTranslationHandler dataTranslationHandler, Language language, IdentityHashMap<Object, Proxy> identityHashMap) {
            this.delegate = object;
            this.entity = (BaseEntity)ObjectHelper.ifType((Object)object, BaseEntity.class);
            this.dataTranslationHandler = dataTranslationHandler;
            this.language = language;
            this.resolved = identityHashMap;
        }

        public Object invoke(Object object, Method method, Method method2, Object[] objectArray) throws Throwable {
            String string;
            if (method.getName().equals("toString") && objectArray.length == 0) {
                return "Proxy for " + String.valueOf(this.delegate);
            }
            if (method.getName().equals("equals") && objectArray.length == 1) {
                return this.delegate.equals(objectArray[0]);
            }
            if (method.getName().equals("hashCode") && objectArray.length == 0) {
                return this.delegate.hashCode();
            }
            String string2 = null;
            if (this.entity != null && String.class.equals(method.getReturnType()) && !method.getName().startsWith("set")) {
                try {
                    string2 = PropertyHelper.getPropertyName((Method)method);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string3 = string = string2 == null ? null : this.dataTranslationHandler.getValue(this.language, this.entity, string2, false);
            if (string != null) {
                return string;
            }
            Object object2 = method.invoke(this.delegate, objectArray);
            if (object2 instanceof ProcessableForProxying) {
                object2 = DataTranslationProxy.proxy((ProcessableForProxying)object2, this.dataTranslationHandler, this.language, this.resolved);
            }
            return object2;
        }
    }
}

