/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.impl.utils.cache.AccessorCacheValue;
import org.cyclos.impl.utils.cache.EntityAccessorCacheValue;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.utils.ObjectHelper;
import org.springframework.context.ApplicationContext;

public class CollectionAccessorCacheValue
extends AccessorCacheValue {
    private static final long serialVersionUID = 1L;
    private final Collection<AccessorCacheValue> collection;
    private final Class<? extends SimpleEntity> entityType;
    private final Collection<Long> ids;

    CollectionAccessorCacheValue(Collection<AccessorCacheValue> collection) {
        Class<? extends SimpleEntity> clazz = null;
        HashSet<Long> hashSet = null;
        for (AccessorCacheValue accessorCacheValue : collection) {
            if (accessorCacheValue instanceof EntityAccessorCacheValue) {
                EntityAccessorCacheValue entityAccessorCacheValue = (EntityAccessorCacheValue)accessorCacheValue;
                if (clazz == null) {
                    clazz = entityAccessorCacheValue.getEntityClass();
                } else if (!clazz.equals(entityAccessorCacheValue.getEntityClass())) {
                    clazz = null;
                    hashSet = null;
                    break;
                }
                if (hashSet == null) {
                    hashSet = collection instanceof Set ? new HashSet(collection.size()) : new ArrayList(collection.size());
                }
                hashSet.add(entityAccessorCacheValue.getId());
                continue;
            }
            clazz = null;
            hashSet = null;
            break;
        }
        this.collection = clazz == null ? collection : null;
        this.entityType = clazz;
        this.ids = hashSet;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CollectionAccessorCacheValue collectionAccessorCacheValue = (CollectionAccessorCacheValue)object;
        return Objects.equals(this.collection, collectionAccessorCacheValue.collection) && Objects.equals(this.entityType, collectionAccessorCacheValue.entityType) && Objects.equals(this.ids, collectionAccessorCacheValue.ids);
    }

    public Collection<AccessorCacheValue> getCollection() {
        return this.collection;
    }

    public int hashCode() {
        return Objects.hash(this.collection, this.entityType, this.ids);
    }

    public String toString() {
        return "CollectionAccessorCacheValue [collection=" + String.valueOf(this.collection) + ", entityType=" + String.valueOf(this.entityType) + ", ids=" + String.valueOf(this.ids) + "]";
    }

    @Override
    public Object unwrap(ApplicationContext applicationContext) {
        Collection collection = (Collection)ObjectHelper.defaultValue(this.collection, this.ids);
        Collector collector = Collectors.toCollection(() -> collection instanceof Set ? new HashSet(collection.size()) : new ArrayList(collection.size()));
        if (this.collection != null) {
            return this.collection.stream().map(accessorCacheValue -> accessorCacheValue.unwrap(applicationContext)).collect(collector);
        }
        RawEntityManagerHandler rawEntityManagerHandler = (RawEntityManagerHandler)applicationContext.getBean(RawEntityManagerHandler.class);
        EntityManager entityManager = rawEntityManagerHandler.getEntityManager();
        ArrayList<Long> arrayList = new ArrayList<Long>(this.ids);
        arrayList.removeIf(l -> entityManager.contains(entityManager.getReference(this.entityType, l)));
        if (!arrayList.isEmpty()) {
            entityManager.createQuery("from " + this.entityType.getName() + " e where e.id in :ids").setParameter("ids", arrayList).getResultList();
        }
        return this.ids.stream().map(l -> (SimpleEntity)entityManager.find(this.entityType, l)).collect(collector);
    }
}

