/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.CaseForEqBuilder;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.PathBuilderFactory;
import com.querydsl.jpa.JPAQueryBase;
import com.querydsl.jpa.JPQLQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.utils.BreakException;
import org.cyclos.impl.utils.persistence.BaseEntityManagerHandler;
import org.cyclos.impl.utils.persistence.CacheFlusher;
import org.cyclos.model.EntityModel;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.system.fields.BaseValueForSearchDTO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.fields.CustomFieldValueForSearchDTO;
import org.cyclos.model.users.users.AddressFieldValueForSearchDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicProfileFieldValueForSearchDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.IDatePeriod;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.Range;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.MethodHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.StringHelper;

public class QueryHelper {
    private static final PathBuilderFactory PATH_BUILDER_FACTORY = new PathBuilderFactory();
    private static final String[] ORDER_FIELDS = new String[]{"name", "value", "id"};

    public static void applyExport(QueryParameters queryParameters) {
        queryParameters.setCurrentPage(Integer.valueOf(0));
        queryParameters.setPageSize(Integer.valueOf(InvocationContext.getSessionData().getConfiguration().getMaxResults()));
    }

    public static void applyMaxResultsOnMap(QueryParameters queryParameters) {
        Integer n = (Integer)queryParameters.getAttribute("originalPageSize");
        if (n != null) {
            queryParameters.setPageSize(n);
        }
        QueryHelper.doApplyMaxResults(queryParameters, InvocationContext.getSessionData().getConfiguration().getMaxResultsOnMap());
    }

    public static <T> Page<T> buildPage(SessionData sessionData, List<T> list, Integer n, Integer n2) {
        List list2;
        int n3 = n2 == null || n2 < 0 ? 0 : n2;
        int n4 = n == null || n < 0 ? 40 : n;
        int n5 = list.size();
        int n6 = Math.max(0, (int)Math.ceil((double)n5 / (double)n4) - 1);
        n3 = Math.min(Math.max(0, n3), n6);
        try {
            int n7 = n4 * n3;
            int n8 = Math.min(n7 + n4, n5);
            list2 = list.subList(n7, n8);
        }
        catch (Exception exception) {
            list2 = Collections.emptyList();
        }
        return PageImpl.withTotalCount(list2, (int)n5, (int)n4, (int)n3);
    }

    public static <T> Page<T> buildPage(SessionData sessionData, List<T> list, QueryParameters queryParameters) {
        return QueryHelper.buildPage(sessionData, list, queryParameters.getPageSize(), queryParameters.getCurrentPage());
    }

    public static Expression<Double> days(Path<TimeInterval> path) {
        return Expressions.template(Double.class, (String)"{0}.number * case {0}.field when 'YEARS' then 365 when 'MONTHS' then 30 when 'WEEKS' then 7 when 'DAYS' then 1 when 'HOURS' then 1/24 when 'MINUTES' then 1/(24*60) when 'SECONDS' then 1/(24*60*60) when 'MILLIS' then 1/(24*60*60*1000) end", (Object[])new Object[]{path});
    }

    public static <T> Page<T> emptyPage(SessionData sessionData, Integer n, Integer n2) {
        int n3 = n2 == null || n2 < 0 ? 0 : n2;
        int n4 = n == null || n < 0 ? 40 : n;
        n4 = Math.min(n4, sessionData.getConfiguration().getMaxResults());
        return PageImpl.empty((int)n4, (int)n3);
    }

    public static <T> Page<T> emptyPage(SessionData sessionData, QueryParameters queryParameters) {
        return QueryHelper.emptyPage(sessionData, queryParameters.getPageSize(), queryParameters.getCurrentPage());
    }

    public static void ensurePageData(QueryParameters queryParameters) {
        queryParameters.setPageSize(Integer.valueOf(QueryHelper.getPageSize(queryParameters.getPageSize())));
        queryParameters.setCurrentPage(Integer.valueOf(QueryHelper.getCurrentPage(queryParameters.getCurrentPage())));
    }

    public static <E extends Enum<E>> NumberExpression<Integer> enumOrdinal(EnumPath<E> enumPath) {
        Enum[] enumArray;
        Class clazz = enumPath.getType();
        CaseForEqBuilder.Cases cases = null;
        for (Enum enum_ : enumArray = (Enum[])MethodHelper.invoke((Class)clazz, (String)"values", (Object[])new Object[0])) {
            if (cases == null) {
                cases = enumPath.when((Object)enum_).thenNumber(Expressions.constant((Object)enum_.ordinal()));
                continue;
            }
            cases.when((Object)enum_).then(Expressions.constant((Object)enum_.ordinal()));
        }
        return (NumberExpression)cases.otherwise(Expressions.constant((Object)-1));
    }

    public static int getCurrentPage(Integer n) {
        return (n = (Integer)ObjectHelper.defaultValue((Object)n, (Object)0)) < 0 ? 0 : n;
    }

    public static int getPageSize(Integer n) {
        return (n = (Integer)ObjectHelper.defaultValue((Object)n, (Object)40)) < 0 ? 40 : n;
    }

    public static String getUserDisplay(SessionData sessionData, Long l, String string, String string2, String string3) {
        if (sessionData.isSystem() || sessionData.isAdmin()) {
            return string2;
        }
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser == null) {
            return string3;
        }
        Long l2 = basicUser.getUser().getId();
        if (basicUser.getId().equals(l) || l2.equals(l)) {
            return string2;
        }
        if (sessionData.isBroker() && StringHelper.isNotBlank((Object)string) && StringHelper.splitTrimming((String)string, (String)",").contains(l2.toString())) {
            return string2;
        }
        return string3;
    }

    public static void internalApplyMaxResults(SessionData sessionData, QueryParameters queryParameters) {
        QueryHelper.doApplyMaxResults(queryParameters, sessionData.getConfiguration().getMaxResults());
    }

    public static boolean isUnlimited(QueryParameters queryParameters) {
        return queryParameters != null && queryParameters.getPageSize() != null && queryParameters.getPageSize() == Integer.MAX_VALUE && queryParameters.getCurrentPage() != null && queryParameters.getCurrentPage() == 0;
    }

    public static <Q extends QueryParameters> Q newQuery(Class<Q> clazz) {
        QueryParameters queryParameters = (QueryParameters)ClassHelper.instantiate(clazz);
        queryParameters.setCurrentPage(Integer.valueOf(0));
        queryParameters.setPageSize(Integer.valueOf(40));
        return (Q)queryParameters;
    }

    public static OrderSpecifier<?> orderSpecifier(EntityPath<?> entityPath) {
        return QueryHelper.orderSpecifier(entityPath, true);
    }

    public static OrderSpecifier<?> orderSpecifier(EntityPath<?> entityPath, boolean bl) {
        Path path = null;
        for (String string : ORDER_FIELDS) {
            try {
                path = (Path)FieldHelper.get(entityPath, (String)string);
                break;
            }
            catch (Exception exception) {
            }
        }
        OrderSpecifier orderSpecifier = (OrderSpecifier)MethodHelper.invoke(path, (String)(bl ? "asc" : "desc"), (Object[])new Object[0]);
        return orderSpecifier.nullsLast();
    }

    public static <RT, Q extends JPAQueryBase<?, Q>> Page<RT> page(Q q, SessionData sessionData, Integer n, Integer n2, boolean bl, Expression<RT> expression) {
        int n3;
        Integer n4;
        List<Object> list;
        int n5 = n == null || n < 0 ? 0 : n;
        int n6 = n2 == null || n2 < 0 ? 40 : n2;
        bl |= sessionData.getConfiguration().isSkipTotalCount();
        boolean bl2 = false;
        if (n6 == Integer.MAX_VALUE) {
            list = q.select(expression).fetch();
            n4 = list.size();
        } else if (n6 == 0) {
            n4 = (int)q.fetchCount();
            list = Collections.emptyList();
        } else if (bl) {
            n3 = n6 + 1;
            list = ((JPQLQuery)((JPQLQuery)q.select(expression).limit((long)n3)).offset((long)(n5 * n6))).fetch();
            bl2 = list.size() > n6;
            list = list.subList(0, Math.min(n6, list.size()));
            n4 = null;
        } else {
            n4 = (int)q.fetchCount();
            list = n4 == 0 ? Collections.emptyList() : ((JPQLQuery)((JPQLQuery)q.select(expression).limit((long)n6)).offset((long)(n5 * n6))).fetch();
        }
        if (n4 != null) {
            n3 = Math.max(0, (int)Math.ceil((double)n4.intValue() / (double)n6) - 1);
            if (n5 > n3) {
                return QueryHelper.page(q, sessionData, n3, n6, bl, expression);
            }
            return PageImpl.withTotalCount((List)list, (int)n4, (int)n6, (int)n5);
        }
        return PageImpl.withNextPage(list, (int)n6, (int)n5, (boolean)bl2);
    }

    public static <RT, Q extends JPAQueryBase<?, Q>> Page<RT> page(Q q, SessionData sessionData, QueryParameters queryParameters, Expression<RT> expression) {
        return QueryHelper.page(q, sessionData, queryParameters.getCurrentPage(), queryParameters.getPageSize(), queryParameters.isSkipTotalCount(), expression);
    }

    public static <T> PathBuilder<T> pathBuilder(Class<T> clazz) {
        return PATH_BUILDER_FACTORY.create(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long processBatch(BaseEntityManagerHandler baseEntityManagerHandler, Iterator<T> iterator, Consumer<T> consumer) {
        long l = 0L;
        try (CacheFlusher cacheFlusher = InvocationContext.newCacheFlusher();){
            while (iterator.hasNext()) {
                try {
                    ++l;
                    consumer.accept(iterator.next());
                    cacheFlusher.flush();
                }
                catch (BreakException breakException) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            if (iterator instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception exception) {}
            }
        }
        return l;
    }

    public static boolean useAnyParameter(Collection<Object> collection) {
        return collection.stream().anyMatch(QueryHelper::useParameter);
    }

    public static boolean useParameter(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IInternalNamedEntity) {
            IInternalNamedEntity iInternalNamedEntity = (IInternalNamedEntity)object;
            return iInternalNamedEntity.getId() != null || StringHelper.isNotBlank((Object)iInternalNamedEntity.getInternalName());
        }
        if (object instanceof BaseValueForSearchDTO) {
            CustomFieldVO customFieldVO = null;
            if (object instanceof CustomFieldValueForSearchDTO) {
                customFieldVO = ((CustomFieldValueForSearchDTO)object).getField();
            } else if (object instanceof BasicProfileFieldValueForSearchDTO) {
                customFieldVO = ((BasicProfileFieldValueForSearchDTO)object).getField();
            } else if (object instanceof AddressFieldValueForSearchDTO && ((AddressFieldValueForSearchDTO)object).getAddressField() != null) {
                customFieldVO = BasicProfileField.ADDRESS;
            }
            if (!QueryHelper.useParameter(customFieldVO)) {
                return false;
            }
            BaseValueForSearchDTO baseValueForSearchDTO = (BaseValueForSearchDTO)object;
            if (QueryHelper.useParameter(baseValueForSearchDTO.getBooleanValue()) || QueryHelper.useParameter(baseValueForSearchDTO.getDatePeriod()) || QueryHelper.useParameter(baseValueForSearchDTO.getDecimalRange()) || QueryHelper.useParameter(baseValueForSearchDTO.getIntegerRange()) || QueryHelper.useParameter(baseValueForSearchDTO.getStringValue())) {
                return true;
            }
            if (baseValueForSearchDTO instanceof CustomFieldValueForSearchDTO) {
                CustomFieldValueForSearchDTO customFieldValueForSearchDTO = (CustomFieldValueForSearchDTO)baseValueForSearchDTO;
                return QueryHelper.useParameter(customFieldValueForSearchDTO.getEnumeratedValues()) || QueryHelper.useParameter(customFieldValueForSearchDTO.getLinkedEntityValues()) || QueryHelper.useParameter(customFieldValueForSearchDTO.getDynamicValues());
            }
            return false;
        }
        if (object instanceof UserLocatorVO) {
            return ModelHelper.isValid((UserLocatorVO)((UserLocatorVO)object));
        }
        if (object instanceof EntityModel) {
            return ((EntityModel)object).getId() != null;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        if (object instanceof Collection) {
            return !((Collection)object).isEmpty();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length > 0;
        }
        if (object instanceof IDatePeriod) {
            IDatePeriod iDatePeriod = (IDatePeriod)object;
            return iDatePeriod.getBegin() != null || iDatePeriod.getEnd() != null;
        }
        if (object instanceof Range) {
            Range range = (Range)object;
            return range.getMin() != null || range.getMax() != null;
        }
        return true;
    }

    private static void doApplyMaxResults(QueryParameters queryParameters, int n) {
        QueryHelper.ensurePageData(queryParameters);
        if (queryParameters.getPageSize() > n) {
            queryParameters.setAttribute("originalPageSize", (Object)queryParameters.getPageSize());
            queryParameters.setPageSize(Integer.valueOf(n));
        }
    }
}

