/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.List;
import org.cyclos.entities.access.AccessClientPrincipalType;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.QAccessClientPrincipalType;
import org.cyclos.entities.access.QPasswordType;
import org.cyclos.entities.access.QTokenPrincipalType;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QUserAccountType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.contentmanagement.QDocumentCategory;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.QAdCustomField;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.users.ContactCustomField;
import org.cyclos.entities.users.PrivacyControl;
import org.cyclos.entities.users.QContactCustomField;
import org.cyclos.entities.users.QPrivacyControl;
import org.cyclos.entities.users.QUserRecordType;
import org.cyclos.entities.users.RecordCustomField;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.UserRecordType;
import org.cyclos.impl.users.SystemProductAccessor;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.impl.users.productresolvers.ProductUserAdFieldPropertyResolver;
import org.cyclos.impl.users.productresolvers.UserAccessClientsResolver;
import org.cyclos.impl.users.productresolvers.UserContactFieldsResolver;
import org.cyclos.impl.users.productresolvers.UserPasswordActionsResolver;
import org.cyclos.impl.users.productresolvers.UserRecordTypesResolver;
import org.cyclos.impl.users.productresolvers.UserTokenTypesResolver;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.springframework.context.ApplicationContext;

public class SystemUserManagementProductAccessor
extends SystemProductAccessor
implements UserManagementProductAccessor {
    public SystemUserManagementProductAccessor(ApplicationContext applicationContext, Network network) {
        super(applicationContext, network);
    }

    @Override
    public List<TransferType> getChargebackPaymentsToUser() {
        return this.listTransferTypes(TransferTypeDirection.USER_TO_USER, TransferTypeDirection.SYSTEM_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getCreateTicketsAsUser() {
        return this.listPaymentTypes(null, null, null, BuiltInChannel.TICKET, TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<DocumentCategory> getDocumentCategoryManage() {
        return this.selectFrom(QDocumentCategory.documentCategory).fetch();
    }

    @Override
    public List<PaymentTransferType> getExternalPaymentsAsUser() {
        return this.listPaymentTypes(TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getPaymentsAsUser() {
        return this.listPaymentTypes(TransferTypeDirection.USER_TO_USER, TransferTypeDirection.USER_TO_SELF, TransferTypeDirection.USER_TO_SYSTEM);
    }

    @Override
    public List<PrivacyControl> getPrivacyControls() {
        return this.selectFrom(QPrivacyControl.privacyControl).fetch();
    }

    @Override
    public List<PaymentTransferType> getRequestPaymentsAsUser() {
        return this.listPaymentTypes(TransferTypeDirection.USER_TO_USER, TransferTypeDirection.USER_TO_SYSTEM);
    }

    @Override
    public List<PaymentTransferType> getSelfPaymentsAsUser() {
        return this.listPaymentTypes(TransferTypeDirection.USER_TO_SELF);
    }

    @Override
    public List<PaymentTransferType> getSystemPaymentsAsUser() {
        return this.listPaymentTypes(TransferTypeDirection.USER_TO_SYSTEM);
    }

    @Override
    public BooleanPropertiesHolder<AccessClientPrincipalType> getUserAccessClients() {
        return this.toBooleanPropertiesHolder(QAccessClientPrincipalType.accessClientPrincipalType, UserAccessClientsResolver.class);
    }

    @Override
    public List<UserAccountType> getUserAccountsAccess() {
        return this.selectFrom(QUserAccountType.userAccountType).fetch();
    }

    @Override
    public BooleanPropertiesHolder<AdCustomField> getUserAdFields() {
        return this.toBooleanPropertiesHolder(QAdCustomField.adCustomField, ProductUserAdFieldPropertyResolver.class);
    }

    @Override
    public BooleanPropertiesHolder<ContactCustomField> getUserContactFields() {
        return this.toBooleanPropertiesHolder(QContactCustomField.contactCustomField, UserContactFieldsResolver.class);
    }

    @Override
    public List<CustomOperation> getUserCustomOperationsRun() {
        return this.listCustomOperations(CustomOperationScope.USER, CustomOperationScope.ADVERTISEMENT, CustomOperationScope.RECORD);
    }

    @Override
    public BooleanPropertiesHolder<PasswordType> getUserPasswordActions() {
        return this.toBooleanPropertiesHolder(QPasswordType.passwordType, UserPasswordActionsResolver.class);
    }

    @Override
    public List<PaymentTransferType> getUserPaymentRequestsSendToSystem() {
        return this.listPaymentTypes(TransferTypeDirection.SYSTEM_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getUserPaymentRequestsSendToUser() {
        return this.listPaymentTypes(TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public List<PaymentTransferType> getUserPaymentsAsUser() {
        return this.listPaymentTypes(TransferTypeDirection.USER_TO_USER);
    }

    @Override
    public BooleanPropertiesHolder<RecordCustomField> getUserRecordFields(UserRecordType userRecordType) {
        return this.forRecordFields((RecordType)userRecordType);
    }

    @Override
    public BooleanPropertiesHolder<UserRecordType> getUserRecordTypes() {
        return this.toBooleanPropertiesHolder(QUserRecordType.userRecordType, UserRecordTypesResolver.class);
    }

    @Override
    public BooleanPropertiesHolder<TokenPrincipalType> getUserTokenTypes() {
        return this.toBooleanPropertiesHolder(QTokenPrincipalType.tokenPrincipalType, UserTokenTypesResolver.class);
    }

    @Override
    public List<TransferFilter> getUserTransferFilters() {
        return this.listTransferFilter(AccountTypeNature.USER);
    }

    @Override
    public List<UserWizard> getUserWizards() {
        return this.listUserWizards();
    }

    @Override
    public boolean isEditUserProfile() {
        return true;
    }

    @Override
    public boolean isIncludeBalancesInExportUsersCSV() {
        return true;
    }
}

